/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import com.google.common.math.IntMath;
import java.io.IOException;
import org.apache.commons.math.complex.Complex;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Deferrable;
import org.renjin.invoke.annotations.GroupGeneric;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.NamedFlag;
import org.renjin.primitives.Vectors;
import org.renjin.primitives.summary.DeferredMean;
import org.renjin.primitives.summary.DeferredSum;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexArrayVector;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class Summary {
    private Summary() {
    }

    @Builtin
    @GroupGeneric
    public static SEXP min(@ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) {
        try {
            return new RangeCalculator().setRemoveNA(removeNA).addList(arguments).getMinimum();
        }
        catch (RangeContainsNA e) {
            return new DoubleArrayVector(DoubleVector.NA);
        }
    }

    @Builtin
    @GroupGeneric
    public static SEXP max(@ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) {
        try {
            return new RangeCalculator().setRemoveNA(removeNA).addList(arguments).getMaximum();
        }
        catch (RangeContainsNA e) {
            return new DoubleArrayVector(DoubleVector.NA);
        }
    }

    @Builtin
    @GroupGeneric
    public static Vector range(@ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) {
        try {
            return new RangeCalculator().setRemoveNA(removeNA).setRecursive(true).addList(arguments).getRange();
        }
        catch (RangeContainsNA e) {
            return new DoubleArrayVector(DoubleVector.NA, DoubleVector.NA);
        }
    }

    @Builtin
    @GroupGeneric
    public static double prod(@ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) {
        double product = 1.0;
        for (SEXP argument : arguments) {
            AtomicVector vector2 = (AtomicVector)EvalException.checkedCast(argument);
            for (int i = 0; i != vector2.length(); ++i) {
                if (vector2.isElementNA(i)) {
                    if (removeNA) continue;
                    return DoubleVector.NA;
                }
                product *= vector2.getElementAsDouble(i);
            }
        }
        return product;
    }

    @Builtin
    @GroupGeneric
    public static SEXP sum(@Current Context context, @ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) throws IOException {
        double realSum = 0.0;
        boolean haveDouble = false;
        double imaginarySum = 0.0;
        boolean haveComplex = false;
        if (arguments.length() == 1 && arguments.get(0) instanceof DoubleVector && !removeNA) {
            return new DeferredSum((Vector)arguments.get(0), AttributeMap.EMPTY);
        }
        for (SEXP argument : arguments) {
            int i;
            AtomicVector vector2;
            if (argument instanceof IntVector || argument instanceof LogicalVector) {
                vector2 = (AtomicVector)argument;
                for (i = 0; i != argument.length(); ++i) {
                    if (vector2.isElementNA(i)) {
                        if (removeNA) continue;
                        return haveDouble ? new DoubleArrayVector(DoubleVector.NA) : new IntArrayVector(Integer.MIN_VALUE);
                    }
                    int element = vector2.getElementAsInt(i);
                    realSum += (double)element;
                }
                continue;
            }
            if (argument instanceof DoubleVector) {
                vector2 = (DoubleVector)argument;
                haveDouble = true;
                for (i = 0; i != ((DoubleVector)vector2).length(); ++i) {
                    if (((DoubleVector)vector2).isElementNA(i)) {
                        if (removeNA) continue;
                        return new DoubleArrayVector(DoubleVector.NA);
                    }
                    realSum += ((DoubleVector)vector2).getElementAsDouble(i);
                }
                continue;
            }
            if (argument instanceof ComplexVector) {
                vector2 = (ComplexVector)argument;
                haveComplex = true;
                for (i = 0; i != ((AbstractSEXP)((Object)vector2)).length(); ++i) {
                    if (((ComplexVector)vector2).isElementNA(i)) {
                        if (removeNA) continue;
                        return new ComplexArrayVector(ComplexVector.NA);
                    }
                    Complex z = ((AbstractAtomicVector)vector2).getElementAsComplex(i);
                    realSum += z.getReal();
                    imaginarySum += z.getImaginary();
                }
                continue;
            }
            throw new EvalException("invalid 'type' (" + argument.getTypeName() + ") of argument", new Object[0]);
        }
        if (haveComplex) {
            return new ComplexArrayVector(new Complex(realSum, imaginarySum));
        }
        if (haveDouble) {
            return new DoubleArrayVector(realSum);
        }
        if (realSum < -2.147483648E9 || realSum > 2.147483647E9) {
            context.warn("Integer overflow - use sum(as.numeric(.))");
            return new IntArrayVector(Integer.MIN_VALUE);
        }
        return new IntArrayVector((int)realSum);
    }

    @Builtin
    @GroupGeneric
    public static Logical any(@ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) {
        for (SEXP argument : arguments) {
            Vector vector2 = (Vector)argument;
            for (int i = 0; i != vector2.length(); ++i) {
                if (vector2.isElementNA(i)) {
                    if (removeNA) continue;
                    return Logical.NA;
                }
                if (vector2.getElementAsDouble(i) == 0.0) continue;
                return Logical.TRUE;
            }
        }
        return Logical.FALSE;
    }

    @Builtin
    @GroupGeneric
    public static Logical all(@ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) {
        for (SEXP argument : arguments) {
            Vector vector2 = (Vector)argument;
            for (int i = 0; i != vector2.length(); ++i) {
                if (vector2.isElementNA(i)) {
                    if (removeNA) continue;
                    return Logical.NA;
                }
                if (vector2.getElementAsDouble(i) != 0.0) continue;
                return Logical.FALSE;
            }
        }
        return Logical.TRUE;
    }

    @Deferrable
    @Internal
    public static DoubleVector mean(Vector x) {
        if (x instanceof DeferredComputation || x.length() > 100000) {
            return new DeferredMean(x, AttributeMap.EMPTY);
        }
        double mean2 = 0.0;
        for (int i = 0; i < x.length(); ++i) {
            mean2 += x.getElementAsDouble(i);
        }
        return new DoubleArrayVector(mean2 / (double)x.length());
    }

    public double[] compute(Vector[] x) {
        double[] x_array = ((DoubleArrayVector)x[0]).toDoubleArrayUnsafe();
        double sum2 = 0.0;
        for (int i = 0; i != x_array.length; ++i) {
            sum2 += x_array[i];
        }
        return new double[]{sum2 / (double)x_array.length};
    }

    @Builtin
    public static DoubleVector cumsum(DoubleVector source) {
        DoubleArrayVector.Builder result = new DoubleArrayVector.Builder(source.length());
        double sum2 = 0.0;
        for (int i = 0; i < source.length() && !Double.isNaN(sum2 += source.getElementAsDouble(i)); ++i) {
            result.set(i, sum2);
        }
        return result.build();
    }

    @Builtin
    public static DoubleVector cumsum(RawVector source) {
        return Summary.cumsum(Vectors.asDouble(source));
    }

    @Builtin
    public static IntVector cumsum(@Current Context context, IntVector source) {
        return Summary.cumulativeSumIntegers(source);
    }

    @Builtin
    public static ComplexVector cumsum(ComplexVector source) {
        ComplexArrayVector.Builder result = new ComplexArrayVector.Builder(source.length());
        Complex sum2 = new Complex(0.0, 0.0);
        for (int i = 0; i < source.length() && !source.isElementNA(i); ++i) {
            sum2 = sum2.add(source.getElementAsComplex(i));
            result.set(i, sum2);
        }
        return result.build();
    }

    @Builtin
    public static IntVector cumsum(@Current Context context, LogicalVector source) {
        return Summary.cumulativeSumIntegers(source);
    }

    @Builtin
    public static DoubleVector cumsum(StringVector source) {
        return Summary.cumsum(Vectors.asDouble(source));
    }

    private static IntVector cumulativeSumIntegers(Vector source) {
        int x;
        IntArrayVector.Builder result = new IntArrayVector.Builder(source.length());
        int sum2 = 0;
        for (int i = 0; i < source.length() && (x = source.getElementAsInt(i)) != Integer.MIN_VALUE; ++i) {
            try {
                sum2 = IntMath.checkedAdd((int)sum2, (int)x);
            }
            catch (ArithmeticException e) {
                break;
            }
            result.set(i, sum2);
        }
        return result.build();
    }

    @Builtin
    public static DoubleVector cumprod(Vector source) {
        DoubleArrayVector.Builder result = new DoubleArrayVector.Builder();
        double sum2 = source.getElementAsDouble(0);
        result.add(sum2);
        for (int i = 1; i < source.length(); ++i) {
            if (Double.isNaN(sum2 *= source.getElementAsDouble(i))) {
                result.addNA();
                continue;
            }
            result.add(sum2);
        }
        return result.build();
    }

    @Builtin
    public static DoubleVector cummax(Vector source) {
        DoubleArrayVector.Builder result = new DoubleArrayVector.Builder();
        double max2 = source.getElementAsDouble(0);
        result.add(max2);
        for (int i = 1; i < source.length(); ++i) {
            if (source.getElementAsDouble(i) > max2 || source.isElementNA(i)) {
                max2 = source.getElementAsDouble(i);
            } else if (DoubleVector.isNaN(source.getElementAsDouble(i))) {
                max2 = DoubleVector.NA;
            }
            result.add(max2);
        }
        return result.build();
    }

    @Builtin
    public static DoubleVector cummin(Vector source) {
        DoubleArrayVector.Builder result = new DoubleArrayVector.Builder();
        double min2 = source.getElementAsDouble(0);
        result.add(min2);
        for (int i = 1; i < source.length(); ++i) {
            if (source.getElementAsDouble(i) < min2 || source.isElementNA(i)) {
                min2 = source.getElementAsDouble(i);
            } else if (DoubleVector.isNaN(source.getElementAsDouble(i))) {
                min2 = DoubleVector.NA;
            }
            result.add(min2);
        }
        return result.build();
    }

    @Internal
    public static Vector pmin(boolean naRm, @ArgumentList ListVector vectors) {
        ParallelProcessor processor = new ParallelProcessor(naRm, vectors){

            @Override
            boolean predicate(Number x, Number y) {
                return ((Comparable)((Object)x)).compareTo(y) > 0;
            }
        };
        return processor.compute();
    }

    @Internal
    public static Vector pmax(boolean naRm, @ArgumentList ListVector vectors) {
        ParallelProcessor processor = new ParallelProcessor(naRm, vectors){

            @Override
            boolean predicate(Number x, Number y) {
                return ((Comparable)((Object)x)).compareTo(y) < 0;
            }
        };
        return processor.compute();
    }

    private static abstract class ParallelProcessor {
        private ListVector arguments;
        private int resultLength;
        private boolean realResult;
        private boolean naRm;

        public ParallelProcessor(boolean naRm, ListVector arguments) {
            this.arguments = arguments;
            this.naRm = naRm;
            if (arguments.length() == 0) {
                throw new EvalException("no arguments", new Object[0]);
            }
            this.resultLength = arguments.maxElementLength();
        }

        private void validateArguments() {
            for (SEXP argument : this.arguments) {
                if (argument.length() == 0) {
                    throw new EvalException("cannot mix 0-length vectors with others", new Object[0]);
                }
                if (argument instanceof DoubleVector) {
                    this.realResult = true;
                    continue;
                }
                if (argument instanceof LogicalVector || argument instanceof IntVector) continue;
                throw new EvalException("cannot handle argument of type '%s'", argument.getTypeName());
            }
        }

        public Vector compute() {
            if (this.resultLength == 0) {
                return Null.INSTANCE;
            }
            this.validateArguments();
            Vector.Builder builder = this.createBuilder();
            for (int i = 0; i != this.resultLength; ++i) {
                Number result = this.computeResult(i);
                if (result == null) {
                    builder.addNA();
                    continue;
                }
                builder.add(result);
            }
            return builder.build();
        }

        private Number computeResult(int resultIndex) {
            Number result = null;
            for (int argIndex = 0; argIndex < this.arguments.length(); ++argIndex) {
                Number value = this.getValue(argIndex, resultIndex);
                if (value == null && !this.naRm) {
                    return null;
                }
                if (result == null && value != null) {
                    result = value;
                    continue;
                }
                if (result == null || value == null || !this.predicate(result, value)) continue;
                result = value;
            }
            return result;
        }

        private Vector.Builder createBuilder() {
            if (this.realResult) {
                return new DoubleArrayVector.Builder();
            }
            return new IntArrayVector.Builder();
        }

        private Vector getVector(int index) {
            return (Vector)this.arguments.getElementAsSEXP(index);
        }

        private Number getValue(int argument, int index) {
            int vectorIndex;
            Vector vector2 = this.getVector(argument);
            if (vector2.isElementNA(vectorIndex = index % vector2.length())) {
                return null;
            }
            if (this.realResult) {
                return vector2.getElementAsDouble(vectorIndex);
            }
            return vector2.getElementAsInt(vectorIndex);
        }

        abstract boolean predicate(Number var1, Number var2);
    }

    private static class RangeCalculator {
        private boolean removeNA;
        private boolean recursive;
        private Vector minValue = null;
        private Vector maxValue = null;
        private Vector.Type resultType = IntVector.VECTOR_TYPE;
        private boolean naEncountered = false;
        private boolean nanEncountered = false;

        private RangeCalculator() {
        }

        public RangeCalculator setRemoveNA(boolean removeNA) {
            this.removeNA = removeNA;
            return this;
        }

        public RangeCalculator setRecursive(boolean recursive2) {
            this.recursive = recursive2;
            return this;
        }

        public RangeCalculator addList(ListVector list2) throws RangeContainsNA {
            for (SEXP argument : list2) {
                if (argument instanceof AtomicVector) {
                    this.addVector(argument);
                    continue;
                }
                if (this.recursive && argument instanceof ListVector) {
                    this.addList((ListVector)argument);
                    continue;
                }
                throw new EvalException("invalid 'type' (%s) of argument", argument.getTypeName());
            }
            return this;
        }

        private void addVector(SEXP argument) throws RangeContainsNA {
            AtomicVector vector2 = (AtomicVector)EvalException.checkedCast(argument);
            if (vector2 instanceof ComplexVector) {
                throw new EvalException("invalid 'type' (complex) of argument", new Object[0]);
            }
            if (vector2.getVectorType().isWiderThan(this.resultType)) {
                this.resultType = vector2.getVectorType();
            }
            for (int i = 0; i != vector2.length(); ++i) {
                if (vector2.isElementNA(i)) {
                    if (this.removeNA) continue;
                    this.naEncountered = true;
                    continue;
                }
                if (this.isNaN(vector2, i)) {
                    if (this.removeNA) continue;
                    this.nanEncountered = true;
                    continue;
                }
                this.resultType = Vector.Type.widest(this.resultType, vector2.getVectorType());
                if (this.maxValue == null || this.resultType.compareElements(this.maxValue, 0, vector2, i) < 0) {
                    this.maxValue = this.resultType.getElementAsVector(vector2, i);
                }
                if (this.minValue != null && this.resultType.compareElements(this.minValue, 0, vector2, i) <= 0) continue;
                this.minValue = this.resultType.getElementAsVector(vector2, i);
            }
        }

        private boolean isNaN(AtomicVector vector2, int i) {
            double x;
            return vector2 instanceof DoubleVector && Double.isNaN(x = vector2.getElementAsDouble(i));
        }

        public Vector getRange() {
            if (this.maxValue == null) {
                return new DoubleArrayVector(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
            }
            if (this.nanEncountered) {
                return new DoubleArrayVector(Double.NaN, Double.NaN);
            }
            Vector.Builder result = this.resultType.newBuilder();
            if (this.naEncountered) {
                result.addNA();
                result.addNA();
            } else {
                result.addFrom(this.minValue, 0);
                result.addFrom(this.maxValue, 0);
            }
            return result.build();
        }

        public Vector getMinimum() {
            return (Vector)this.getRange().getElementAsSEXP(0);
        }

        public Vector getMaximum() {
            return (Vector)this.getRange().getElementAsSEXP(1);
        }

        private Vector buildNA() {
            return this.resultType.newBuilder().addNA().build();
        }
    }

    private static class RangeContainsNA
    extends Exception {
        private RangeContainsNA() {
        }
    }
}

