/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.renjin.eval.EvalException;
import org.renjin.primitives.io.connections.AbstractConnection;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.OpenSpec;

public class FileConnection
extends AbstractConnection {
    private InputStream in;
    private OutputStream out;
    private FileObject file;
    private OpenSpec openSpec = null;

    public FileConnection(FileObject file2) throws IOException {
        this.file = file2;
    }

    @Override
    public void open(OpenSpec spec) throws IOException {
        this.openSpec = spec;
        if (spec.forReading() && spec.forWriting()) {
            throw new EvalException("Read/write file connections not yet implemented", new Object[0]);
        }
        if (spec.forReading()) {
            if (spec.isBinary()) {
                this.assureOpenForInput();
            } else {
                this.getReader();
            }
        } else if (spec.forWriting()) {
            if (spec.isBinary()) {
                this.assureOpenForOutput();
            } else {
                this.getPrintWriter();
            }
        }
    }

    private final InputStream assureOpenForInput() throws IOException {
        if (this.out != null) {
            throw new EvalException("connection is already opened for output, cannot open for input", new Object[0]);
        }
        if (this.in == null) {
            this.in = this.doOpenForInput();
        }
        return this.in;
    }

    protected InputStream doOpenForInput() throws IOException {
        PushbackInputStream in;
        int pushBackBufferSize = 2;
        try {
            in = new PushbackInputStream(this.file.getContent().getInputStream(), pushBackBufferSize);
        }
        catch (FileNotFoundException e) {
            throw new EvalException(e.getMessage(), new Object[0]);
        }
        int b1 = in.read();
        int b2 = in.read();
        in.unread(b2);
        in.unread(b1);
        if (b1 == 31 && b2 == 139) {
            return new GZIPInputStream(in);
        }
        return in;
    }

    private OutputStream assureOpenForOutput() throws IOException {
        if (this.in != null) {
            throw new EvalException("connection is already opened for input, cannot open for output", new Object[0]);
        }
        if (this.out == null) {
            this.out = this.doOpenForOutput();
        }
        return this.out;
    }

    protected OutputStream doOpenForOutput() throws FileSystemException, IOException {
        boolean append2 = this.openSpec != null && this.openSpec.isAppend();
        return this.file.getContent().getOutputStream(append2);
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        return this.assureOpenForInput();
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        return this.assureOpenForOutput();
    }

    @Override
    protected void closeInputIfOpen() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    @Override
    protected void closeOutputIfOpen() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    @Override
    public boolean isOpen() {
        return this.in != null || this.out != null;
    }

    @Override
    public String getClassName() {
        return "file";
    }

    @Override
    public String getDescription() {
        return this.file.getName().getPath();
    }

    @Override
    public Connection.Type getType() {
        if (this.openSpec == null) {
            return Connection.Type.TEXT;
        }
        return this.openSpec.getType();
    }

    @Override
    public String getMode() {
        if (this.openSpec == null) {
            return "r";
        }
        return this.openSpec.toString();
    }

    @Override
    public boolean canRead() {
        return !this.isOpen() || this.openSpec == null || this.openSpec.forReading();
    }

    @Override
    public boolean canWrite() {
        return !this.isOpen() || this.openSpec == null || this.openSpec.forWriting();
    }
}

