/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.time;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.renjin.eval.EvalException;
import org.renjin.sexp.StringVector;

public class DateTimeFormat {
    private DateTimeFormat() {
    }

    public static DateTimeFormatter forPattern(String patterns, boolean useTz) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        for (int i = 0; i < patterns.length(); ++i) {
            if (patterns.charAt(i) == '%' && i + 1 < patterns.length()) {
                char specifier = patterns.charAt(++i);
                block0 : switch (specifier) {
                    case '%': {
                        builder.appendLiteral("%");
                        break;
                    }
                    case 'a': {
                        builder.appendDayOfWeekShortText();
                        break;
                    }
                    case 'A': {
                        builder.appendDayOfWeekText();
                        break;
                    }
                    case 'b': {
                        builder.appendMonthOfYearShortText();
                        break;
                    }
                    case 'B': {
                        builder.appendMonthOfYearText();
                        break;
                    }
                    case 'c': {
                        throw new UnsupportedOperationException("%c not yet implemented");
                    }
                    case 'd': {
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'H': {
                        builder.appendHourOfDay(2);
                        break;
                    }
                    case 'I': {
                        builder.appendHourOfHalfday(2);
                        break;
                    }
                    case 'j': {
                        builder.appendDayOfYear(3);
                        break;
                    }
                    case 'm': {
                        builder.appendMonthOfYear(2);
                        break;
                    }
                    case 'M': {
                        builder.appendMinuteOfHour(2);
                        break;
                    }
                    case 'p': {
                        builder.appendHalfdayOfDayText();
                        break;
                    }
                    case 'O': {
                        if (i + 1 >= patterns.length()) {
                            builder.appendLiteral("%O");
                            break;
                        }
                        switch (patterns.charAt(++i)) {
                            case 'S': {
                                builder.appendSecondOfMinute(2);
                                break block0;
                            }
                        }
                        throw new EvalException("%O[dHImMUVwWy] not yet implemented", new Object[0]);
                    }
                    case 'S': {
                        builder.appendSecondOfMinute(2);
                        break;
                    }
                    case 'y': {
                        builder.appendTwoDigitYear(1968, true);
                        break;
                    }
                    case 'Y': {
                        builder.appendYear(1, 4);
                        break;
                    }
                    case 'z': {
                        builder.appendTimeZoneOffset(null, true, 1, 2);
                        break;
                    }
                    case 'Z': {
                        builder.appendTimeZoneName();
                        break;
                    }
                    default: {
                        throw new EvalException("%" + specifier + " not yet implemented. (Implement me!)", new Object[0]);
                    }
                }
                continue;
            }
            builder.appendLiteral(patterns.substring(i, i + 1));
        }
        if (useTz) {
            builder.appendLiteral(" ");
            builder.appendTimeZoneShortName();
        }
        return builder.toFormatter();
    }

    public static DateTimeFormatter forPattern(String pattern) {
        return DateTimeFormat.forPattern(pattern, false);
    }

    public static List<DateTimeFormatter> forPatterns(StringVector patterns, DateTimeZone timeZone, boolean useTz) {
        ArrayList formatters = Lists.newArrayListWithCapacity((int)patterns.length());
        for (String format2 : patterns) {
            formatters.add(DateTimeFormat.forPattern(format2, useTz).withZone(timeZone));
        }
        return formatters;
    }

    public static List<DateTimeFormatter> forPatterns(StringVector patterns, DateTimeZone timeZone) {
        return DateTimeFormat.forPatterns(patterns, timeZone, false);
    }
}

