/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.apache.commons.math.complex.Complex;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public abstract class LogicalVector
extends AbstractAtomicVector
implements Iterable<Logical> {
    public static final String TYPE_NAME = "logical";
    public static final Vector.Type VECTOR_TYPE = new LogicalType();
    public static final LogicalVector EMPTY = new LogicalArrayVector(new int[0]);
    public static int NA = Integer.MIN_VALUE;
    public static LogicalVector TRUE = new LogicalArrayVector(1);
    public static LogicalVector FALSE = new LogicalArrayVector(0);
    public static LogicalVector NA_VECTOR = new LogicalArrayVector(NA);

    public static SEXP valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public LogicalVector(AttributeMap attributes2) {
        super(attributes2);
    }

    protected LogicalVector() {
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public abstract int length();

    @Override
    public int getElementAsInt(int index) {
        return this.getElementAsRawLogical(index);
    }

    @Override
    public double getElementAsDouble(int index) {
        int value = this.getElementAsRawLogical(index);
        return value == Integer.MIN_VALUE ? DoubleVector.NA : (double)value;
    }

    public SEXP getElementAsSEXP(int index) {
        return new LogicalArrayVector(this.getElementAsRawLogical(index));
    }

    @Override
    public int indexOf(AtomicVector vector2, int vectorIndex, int startIndex) {
        int value = vector2.getElementAsRawLogical(startIndex);
        for (int i = 0; i < this.length(); ++i) {
            if (value != this.getElementAsRawLogical(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int compare(int index1, int index2) {
        return this.getElementAsRawLogical(index1) - this.getElementAsRawLogical(index2);
    }

    @Override
    public Boolean getElementAsObject(int index) {
        int value = this.getElementAsInt(index);
        if (IntVector.isNA(value)) {
            throw new IllegalStateException(String.format("The element at index %d is NA, and cannot be represented as a Boolean. Make sure you are calling isElementNA() first.", index));
        }
        return value != 0;
    }

    @Override
    public Logical getElementAsLogical(int index) {
        return Logical.valueOf(this.getElementAsRawLogical(index));
    }

    @Override
    public abstract int getElementAsRawLogical(int var1);

    @Override
    public Complex getElementAsComplex(int index) {
        if (IntVector.isNA(this.getElementAsRawLogical(index))) {
            return ComplexVector.NA;
        }
        return new Complex(this.getElementAsDouble(index), 0.0);
    }

    @Override
    public Vector.Type getVectorType() {
        return VECTOR_TYPE;
    }

    @Override
    public String getElementAsString(int index) {
        int value = this.getElementAsRawLogical(index);
        if (value == Integer.MIN_VALUE) {
            return StringVector.NA;
        }
        if (value == 0) {
            return "FALSE";
        }
        return "TRUE";
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public Logical asLogical() {
        return this.getElementAsLogical(0);
    }

    @Override
    public double asReal() {
        if (this.length() == 0) {
            return DoubleVector.NA;
        }
        return this.getElementAsDouble(0);
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Iterator<Logical> iterator() {
        return new UnmodifiableIterator<Logical>(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < LogicalVector.this.length();
            }

            public Logical next() {
                return LogicalVector.this.getElementAsLogical(this.i++);
            }
        };
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof LogicalVector)) {
            return false;
        }
        LogicalVector that = (LogicalVector)o;
        if (this.length() != that.length()) {
            return false;
        }
        for (int i = 0; i != this.length(); ++i) {
            if (this.getElementAsRawLogical(i) == that.getElementAsRawLogical(i)) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int hash = 37;
        for (int i = 0; i != this.length(); ++i) {
            hash += this.getElementAsRawLogical(i);
        }
        return hash;
    }

    public String toString() {
        if (this.length() == 1) {
            return this.toString(this.getElementAsRawLogical(0));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("c(");
        for (int i = 0; i != Math.min(5, this.length()); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.toString(this.getElementAsRawLogical(i)));
        }
        if (this.length() > 5) {
            sb.append(",... ").append(this.length()).append(" elements total");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public LogicalArrayVector.Builder newCopyBuilder() {
        return new LogicalArrayVector.Builder(this);
    }

    @Override
    public LogicalArrayVector.Builder newBuilderWithInitialSize(int initialSize) {
        return new LogicalArrayVector.Builder(initialSize, initialSize);
    }

    @Override
    public LogicalArrayVector.Builder newBuilderWithInitialCapacity(int initialCapacity) {
        return new LogicalArrayVector.Builder(0, initialCapacity);
    }

    @Override
    protected abstract SEXP cloneWithNewAttributes(AttributeMap var1);

    private String toString(int x) {
        if (x == 1) {
            return "TRUE";
        }
        if (x == 0) {
            return "FALSE";
        }
        return "NA";
    }

    @Override
    public boolean isElementNA(int index) {
        return IntVector.isNA(this.getElementAsRawLogical(index));
    }

    private static class LogicalType
    extends Vector.Type {
        public LogicalType() {
            super(2);
        }

        @Override
        public Vector.Builder newBuilder() {
            return new LogicalArrayVector.Builder(0, 0);
        }

        @Override
        public Vector.Builder newBuilderWithInitialSize(int initialSize) {
            return new LogicalArrayVector.Builder(initialSize);
        }

        @Override
        public Vector.Builder newBuilderWithInitialCapacity(int initialCapacity) {
            return new LogicalArrayVector.Builder(0, initialCapacity);
        }

        @Override
        public Vector getElementAsVector(Vector vector2, int index) {
            return new LogicalArrayVector(vector2.getElementAsRawLogical(index));
        }

        @Override
        public int compareElements(Vector vector1, int index1, Vector vector2, int index2) {
            return vector1.getElementAsRawLogical(index1) - vector2.getElementAsRawLogical(index2);
        }

        @Override
        public boolean elementsEqual(Vector vector1, int index1, Vector vector2, int index2) {
            if (vector1.isElementNA(index1) || vector2.isElementNA(index2)) {
                return false;
            }
            return vector1.getElementAsRawLogical(index1) == vector2.getElementAsRawLogical(index2);
        }
    }
}

