/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import org.renjin.sexp.ListVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public interface PromisePairList
extends PairList {

    public static class Builder {
        private Node head = null;
        private Node tail = null;

        public Builder add(SEXP tag, SEXP promise) {
            if (this.head == null) {
                this.tail = this.head = new Node(tag, promise, Null.INSTANCE);
            } else {
                Node next = new Node(tag, promise, Null.INSTANCE);
                this.tail.nextNode = next;
                this.tail = next;
            }
            return this;
        }

        public PromisePairList build() {
            if (this.head == null) {
                return Null.INSTANCE;
            }
            return this.head;
        }

        public static PromisePairList fromList(ListVector vector2) {
            Builder list2 = new Builder();
            for (NamedValue namedValue : vector2.namedValues()) {
                if (namedValue.hasName()) {
                    list2.add(Symbol.get(namedValue.getName()), Promise.repromise(namedValue.getValue()));
                    continue;
                }
                list2.add(Null.INSTANCE, Promise.repromise(namedValue.getValue()));
            }
            return list2.build();
        }
    }

    public static class Node
    extends PairList.Node
    implements PromisePairList {
        private Node(SEXP tag, SEXP value, PairList nextNode) {
            super(tag, value, nextNode);
        }

        @Override
        public String getTypeName() {
            return "...";
        }
    }
}

