/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.eval.Session;
import org.renjin.sexp.DoubleVector;
import org.renjin.stats.internals.distributions.Normal;
import org.renjin.stats.internals.distributions.SignRank;

public class LNorm {
    public static double rlnorm(Session context, double meanlog, double sdlog) {
        if (Double.isNaN(meanlog) || sdlog < 0.0) {
            return Double.NaN;
        }
        return Math.exp(Normal.rnorm(context, meanlog, sdlog));
    }

    public static double dlnorm(double x, double meanlog, double sdlog, boolean give_log) {
        if (DoubleVector.isNaN(x) || DoubleVector.isNaN(meanlog) || DoubleVector.isNaN(sdlog)) {
            return x + meanlog + sdlog;
        }
        if (sdlog <= 0.0) {
            return Double.NaN;
        }
        if (x <= 0.0) {
            return SignRank.R_D__0(true, give_log);
        }
        double y = (Math.log(x) - meanlog) / sdlog;
        return give_log ? -(Math.log(Math.sqrt(Math.PI * 2)) + 0.5 * y * y + Math.log(x * sdlog)) : 1.0 / Math.sqrt(Math.PI * 2) * Math.exp(-0.5 * y * y) / (x * sdlog);
    }
}

