/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.eval.EvalException;
import org.renjin.eval.Session;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.util.HeapsortTandem;

public class Sampling {
    public static int RouletteWheel(double[] cumulativeDist, double rand) {
        int result = 0;
        for (int i = 0; i < cumulativeDist.length - 1; ++i) {
            if (!(rand > cumulativeDist[i]) || !(rand < cumulativeDist[i + 1])) continue;
            return i + 1;
        }
        return result;
    }

    public static IntVector sampleWithReplacement(Session context, int size, double[] prob) {
        int i;
        double[] cumProbs = new double[prob.length];
        IntArrayVector.Builder resultb = IntArrayVector.Builder.withInitialCapacity(size);
        cumProbs[0] = prob[0];
        for (i = 1; i < cumProbs.length; ++i) {
            cumProbs[i] = prob[i] + cumProbs[i - 1];
        }
        for (i = 0; i < size; ++i) {
            double arand = context.rng.unif_rand();
            int index = Sampling.RouletteWheel(cumProbs, arand);
            resultb.add(index + 1);
        }
        return resultb.build();
    }

    public static IntVector sampleWithoutReplacement(Session context, int sampleSpaceSize, int sampleSize) {
        int i;
        int[] x = new int[sampleSpaceSize];
        IntArrayVector.Builder y = new IntArrayVector.Builder();
        for (i = 0; i < sampleSpaceSize; ++i) {
            x[i] = i;
        }
        for (i = 0; i < sampleSize; ++i) {
            int j = (int)Math.floor((double)sampleSpaceSize * context.rng.unif_rand());
            y.add(x[j] + 1);
            x[j] = x[--sampleSpaceSize];
        }
        return y.build();
    }

    public static IntVector probSampleWithoutReplacement(Session context, int n, int sampleSize, double[] probs) {
        int i;
        int[] x = new int[n];
        IntArrayVector.Builder y = new IntArrayVector.Builder();
        for (i = 0; i < n; ++i) {
            x[i] = i + 1;
        }
        HeapsortTandem.heapsortDescending(probs, x, n);
        double totalmass = 1.0;
        i = 0;
        int n1 = n - 1;
        while (i < sampleSize) {
            int j;
            double rT = totalmass * context.rng.unif_rand();
            double mass = 0.0;
            for (j = 0; j < n1 && !(rT <= (mass += probs[j])); ++j) {
            }
            y.add(x[j]);
            totalmass -= probs[j];
            for (int k = j; k < n1; ++k) {
                probs[k] = probs[k + 1];
                x[k] = x[k + 1];
            }
            ++i;
            --n1;
        }
        return y.build();
    }

    @Internal
    public static IntVector sample(@Current Session context, int x, int sampleSize, boolean replace, SEXP prob) {
        boolean probabilitiesGiven = prob != Null.INSTANCE;
        double[] probs = probabilitiesGiven ? ((DoubleVector)prob).toDoubleArray() : new double[x];
        if (probabilitiesGiven && prob.length() != x) {
            throw new EvalException("The number of probabilities should be the same as the sample  size.", new Object[0]);
        }
        for (int i = 0; i < x; ++i) {
            probs[i] = prob == Null.INSTANCE ? 1.0 / (double)probs.length : ((DoubleVector)prob).get(i);
        }
        Sampling.weightsToProbabilities(probs, x, sampleSize, replace);
        if (replace) {
            return Sampling.sampleWithReplacement(context, sampleSize, probs);
        }
        IntVector response = probabilitiesGiven ? Sampling.probSampleWithoutReplacement(context, x, sampleSize, probs) : Sampling.sampleWithoutReplacement(context, x, sampleSize);
        return response;
    }

    private static void weightsToProbabilities(double[] weights, int n, int sampleSize, boolean replace) {
        int i;
        int npos = 0;
        double sum2 = 0.0;
        for (i = 0; i < n; ++i) {
            if (weights[i] < 0.0) {
                throw new EvalException("non-positive probability", new Object[0]);
            }
            if (!(weights[i] > 0.0)) continue;
            ++npos;
            sum2 += weights[i];
        }
        if (npos == 0 || !replace && sampleSize > npos) {
            throw new EvalException("too few positive probabilities", new Object[0]);
        }
        i = 0;
        while (i < n) {
            int n2 = i++;
            weights[n2] = weights[n2] / sum2;
        }
    }
}

