/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.models;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.renjin.eval.Context;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.stats.internals.models.InterceptColumn;
import org.renjin.stats.internals.models.ModelFrame;
import org.renjin.stats.internals.models.ModelMatrix;
import org.renjin.stats.internals.models.ModelMatrixColumn;
import org.renjin.stats.internals.models.TermsObject;

public class ModelMatrixBuilder {
    public static ModelMatrix build(Context context, SEXP termsObject, ListVector frame2) {
        ModelFrame modelFrame = new ModelFrame(frame2);
        TermsObject terms2 = new TermsObject(termsObject, modelFrame);
        ArrayList columns = Lists.newArrayList();
        IntArrayVector.Builder assignment = new IntArrayVector.Builder();
        if (terms2.hasIntercept()) {
            columns.add(new InterceptColumn());
            assignment.add(0);
        }
        for (TermsObject.Term term : terms2.getTerms()) {
            if (term.isResponse()) continue;
            for (ModelMatrixColumn modelMatrixColumn : term.getModelMatrixColumns()) {
                columns.add(modelMatrixColumn);
                assignment.add(term.getTermIndex() + 1);
            }
        }
        AttributeMap.Builder attributes2 = AttributeMap.builder();
        attributes2.set(Symbols.DIM, (SEXP)new IntArrayVector(modelFrame.getNumRows(), columns.size()));
        attributes2.set(Symbols.DIMNAMES, (SEXP)new ListVector(modelFrame.getRowNames(), ModelMatrixBuilder.columnNames(columns)));
        attributes2.set(ModelMatrix.ASSIGN, (SEXP)assignment.build());
        return new ModelMatrix(modelFrame.getNumRows(), columns, attributes2.build());
    }

    private static StringVector columnNames(List<ModelMatrixColumn> columns) {
        StringVector.Builder names2 = StringVector.newBuilder();
        for (ModelMatrixColumn column : columns) {
            names2.add(column.getName());
        }
        return names2.build();
    }
}

