/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.util;

public final class HeapsortTandem {
    static double dtmp = 0.0;
    static int itmp = 0;

    public static void heapsortAscending(double[] a1, int[] a2, int n) {
        int end = n - 1;
        HeapsortTandem.heapify(a1, a2, n);
        while (end > 0) {
            HeapsortTandem.swap(a1, end, 0);
            HeapsortTandem.siftDown(a1, a2, 0, --end);
        }
    }

    private static void heapify(double[] a1, int[] a2, int count) {
        for (int start = (int)Math.floor((count - 2) / 2); start >= 0; --start) {
            HeapsortTandem.siftDown(a1, a2, start, count - 1);
        }
    }

    private static void siftDown(double[] a1, int[] a2, int startNode, int endNode) {
        int root = startNode;
        int leftChild = root * 2 + 1;
        while (leftChild <= endNode) {
            leftChild = root * 2 + 1;
            int rightChild = leftChild + 1;
            int swapNode = root;
            if (a1[swapNode] < a1[leftChild]) {
                swapNode = leftChild;
            }
            if (rightChild <= endNode && a1[swapNode] < a1[rightChild]) {
                swapNode = rightChild;
            }
            if (swapNode == root) {
                return;
            }
            HeapsortTandem.swap(a1, root, swapNode);
            HeapsortTandem.swap(a2, root, swapNode);
            root = swapNode;
            leftChild = root * 2 + 1;
        }
    }

    public static void heapsortDescending(double[] a1, int[] a2, int n) {
        if (n <= 1) {
            return;
        }
        int l = (n >> 1) + 1;
        int ir = n - 1;
        while (true) {
            int ii;
            double ra;
            if (l > 0) {
                ra = a1[--l];
                ii = a2[l];
            } else {
                ra = a1[ir];
                ii = a2[ir];
                a1[ir] = a1[0];
                a2[ir] = a2[0];
                if (--ir == 0) {
                    a1[0] = ra;
                    a2[0] = ii;
                    return;
                }
            }
            int i = l;
            int j = l << 1;
            while (j <= ir) {
                if (j < ir && a1[j] > a1[j + 1] || i == j) {
                    ++j;
                }
                if (ra > a1[j]) {
                    a1[i] = a1[j];
                    a2[i] = a2[j];
                    i = j;
                    j += i;
                    continue;
                }
                j = ir + 1;
            }
            a1[i] = ra;
            a2[i] = ii;
        }
    }

    private static void swap(double[] array2, int i, int j) {
        dtmp = array2[i];
        array2[i] = array2[j];
        array2[j] = dtmp;
    }

    private static void swap(int[] array2, int i, int j) {
        itmp = array2[i];
        array2[i] = array2[j];
        array2[j] = itmp;
    }
}

