/*
 * Decompiled with CFR 0.152.
 */
package io.scif.jj2000.j2k.quantization.quantizer;

import io.scif.jj2000.j2k.quantization.GuardBitsSpec;
import io.scif.jj2000.j2k.quantization.QuantStepSizeSpec;
import io.scif.jj2000.j2k.quantization.QuantTypeSpec;
import io.scif.jj2000.j2k.quantization.quantizer.Quantizer;
import io.scif.jj2000.j2k.wavelet.Subband;
import io.scif.jj2000.j2k.wavelet.analysis.CBlkWTData;
import io.scif.jj2000.j2k.wavelet.analysis.CBlkWTDataFloat;
import io.scif.jj2000.j2k.wavelet.analysis.CBlkWTDataInt;
import io.scif.jj2000.j2k.wavelet.analysis.CBlkWTDataSrc;
import io.scif.jj2000.j2k.wavelet.analysis.SubbandAn;
import io.scif.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;

public class StdQuantizer
extends Quantizer {
    public static final int QSTEP_MANTISSA_BITS = 11;
    public static final int QSTEP_EXPONENT_BITS = 5;
    public static final int QSTEP_MAX_MANTISSA = 2047;
    public static final int QSTEP_MAX_EXPONENT = 31;
    private static double log2 = Math.log(2.0);
    private QuantTypeSpec qts;
    private QuantStepSizeSpec qsss;
    private GuardBitsSpec gbs;
    private CBlkWTDataFloat infblk;

    public StdQuantizer(CBlkWTDataSrc src, J2KImageWriteParamJava wp) {
        super(src);
        this.qts = wp.getQuantizationType();
        this.qsss = wp.getQuantizationStep();
        this.gbs = wp.getGuardBits();
    }

    public QuantTypeSpec getQuantTypeSpec() {
        return this.qts;
    }

    public int getNumGuardBits(int t, int c) {
        return (Integer)this.gbs.getTileCompVal(t, c);
    }

    public boolean isReversible(int t, int c) {
        return this.qts.isReversible(t, c);
    }

    public boolean isDerived(int t, int c) {
        return this.qts.isDerived(t, c);
    }

    public CBlkWTData getNextCodeBlock(int c, CBlkWTData cblk) {
        return this.getNextInternCodeBlock(c, cblk);
    }

    public final CBlkWTData getNextInternCodeBlock(int c, CBlkWTData cblk) {
        int[] outarr;
        boolean intq;
        float[] infarr = null;
        int g = (Integer)this.gbs.getTileCompVal(this.tIdx, c);
        boolean bl = intq = this.src.getDataType(this.tIdx, c) == 3;
        if (cblk == null) {
            cblk = new CBlkWTDataInt();
        }
        CBlkWTDataFloat infblk = this.infblk;
        if (intq) {
            if ((cblk = this.src.getNextCodeBlock(c, cblk)) == null) {
                return null;
            }
            outarr = (int[])cblk.getData();
        } else {
            if ((infblk = (CBlkWTDataFloat)this.src.getNextInternCodeBlock(c, infblk)) == null) {
                this.infblk.setData(null);
                return null;
            }
            this.infblk = infblk;
            infarr = (float[])infblk.getData();
            outarr = (int[])cblk.getData();
            if (outarr == null || outarr.length < infblk.w * infblk.h) {
                outarr = new int[infblk.w * infblk.h];
                cblk.setData(outarr);
            }
            cblk.m = infblk.m;
            cblk.n = infblk.n;
            cblk.sb = infblk.sb;
            cblk.ulx = infblk.ulx;
            cblk.uly = infblk.uly;
            cblk.w = infblk.w;
            cblk.h = infblk.h;
            cblk.wmseScaling = infblk.wmseScaling;
            cblk.offset = 0;
            cblk.scanw = cblk.w;
        }
        int w = cblk.w;
        int h = cblk.h;
        SubbandAn sb = cblk.sb;
        if (this.isReversible(this.tIdx, c)) {
            cblk.magbits = g - 1 + this.src.getNomRangeBits(c) + sb.anGainExp;
            int shiftBits = 31 - cblk.magbits;
            cblk.convertFactor = 1 << shiftBits;
            for (int j = w * h - 1; j >= 0; --j) {
                int tmp = outarr[j] << shiftBits;
                outarr[j] = tmp < 0 ? Integer.MIN_VALUE | -tmp : tmp;
            }
        } else {
            float stepUDR;
            float baseStep = ((Float)this.qsss.getTileCompVal(this.tIdx, c)).floatValue();
            if (this.isDerived(this.tIdx, c)) {
                cblk.magbits = g - 1 + sb.level - (int)Math.floor(Math.log(baseStep) / log2);
                stepUDR = baseStep / (float)(1 << sb.level);
            } else {
                cblk.magbits = g - 1 - (int)Math.floor(Math.log(baseStep / (sb.l2Norm * (float)(1 << sb.anGainExp))) / log2);
                stepUDR = baseStep / (sb.l2Norm * (float)(1 << sb.anGainExp));
            }
            int shiftBits = 31 - cblk.magbits;
            stepUDR = StdQuantizer.convertFromExpMantissa(StdQuantizer.convertToExpMantissa(stepUDR));
            float invstep = 1.0f / ((float)(1L << this.src.getNomRangeBits(c) + sb.anGainExp) * stepUDR);
            cblk.convertFactor = invstep *= (float)(1 << shiftBits - this.src.getFixedPoint(c));
            cblk.stepSize = (float)(1L << this.src.getNomRangeBits(c) + sb.anGainExp) * stepUDR;
            if (intq) {
                for (int j = w * h - 1; j >= 0; --j) {
                    int tmp = (int)((float)outarr[j] * invstep);
                    outarr[j] = tmp < 0 ? Integer.MIN_VALUE | -tmp : tmp;
                }
            } else {
                int j = w * h - 1;
                int k = infblk.offset + (h - 1) * infblk.scanw + w - 1;
                int jmin = w * (h - 1);
                while (j >= 0) {
                    while (j >= jmin) {
                        int tmp = (int)(infarr[k] * invstep);
                        outarr[j] = tmp < 0 ? Integer.MIN_VALUE | -tmp : tmp;
                        --k;
                        --j;
                    }
                    k -= infblk.scanw - w;
                    jmin -= w;
                }
            }
        }
        return cblk;
    }

    protected void calcSbParams(SubbandAn sb, int c) {
        if (sb.stepWMSE > 0.0f) {
            return;
        }
        if (!sb.isNode) {
            if (this.isReversible(this.tIdx, c)) {
                sb.stepWMSE = (float)Math.pow(2.0, -(this.src.getNomRangeBits(c) << 1)) * sb.l2Norm * sb.l2Norm;
            } else {
                float baseStep = ((Float)this.qsss.getTileCompVal(this.tIdx, c)).floatValue();
                sb.stepWMSE = this.isDerived(this.tIdx, c) ? baseStep * baseStep * (float)Math.pow(2.0, sb.anGainExp - sb.level << 1) * sb.l2Norm * sb.l2Norm : baseStep * baseStep;
            }
        } else {
            this.calcSbParams((SubbandAn)sb.getLL(), c);
            this.calcSbParams((SubbandAn)sb.getHL(), c);
            this.calcSbParams((SubbandAn)sb.getLH(), c);
            this.calcSbParams((SubbandAn)sb.getHH(), c);
            sb.stepWMSE = 1.0f;
        }
    }

    public static int convertToExpMantissa(float step) {
        int exp = (int)Math.ceil(-Math.log(step) / log2);
        if (exp > 31) {
            return 63488;
        }
        return exp << 11 | (int)((-step * (float)(-1 << exp) - 1.0f) * 2048.0f + 0.5f);
    }

    private static float convertFromExpMantissa(int ems) {
        return (-1.0f - (float)(ems & 0x7FF) / 2048.0f) / (float)(-1 << (ems >> 11 & 0x1F));
    }

    public int getMaxMagBits(int c) {
        SubbandAn sb = this.getAnSubbandTree(this.tIdx, c);
        if (this.isReversible(this.tIdx, c)) {
            return this.getMaxMagBitsRev(sb, c);
        }
        if (this.isDerived(this.tIdx, c)) {
            return this.getMaxMagBitsDerived(sb, this.tIdx, c);
        }
        return this.getMaxMagBitsExpounded(sb, this.tIdx, c);
    }

    private int getMaxMagBitsRev(Subband sb, int c) {
        int max = 0;
        int g = (Integer)this.gbs.getTileCompVal(this.tIdx, c);
        if (!sb.isNode) {
            return g - 1 + this.src.getNomRangeBits(c) + sb.anGainExp;
        }
        max = this.getMaxMagBitsRev(sb.getLL(), c);
        int tmp = this.getMaxMagBitsRev(sb.getLH(), c);
        if (tmp > max) {
            max = tmp;
        }
        if ((tmp = this.getMaxMagBitsRev(sb.getHL(), c)) > max) {
            max = tmp;
        }
        if ((tmp = this.getMaxMagBitsRev(sb.getHH(), c)) > max) {
            max = tmp;
        }
        return max;
    }

    private int getMaxMagBitsDerived(Subband sb, int t, int c) {
        int max = 0;
        int g = (Integer)this.gbs.getTileCompVal(t, c);
        if (!sb.isNode) {
            float baseStep = ((Float)this.qsss.getTileCompVal(t, c)).floatValue();
            return g - 1 + sb.level - (int)Math.floor(Math.log(baseStep) / log2);
        }
        max = this.getMaxMagBitsDerived(sb.getLL(), t, c);
        int tmp = this.getMaxMagBitsDerived(sb.getLH(), t, c);
        if (tmp > max) {
            max = tmp;
        }
        if ((tmp = this.getMaxMagBitsDerived(sb.getHL(), t, c)) > max) {
            max = tmp;
        }
        if ((tmp = this.getMaxMagBitsDerived(sb.getHH(), t, c)) > max) {
            max = tmp;
        }
        return max;
    }

    private int getMaxMagBitsExpounded(Subband sb, int t, int c) {
        int max = 0;
        int g = (Integer)this.gbs.getTileCompVal(t, c);
        if (!sb.isNode) {
            float baseStep = ((Float)this.qsss.getTileCompVal(t, c)).floatValue();
            return g - 1 - (int)Math.floor(Math.log(baseStep / (((SubbandAn)sb).l2Norm * (float)(1 << sb.anGainExp))) / log2);
        }
        max = this.getMaxMagBitsExpounded(sb.getLL(), t, c);
        int tmp = this.getMaxMagBitsExpounded(sb.getLH(), t, c);
        if (tmp > max) {
            max = tmp;
        }
        if ((tmp = this.getMaxMagBitsExpounded(sb.getHL(), t, c)) > max) {
            max = tmp;
        }
        if ((tmp = this.getMaxMagBitsExpounded(sb.getHH(), t, c)) > max) {
            max = tmp;
        }
        return max;
    }
}

