/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.imglib2;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.imglib2.IterableInterval;
import net.imglib2.blocks.SubArrayCopy;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.img.LoadedCellCacheLoader;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.array.AbstractByteArray;
import net.imglib2.img.basictypeaccess.array.AbstractDoubleArray;
import net.imglib2.img.basictypeaccess.array.AbstractFloatArray;
import net.imglib2.img.basictypeaccess.array.AbstractIntArray;
import net.imglib2.img.basictypeaccess.array.AbstractLongArray;
import net.imglib2.img.basictypeaccess.array.AbstractShortArray;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.DirtyByteArray;
import net.imglib2.img.basictypeaccess.array.DirtyDoubleArray;
import net.imglib2.img.basictypeaccess.array.DirtyFloatArray;
import net.imglib2.img.basictypeaccess.array.DirtyIntArray;
import net.imglib2.img.basictypeaccess.array.DirtyLongArray;
import net.imglib2.img.basictypeaccess.array.DirtyShortArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileDoubleArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileLongArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileShortArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileDoubleArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileLongArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileShortArray;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.Type;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;

public class N5CacheLoader<T extends NativeType<T>, A extends ArrayDataAccess<A>>
implements CacheLoader<Long, Cell<A>> {
    private final N5Reader n5;
    private final String dataset;
    private final DatasetAttributes attributes;
    private final CellGrid grid;
    private final ArrayDataAccessLoader<?, A> cacheArrayLoader;
    private final CacheLoader<Long, Cell<A>> missingLoader;

    public N5CacheLoader(N5Reader n5, String dataset, CellGrid grid, T type, Set<AccessFlags> accessFlags, Consumer<IterableInterval<T>> blockNotFoundHandler) throws N5Exception {
        this.n5 = n5;
        this.dataset = dataset;
        this.grid = grid;
        this.attributes = n5.getDatasetAttributes(dataset);
        this.cacheArrayLoader = N5CacheLoader.createN5CacheArrayLoader(type, accessFlags);
        this.missingLoader = LoadedCellCacheLoader.get((CellGrid)grid, blockNotFoundHandler::accept, type, accessFlags);
    }

    public Cell<A> get(Long key) throws Exception {
        int n = this.grid.numDimensions();
        long[] cellGridPosition = new long[n];
        this.grid.getCellGridPositionFlat(key.longValue(), cellGridPosition);
        DataBlock dataBlock = this.n5.readBlock(this.dataset, this.attributes, cellGridPosition);
        if (dataBlock != null) {
            long[] cellMin = new long[n];
            int[] cellDims = new int[n];
            this.grid.getCellDimensions(key.longValue(), cellMin, cellDims);
            ArrayDataAccess data = (ArrayDataAccess)this.cacheArrayLoader.loadArray((DataBlock)Cast.unchecked((Object)dataBlock), cellDims);
            return new Cell(cellDims, cellMin, (Object)data);
        }
        return (Cell)this.missingLoader.get((Object)key);
    }

    private static <T extends NativeType<T>> ArrayDataAccessLoader createN5CacheArrayLoader(T type, Set<AccessFlags> accessFlags) {
        boolean dirty = accessFlags.contains(AccessFlags.DIRTY);
        boolean volatil = accessFlags.contains(AccessFlags.VOLATILE);
        PrimitiveType primitiveType = type.getNativeTypeFactory().getPrimitiveType();
        switch (primitiveType) {
            case BYTE: {
                return new ArrayDataAccessLoader<byte[], AbstractByteArray>(byte[]::new, SubArrayCopy.forPrimitiveType((PrimitiveType)primitiveType), dirty ? (volatil ? data -> new DirtyVolatileByteArray(data, true) : data -> new DirtyByteArray(data)) : (volatil ? data -> new VolatileByteArray(data, true) : data -> new ByteArray(data)));
            }
            case SHORT: {
                return new ArrayDataAccessLoader<short[], AbstractShortArray>(short[]::new, SubArrayCopy.forPrimitiveType((PrimitiveType)primitiveType), dirty ? (volatil ? data -> new DirtyVolatileShortArray(data, true) : data -> new DirtyShortArray(data)) : (volatil ? data -> new VolatileShortArray(data, true) : data -> new ShortArray(data)));
            }
            case INT: {
                return new ArrayDataAccessLoader<int[], AbstractIntArray>(int[]::new, SubArrayCopy.forPrimitiveType((PrimitiveType)primitiveType), dirty ? (volatil ? data -> new DirtyVolatileIntArray(data, true) : data -> new DirtyIntArray(data)) : (volatil ? data -> new VolatileIntArray(data, true) : data -> new IntArray(data)));
            }
            case LONG: {
                return new ArrayDataAccessLoader<long[], AbstractLongArray>(long[]::new, SubArrayCopy.forPrimitiveType((PrimitiveType)primitiveType), dirty ? (volatil ? data -> new DirtyVolatileLongArray(data, true) : data -> new DirtyLongArray(data)) : (volatil ? data -> new VolatileLongArray(data, true) : data -> new LongArray(data)));
            }
            case FLOAT: {
                return new ArrayDataAccessLoader<float[], AbstractFloatArray>(float[]::new, SubArrayCopy.forPrimitiveType((PrimitiveType)primitiveType), dirty ? (volatil ? data -> new DirtyVolatileFloatArray(data, true) : data -> new DirtyFloatArray(data)) : (volatil ? data -> new VolatileFloatArray(data, true) : data -> new FloatArray(data)));
            }
            case DOUBLE: {
                return new ArrayDataAccessLoader<double[], AbstractDoubleArray>(double[]::new, SubArrayCopy.forPrimitiveType((PrimitiveType)primitiveType), dirty ? (volatil ? data -> new DirtyVolatileDoubleArray(data, true) : data -> new DirtyDoubleArray(data)) : (volatil ? data -> new VolatileDoubleArray(data, true) : data -> new DoubleArray(data)));
            }
        }
        throw new IllegalArgumentException();
    }

    public static <T extends Type<T>, I extends IterableInterval<T>> Consumer<I> setToDefaultValue(T defaultValue) {
        return rai -> rai.forEach(pixel -> pixel.set(defaultValue));
    }

    private static class ArrayDataAccessLoader<P, A> {
        private final IntFunction<P> createPrimitiveArray;
        private final Function<P, A> createArrayAccess;
        private final SubArrayCopy.Typed<P, P> subArrayCopy;

        ArrayDataAccessLoader(IntFunction<P> createPrimitiveArray, SubArrayCopy.Typed<P, P> subArrayCopy, Function<P, A> createArrayAccess) {
            this.createPrimitiveArray = createPrimitiveArray;
            this.createArrayAccess = createArrayAccess;
            this.subArrayCopy = subArrayCopy;
        }

        public A loadArray(DataBlock<P> dataBlock, int[] cellDimensions) {
            int[] dataBlockSize = dataBlock.getSize();
            if (Arrays.equals(dataBlockSize, cellDimensions)) {
                return this.createArrayAccess.apply(dataBlock.getData());
            }
            P data = this.createPrimitiveArray.apply((int)Intervals.numElements((int[])cellDimensions));
            Object src = dataBlock.getData();
            int[] pos = new int[dataBlockSize.length];
            int[] size = new int[dataBlockSize.length];
            Arrays.setAll(size, d -> Math.min(dataBlockSize[d], cellDimensions[d]));
            this.subArrayCopy.copy(src, dataBlockSize, pos, data, cellDimensions, pos, size);
            return this.createArrayAccess.apply(data);
        }
    }
}

