/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNGReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DNGReader.class);
    private static final int CANON_TAG = 34665;
    private static final int TIFF_EPS_STANDARD = 37398;
    private static final int COLOR_MAP = 33422;
    private static final int WHITE_BALANCE_RGB_COEFFS = 16385;
    protected IFD original;
    private double[] whiteBalance;
    private Object cfaPattern;
    private byte[] lastPlane = null;
    private int lastIndex = -1;

    public DNGReader() {
        super("DNG", new String[]{"cr2", "crw", "jpg", "thm", "wav", "tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Graphics"};
        this.mergeSubIFDs = true;
        this.canSeparateSeries = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        boolean hasEPSTag = ifd.containsKey((Object)37398);
        if (!hasEPSTag) {
            hasEPSTag = ifd.containsKey((Object)34665);
        }
        String make = ifd.getIFDTextValue(271);
        String model = ifd.getIFDTextValue(272);
        String software = ifd.getIFDTextValue(305);
        return !(make == null || make.indexOf("Canon") == -1 || !hasEPSTag || model != null && model.endsWith("S1 IS") || software != null && software.indexOf("Canon") == -1);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        IFD ifd = (IFD)this.ifds.get(no);
        int[] bps = ifd.getBitsPerSample();
        int dataSize = bps[0];
        long[] byteCounts = ifd.getStripByteCounts();
        long totalBytes = 0L;
        for (long b : byteCounts) {
            totalBytes += b;
        }
        if (totalBytes == (long)FormatTools.getPlaneSize((IFormatReader)this) || bps.length > 1) {
            if (this.tiffParser == null) {
                this.initTiffParser();
            }
            byte[] b = new byte[buf.length / 2];
            this.tiffParser.getSamples((IFD)this.ifds.get(0), b, x, y, (long)w, (long)h);
            for (int i = 0; i < b.length; ++i) {
                int c = this.isInterleaved() ? i % 3 : i / (b.length / 3);
                short v = (short)(b[i] & 0xFF);
                v = this.adjustForWhiteBalance(v, c);
                DataTools.unpackBytes(v, buf, i * 2, 2, this.isLittleEndian());
            }
            return buf;
        }
        if (this.lastPlane == null || this.lastIndex != no) {
            long[] offsets = ifd.getStripOffsets();
            ByteArrayOutputStream src = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < byteCounts.length; ++i) {
                    byte[] t = new byte[(int)byteCounts[i]];
                    this.in.seek(offsets[i]);
                    this.in.read(t);
                    src.write(t);
                }
            }
            catch (Exception e) {
                src.close();
                throw e;
            }
            int[] colorMap = new int[]{1, 0, 2, 1};
            short[] ifdColors = (short[])ifd.get((Object)33422);
            if (ifdColors != null && ifdColors.length >= colorMap.length) {
                int q;
                boolean colorsValid = true;
                for (q = 0; q < colorMap.length; ++q) {
                    if (ifdColors[q] >= 0 && ifdColors[q] <= 2) continue;
                    colorsValid = false;
                    break;
                }
                if (colorsValid) {
                    for (q = 0; q < colorMap.length; ++q) {
                        colorMap[q] = ifdColors[q];
                    }
                }
            }
            this.lastPlane = new byte[FormatTools.getPlaneSize((IFormatReader)this)];
            short[] pix = null;
            try (RandomAccessInputStream bb = new RandomAccessInputStream(new ByteArrayHandle(src.toByteArray()));){
                src.close();
                pix = new short[this.getSizeX() * this.getSizeY() * 3];
                for (int row = 0; row < this.getSizeY(); ++row) {
                    int realRow = row;
                    for (int col = 0; col < this.getSizeX(); ++col) {
                        short val = (short)(bb.readBits(dataSize) & 0xFFFF);
                        int mapIndex = realRow % 2 * 2 + col % 2;
                        int redOffset = realRow * this.getSizeX() + col;
                        int greenOffset = (this.getSizeY() + realRow) * this.getSizeX() + col;
                        int blueOffset = (2 * this.getSizeY() + realRow) * this.getSizeX() + col;
                        if (colorMap[mapIndex] == 0) {
                            pix[redOffset] = this.adjustForWhiteBalance(val, 0);
                            continue;
                        }
                        if (colorMap[mapIndex] == 1) {
                            pix[greenOffset] = this.adjustForWhiteBalance(val, 1);
                            continue;
                        }
                        if (colorMap[mapIndex] != 2) continue;
                        pix[blueOffset] = this.adjustForWhiteBalance(val, 2);
                    }
                }
            }
            ImageTools.interpolate((short[])pix, (byte[])buf, (int[])colorMap, (int)this.getSizeX(), (int)this.getSizeY(), (boolean)this.isLittleEndian());
            this.lastIndex = no;
        }
        int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType()) * 3;
        int rowLen = w * bpp;
        int width = this.getSizeX() * bpp;
        for (int row = 0; row < h; ++row) {
            System.arraycopy(this.lastPlane, (row + y) * width + x * bpp, buf, row * rowLen, rowLen);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.original = null;
            this.whiteBalance = null;
            this.cfaPattern = null;
            this.lastPlane = null;
            this.lastIndex = -1;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        CoreMetadata m = (CoreMetadata)this.core.get(0, 0);
        m.imageCount = this.ifds.size();
        IFD firstIFD = (IFD)this.ifds.get(0);
        PhotoInterp photo = firstIFD.getPhotometricInterpretation();
        int samples = firstIFD.getSamplesPerPixel();
        boolean bl = m.rgb = samples > 1 || photo == PhotoInterp.RGB || photo == PhotoInterp.CFA_ARRAY;
        if (photo == PhotoInterp.CFA_ARRAY) {
            samples = 3;
        }
        m.sizeX = (int)firstIFD.getImageWidth();
        m.sizeY = (int)firstIFD.getImageLength();
        m.sizeZ = 1;
        m.sizeC = this.isRGB() ? samples : 1;
        m.sizeT = this.ifds.size();
        m.pixelType = 3;
        m.indexed = false;
        IFDList exifIFDs = this.tiffParser.getExifIFDs();
        if (exifIFDs.size() > 0) {
            IFD exifIFD = (IFD)exifIFDs.get(0);
            this.tiffParser.fillInIFD(exifIFD);
            for (Integer key : exifIFD.keySet()) {
                int tag = key;
                String name = IFD.getIFDTagName((int)tag);
                if (tag == 41730) {
                    byte[] cfa = (byte[])exifIFD.get((Object)key);
                    int[] colorMap = new int[cfa.length];
                    for (int i = 0; i < cfa.length; ++i) {
                        colorMap[i] = cfa[i];
                    }
                    this.addGlobalMeta(name, colorMap);
                    this.cfaPattern = colorMap;
                    continue;
                }
                this.addGlobalMeta(name, exifIFD.get((Object)key));
                if (!name.equals("MAKER_NOTE")) continue;
                byte[] b = (byte[])exifIFD.get((Object)key);
                int offset = DataTools.bytesToInt(b, b.length - 4, this.isLittleEndian());
                byte[] buf = new byte[b.length + offset - 8];
                System.arraycopy(b, b.length - 8, buf, 0, 8);
                System.arraycopy(b, 0, buf, offset, b.length - 8);
                IFD note = null;
                try (RandomAccessInputStream makerNote = new RandomAccessInputStream(buf);){
                    TiffParser tp = new TiffParser(makerNote);
                    note = tp.getFirstIFD();
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to parse first IFD", (Throwable)e);
                }
                if (note == null) continue;
                for (Integer nextKey : note.keySet()) {
                    int nextTag = nextKey;
                    this.addGlobalMeta(name, note.get((Object)nextKey));
                    if (nextTag != 16385) continue;
                    if (note.get((Object)nextTag) instanceof TiffRational[]) {
                        TiffRational[] wb = (TiffRational[])note.get((Object)nextTag);
                        this.whiteBalance = new double[wb.length];
                        for (int i = 0; i < wb.length; ++i) {
                            this.whiteBalance[i] = wb[i].doubleValue();
                        }
                        continue;
                    }
                    this.whiteBalance = new double[3];
                    this.whiteBalance[0] = 2.391381;
                    this.whiteBalance[1] = 0.929156;
                    this.whiteBalance[2] = 1.298254;
                }
            }
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.original = (IFD)this.ifds.get(0);
        if (this.cfaPattern != null) {
            this.original.putIFDValue(320, (Object)((int[])this.cfaPattern));
        }
        this.ifds.set(0, (Object)this.original);
        CoreMetadata m = (CoreMetadata)this.core.get(0, 0);
        m.imageCount = 1;
        m.sizeT = 1;
        if (((IFD)this.ifds.get(0)).getSamplesPerPixel() == 1) {
            m.interleaved = true;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }

    private short adjustForWhiteBalance(short val, int index) {
        if (this.whiteBalance != null && this.whiteBalance.length == 3) {
            return (short)((double)val * this.whiteBalance[index]);
        }
        return val;
    }
}

