/*
 * Decompiled with CFR 0.152.
 */
package org.siox;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.Arrays;
import org.siox.ColorSignature;
import org.siox.util.IntArrayList;
import org.siox.util.IntHashMap;
import org.siox.util.Utils;

public class SioxSegmentator {
    public static final String ADD_EDGE = "add";
    public static final String SUB_EDGE = "subtract";
    public static final float CERTAIN_FOREGROUND_CONFIDENCE = 1.0f;
    public static final float FOREGROUND_CONFIDENCE = 0.8f;
    public static final float UNKNOWN_REGION_CONFIDENCE = 0.5f;
    public static final float BACKGROUND_CONFIDENCE = 0.1f;
    public static final float CERTAIN_BACKGROUND_CONFIDENCE = 0.0f;
    private final int imgWidth;
    private final int imgHeight;
    private final int[] labelField;
    private final float[][] knownBg;
    private final float[][] knownFg;
    private float[][] bgSignature;
    private float[][] fgSignature;
    private final float[] limits;
    private final float clusterSize;
    private final IntHashMap hs = new IntHashMap();
    private int regionCount;
    private int[] origImage;
    private boolean segmentated;

    public SioxSegmentator(int w, int h, float[] limits) {
        this.imgWidth = w;
        this.imgHeight = h;
        this.labelField = new int[this.imgWidth * this.imgHeight];
        this.knownBg = new float[this.imgWidth * this.imgHeight][3];
        this.knownFg = new float[this.imgWidth * this.imgHeight][3];
        this.limits = limits == null ? new float[]{0.64f, 1.28f, 2.56f} : limits;
        this.clusterSize = Utils.sqrEuclidianDist(this.limits, new float[]{-this.limits[0], -this.limits[1], -this.limits[2]});
        this.segmentated = false;
    }

    public SioxSegmentator(int w, int h, float[] limits, float[][] bgSignature, float[][] fgSignature) {
        this.imgWidth = w;
        this.imgHeight = h;
        this.labelField = new int[this.imgWidth * this.imgHeight];
        this.knownBg = new float[this.imgWidth * this.imgHeight][3];
        this.knownFg = new float[this.imgWidth * this.imgHeight][3];
        this.limits = limits == null ? new float[]{0.64f, 1.28f, 2.56f} : limits;
        this.clusterSize = Utils.sqrEuclidianDist(this.limits, new float[]{-this.limits[0], -this.limits[1], -this.limits[2]});
        this.segmentated = false;
        this.bgSignature = bgSignature;
        this.fgSignature = fgSignature;
    }

    public boolean segmentate(int[] image, float[] cm, int smoothness, double sizeFactorToKeep) {
        int i;
        this.segmentated = false;
        this.hs.clear();
        this.origImage = new int[image.length];
        System.arraycopy(image, 0, this.origImage, 0, image.length);
        IntArrayList predefinedFgPixels = new IntArrayList();
        int knownBgCount = 0;
        int knownFgCount = 0;
        for (i = 0; i < cm.length; ++i) {
            if (cm[i] <= 0.1f) {
                this.knownBg[knownBgCount++] = Utils.rgbToClab(image[i]);
                continue;
            }
            if (!(cm[i] >= 0.8f)) continue;
            this.knownFg[knownFgCount++] = Utils.rgbToClab(image[i]);
            if (cm[i] != 1.0f) continue;
            predefinedFgPixels.add(i);
        }
        this.bgSignature = ColorSignature.createSignature(this.knownBg, knownBgCount, this.limits, 0.1f);
        this.fgSignature = ColorSignature.createSignature(this.knownFg, knownFgCount, this.limits, 0.1f);
        if (this.bgSignature.length < 1) {
            return false;
        }
        for (i = 0; i < cm.length; ++i) {
            if (cm[i] >= 0.8f) {
                cm[i] = 1.0f;
                continue;
            }
            if (cm[i] > 0.1f) {
                Tupel tupel = (Tupel)this.hs.get(image[i]);
                boolean isBackground = true;
                if (tupel == null) {
                    tupel = new Tupel(0.0f, 0, 0.0f, 0);
                    float[] lab = Utils.rgbToClab(image[i]);
                    float minBg = Utils.sqrEuclidianDist(lab, this.bgSignature[0]);
                    int minIndex = 0;
                    for (int j = 1; j < this.bgSignature.length; ++j) {
                        float d = Utils.sqrEuclidianDist(lab, this.bgSignature[j]);
                        if (!(d < minBg)) continue;
                        minBg = d;
                        minIndex = j;
                    }
                    tupel.minBgDist = minBg;
                    tupel.indexMinBg = minIndex;
                    float minFg = Float.MAX_VALUE;
                    minIndex = -1;
                    for (int j = 0; j < this.fgSignature.length; ++j) {
                        float d = Utils.sqrEuclidianDist(lab, this.fgSignature[j]);
                        if (!(d < minFg)) continue;
                        minFg = d;
                        minIndex = j;
                    }
                    tupel.minFgDist = minFg;
                    tupel.indexMinFg = minIndex;
                    if (this.fgSignature.length == 0) {
                        isBackground = minBg <= this.clusterSize;
                        throw new IllegalStateException("foreground signature does not exist");
                    }
                    isBackground = minBg < minFg;
                    this.hs.put(image[i], (Object)tupel);
                } else {
                    boolean bl = isBackground = tupel.minBgDist <= tupel.minFgDist;
                }
                if (isBackground) {
                    cm[i] = 0.0f;
                    continue;
                }
                cm[i] = 1.0f;
                continue;
            }
            cm[i] = 0.0f;
        }
        Utils.smoothcm(cm, this.imgWidth, this.imgHeight, 0.33f, 0.33f, 0.33f);
        Utils.normalizeMatrix(cm);
        Utils.erode(cm, this.imgWidth, this.imgHeight);
        this.keepOnlyLargeComponents(cm, 0.5f, sizeFactorToKeep, predefinedFgPixels);
        for (i = 0; i < smoothness; ++i) {
            Utils.smoothcm(cm, this.imgWidth, this.imgHeight, 0.33f, 0.33f, 0.33f);
        }
        Utils.normalizeMatrix(cm);
        for (i = 0; i < cm.length; ++i) {
            cm[i] = cm[i] >= 0.5f ? 1.0f : 0.0f;
        }
        this.keepOnlyLargeComponents(cm, 0.5f, sizeFactorToKeep, predefinedFgPixels);
        this.fillColorRegions(cm, image);
        Utils.dilate(cm, this.imgWidth, this.imgHeight);
        this.segmentated = true;
        return true;
    }

    public boolean applyPrecomputedSignatures(int[] image, float[] cm, int smoothness, double sizeFactorToKeep) {
        int i;
        this.segmentated = false;
        this.hs.clear();
        this.origImage = new int[image.length];
        System.arraycopy(image, 0, this.origImage, 0, image.length);
        IntArrayList predefinedFgPixels = new IntArrayList();
        int knownBgCount = 0;
        int knownFgCount = 0;
        for (i = 0; i < cm.length; ++i) {
            if (cm[i] <= 0.1f) {
                this.knownBg[knownBgCount++] = Utils.rgbToClab(image[i]);
                continue;
            }
            if (!(cm[i] >= 0.8f)) continue;
            this.knownFg[knownFgCount++] = Utils.rgbToClab(image[i]);
            if (cm[i] != 1.0f) continue;
            predefinedFgPixels.add(i);
        }
        if (this.bgSignature.length < 1) {
            return false;
        }
        for (i = 0; i < cm.length; ++i) {
            if (cm[i] >= 0.8f) {
                cm[i] = 1.0f;
                continue;
            }
            if (cm[i] > 0.1f) {
                Tupel tupel = (Tupel)this.hs.get(image[i]);
                boolean isBackground = true;
                if (tupel == null) {
                    tupel = new Tupel(0.0f, 0, 0.0f, 0);
                    float[] lab = Utils.rgbToClab(image[i]);
                    float minBg = Utils.sqrEuclidianDist(lab, this.bgSignature[0]);
                    int minIndex = 0;
                    for (int j = 1; j < this.bgSignature.length; ++j) {
                        float d = Utils.sqrEuclidianDist(lab, this.bgSignature[j]);
                        if (!(d < minBg)) continue;
                        minBg = d;
                        minIndex = j;
                    }
                    tupel.minBgDist = minBg;
                    tupel.indexMinBg = minIndex;
                    float minFg = Float.MAX_VALUE;
                    minIndex = -1;
                    for (int j = 0; j < this.fgSignature.length; ++j) {
                        float d = Utils.sqrEuclidianDist(lab, this.fgSignature[j]);
                        if (!(d < minFg)) continue;
                        minFg = d;
                        minIndex = j;
                    }
                    tupel.minFgDist = minFg;
                    tupel.indexMinFg = minIndex;
                    if (this.fgSignature.length == 0) {
                        isBackground = minBg <= this.clusterSize;
                        throw new IllegalStateException("foreground signature does not exist");
                    }
                    isBackground = minBg < minFg;
                    this.hs.put(image[i], (Object)tupel);
                } else {
                    boolean bl = isBackground = tupel.minBgDist <= tupel.minFgDist;
                }
                if (isBackground) {
                    cm[i] = 0.0f;
                    continue;
                }
                cm[i] = 1.0f;
                continue;
            }
            cm[i] = 0.0f;
        }
        Utils.smoothcm(cm, this.imgWidth, this.imgHeight, 0.33f, 0.33f, 0.33f);
        Utils.normalizeMatrix(cm);
        Utils.erode(cm, this.imgWidth, this.imgHeight);
        if (!predefinedFgPixels.isEmpty()) {
            this.keepOnlyLargeComponents(cm, 0.5f, sizeFactorToKeep, predefinedFgPixels);
        } else {
            this.keepOnlyLargeComponents(cm, 0.5f, sizeFactorToKeep);
        }
        for (i = 0; i < smoothness; ++i) {
            Utils.smoothcm(cm, this.imgWidth, this.imgHeight, 0.33f, 0.33f, 0.33f);
        }
        Utils.normalizeMatrix(cm);
        for (i = 0; i < cm.length; ++i) {
            cm[i] = cm[i] >= 0.5f ? 1.0f : 0.0f;
        }
        if (!predefinedFgPixels.isEmpty()) {
            this.keepOnlyLargeComponents(cm, 0.5f, sizeFactorToKeep, predefinedFgPixels);
        } else {
            this.keepOnlyLargeComponents(cm, 0.5f, sizeFactorToKeep);
        }
        this.fillColorRegions(cm, image);
        Utils.dilate(cm, this.imgWidth, this.imgHeight);
        this.segmentated = true;
        return true;
    }

    public boolean segmentatevideo_firstframe(int[] image, float[] cm, double sizeFactorToKeep) {
        int i;
        this.segmentated = false;
        this.hs.clear();
        this.origImage = new int[image.length];
        System.arraycopy(image, 0, this.origImage, 0, image.length);
        int knownBgCount = 0;
        int knownFgCount = 0;
        for (i = 0; i < cm.length; ++i) {
            if (cm[i] <= 0.1f) {
                this.knownBg[knownBgCount++] = Utils.rgbToClab(image[i]);
                continue;
            }
            if (!(cm[i] >= 0.8f)) continue;
            this.knownFg[knownFgCount++] = Utils.rgbToClab(image[i]);
        }
        this.bgSignature = ColorSignature.createSignature(this.knownBg, knownBgCount, this.limits, 0.1f);
        this.fgSignature = ColorSignature.createSignature(this.knownFg, knownFgCount, this.limits, 0.1f);
        if (this.bgSignature.length < 1) {
            return false;
        }
        for (i = 0; i < cm.length; ++i) {
            if (cm[i] >= 0.8f) {
                cm[i] = 1.0f;
                continue;
            }
            if (cm[i] > 0.1f) {
                Tupel tupel = (Tupel)this.hs.get(image[i]);
                boolean isBackground = true;
                if (tupel == null) {
                    tupel = new Tupel(0.0f, 0, 0.0f, 0);
                    float[] lab = Utils.rgbToClab(image[i]);
                    float minBg = Utils.sqrEuclidianDist(lab, this.bgSignature[0]);
                    int minIndex = 0;
                    for (int j = 1; j < this.bgSignature.length; ++j) {
                        float d = Utils.sqrEuclidianDist(lab, this.bgSignature[j]);
                        if (!(d < minBg)) continue;
                        minBg = d;
                        minIndex = j;
                    }
                    tupel.minBgDist = minBg;
                    tupel.indexMinBg = minIndex;
                    float minFg = Float.MAX_VALUE;
                    minIndex = -1;
                    for (int j = 0; j < this.fgSignature.length; ++j) {
                        float d = Utils.sqrEuclidianDist(lab, this.fgSignature[j]);
                        if (!(d < minFg)) continue;
                        minFg = d;
                        minIndex = j;
                    }
                    tupel.minFgDist = minFg;
                    tupel.indexMinFg = minIndex;
                    if (this.fgSignature.length == 0) {
                        isBackground = minBg <= this.clusterSize;
                        throw new IllegalStateException("foreground signature does not exist");
                    }
                    isBackground = minBg < minFg;
                    this.hs.put(image[i], (Object)tupel);
                } else {
                    boolean bl = isBackground = tupel.minBgDist <= tupel.minFgDist;
                }
                if (isBackground) {
                    cm[i] = 0.0f;
                    continue;
                }
                cm[i] = 1.0f;
                continue;
            }
            cm[i] = 0.0f;
        }
        Utils.smoothcm(cm, this.imgWidth, this.imgHeight, 0.33f, 0.33f, 0.33f);
        Utils.normalizeMatrix(cm);
        this.keepOnlyLargeComponents(cm, 0.5f, sizeFactorToKeep);
        this.segmentated = true;
        return true;
    }

    public boolean segmentatevideo_nextframe(int[] image, float[] cm, double sizeFactorToKeep) {
        if (!this.segmentated) {
            throw new IllegalStateException("This method cannot be called before color signatures have been created.");
        }
        this.origImage = new int[image.length];
        System.arraycopy(image, 0, this.origImage, 0, image.length);
        for (int i = 0; i < cm.length; ++i) {
            if (cm[i] >= 0.8f) {
                cm[i] = 1.0f;
                continue;
            }
            if (cm[i] > 0.1f) {
                Tupel tupel = (Tupel)this.hs.get(image[i]);
                boolean isBackground = true;
                if (tupel == null) {
                    tupel = new Tupel(0.0f, 0, 0.0f, 0);
                    float[] lab = Utils.rgbToClab(image[i]);
                    float minBg = Utils.sqrEuclidianDist(lab, this.bgSignature[0]);
                    int minIndex = 0;
                    for (int j = 1; j < this.bgSignature.length; ++j) {
                        float d = Utils.sqrEuclidianDist(lab, this.bgSignature[j]);
                        if (!(d < minBg)) continue;
                        minBg = d;
                        minIndex = j;
                    }
                    tupel.minBgDist = minBg;
                    tupel.indexMinBg = minIndex;
                    float minFg = Float.MAX_VALUE;
                    minIndex = -1;
                    for (int j = 0; j < this.fgSignature.length; ++j) {
                        float d = Utils.sqrEuclidianDist(lab, this.fgSignature[j]);
                        if (!(d < minFg)) continue;
                        minFg = d;
                        minIndex = j;
                    }
                    tupel.minFgDist = minFg;
                    tupel.indexMinFg = minIndex;
                    if (this.fgSignature.length == 0) {
                        isBackground = minBg <= this.clusterSize;
                        throw new IllegalStateException("foreground signature does not exist");
                    }
                    isBackground = minBg < minFg;
                    this.hs.put(image[i], (Object)tupel);
                } else {
                    boolean bl = isBackground = tupel.minBgDist <= tupel.minFgDist;
                }
                if (isBackground) {
                    cm[i] = 0.0f;
                    continue;
                }
                cm[i] = 1.0f;
                continue;
            }
            cm[i] = 0.0f;
        }
        Utils.smoothcm(cm, this.imgWidth, this.imgHeight, 0.33f, 0.33f, 0.33f);
        Utils.normalizeMatrix(cm);
        this.keepOnlyLargeComponents(cm, 0.5f, sizeFactorToKeep);
        this.segmentated = true;
        return true;
    }

    protected void keepOnlyLargeComponents(float[] cm, float threshold, double sizeFactorToKeep) {
        int i;
        Arrays.fill(this.labelField, -1);
        int curlabel = 0;
        int maxregion = 0;
        int maxblob = 0;
        IntArrayList labelSizes = new IntArrayList();
        for (i = 0; i < cm.length; ++i) {
            this.regionCount = 0;
            if (this.labelField[i] == -1 && cm[i] >= threshold) {
                this.regionCount = this.depthFirstSearch(cm, i, threshold, curlabel++);
                labelSizes.add(this.regionCount);
            }
            if (this.regionCount <= maxregion) continue;
            maxregion = this.regionCount;
            maxblob = curlabel - 1;
        }
        for (i = 0; i < cm.length; ++i) {
            if (this.labelField[i] == -1) continue;
            if ((double)labelSizes.get(this.labelField[i]) * sizeFactorToKeep < (double)maxregion) {
                cm[i] = 0.0f;
            }
            if (this.labelField[i] != maxblob) continue;
            cm[i] = 1.0f;
        }
    }

    protected void keepOnlyLargeComponents(float[] cm, float threshold, double sizeFactorToKeep, IntArrayList predefinedFgPixels) {
        int i;
        Arrays.fill(this.labelField, -1);
        int curlabel = 0;
        int maxregion = 0;
        int maxblob = 0;
        IntArrayList labelSizes = new IntArrayList();
        IntArrayList predefinedLabels = new IntArrayList();
        for (i = 0; i < cm.length; ++i) {
            this.regionCount = 0;
            if (this.labelField[i] == -1 && cm[i] >= threshold) {
                this.regionCount = this.depthFirstSearch(cm, i, threshold, curlabel++);
                labelSizes.add(this.regionCount);
            }
            if (this.labelField[i] != -1 && !predefinedLabels.contains(this.labelField[i]) && predefinedFgPixels.contains(i)) {
                predefinedLabels.add(this.labelField[i]);
            }
            if (this.regionCount <= maxregion) continue;
            maxregion = this.regionCount;
            maxblob = curlabel - 1;
        }
        if (sizeFactorToKeep == 0.0) {
            for (i = 0; i < cm.length; ++i) {
                if (this.labelField[i] == -1) continue;
                cm[i] = predefinedLabels.contains(this.labelField[i]) ? 1.0f : 0.0f;
            }
        } else {
            for (i = 0; i < cm.length; ++i) {
                if (this.labelField[i] == -1) continue;
                if ((double)labelSizes.get(this.labelField[i]) * sizeFactorToKeep < (double)maxregion && !predefinedLabels.contains(this.labelField[i])) {
                    cm[i] = 0.0f;
                    continue;
                }
                if (this.labelField[i] != maxblob) continue;
                cm[i] = 1.0f;
            }
        }
    }

    private int depthFirstSearch(float[] cm, int i, float threshold, int curLabel) {
        IntArrayList pixelsToVisit = new IntArrayList();
        int componentSize = 0;
        if (this.labelField[i] == -1 && cm[i] >= threshold) {
            this.labelField[i] = curLabel;
            ++componentSize;
            pixelsToVisit.add(i);
        }
        while (!pixelsToVisit.isEmpty()) {
            int pos = pixelsToVisit.remove(pixelsToVisit.size() - 1);
            int x = pos % this.imgWidth;
            int y = pos / this.imgWidth;
            int left = pos - 1;
            if (x - 1 >= 0 && this.labelField[left] == -1 && cm[left] >= threshold) {
                this.labelField[left] = curLabel;
                ++componentSize;
                pixelsToVisit.add(left);
            }
            int right = pos + 1;
            if (x + 1 < this.imgWidth && this.labelField[right] == -1 && cm[right] >= threshold) {
                this.labelField[right] = curLabel;
                ++componentSize;
                pixelsToVisit.add(right);
            }
            int top = pos - this.imgWidth;
            if (y - 1 >= 0 && this.labelField[top] == -1 && cm[top] >= threshold) {
                this.labelField[top] = curLabel;
                ++componentSize;
                pixelsToVisit.add(top);
            }
            int bottom = pos + this.imgWidth;
            if (y + 1 >= this.imgHeight || this.labelField[bottom] != -1 || !(cm[bottom] >= threshold)) continue;
            this.labelField[bottom] = curLabel;
            ++componentSize;
            pixelsToVisit.add(bottom);
        }
        return componentSize;
    }

    public void subpixelRefine(int x, int y, String brushmode, float threshold, float[] cf, int brushsize) {
        this.subpixelRefine(new Area(new Rectangle(x - brushsize, y - brushsize, 2 * brushsize, 2 * brushsize)), brushmode, threshold, cf);
    }

    public void subpixelRefine(Area area, String brushmode, float threshold, float[] cf) {
        if (!this.segmentated) {
            throw new IllegalStateException("no segmentation yet");
        }
        Rectangle r = area.getBounds();
        int x0 = Math.max(0, r.x);
        int y0 = Math.max(0, r.y);
        int xTo = Math.min(this.imgWidth - 1, r.x + r.width);
        int yTo = Math.min(this.imgHeight - 1, r.y + r.height);
        for (int ey = y0; ey < yTo; ++ey) {
            for (int ex = x0; ex < xTo; ++ex) {
                float alpha;
                int val;
                if (!area.contains(ex, ey)) continue;
                int orig = val = this.origImage[ey * this.imgWidth + ex];
                Tupel tupel = (Tupel)this.hs.get(val);
                if (tupel == null) continue;
                float minDistBg = (float)Math.sqrt(tupel.minBgDist);
                float minDistFg = (float)Math.sqrt(tupel.minFgDist);
                if (ADD_EDGE.equals(brushmode)) {
                    if (!(cf[ey * this.imgWidth + ex] < 0.8f)) continue;
                    alpha = minDistFg == 0.0f ? 1.0f : Math.min(minDistBg / minDistFg, 1.0f);
                    if (alpha < threshold) {
                        alpha = 0.0f;
                    }
                    val = Utils.setAlpha(alpha, orig);
                    cf[ey * this.imgWidth + ex] = alpha;
                    continue;
                }
                if (SUB_EDGE.equals(brushmode)) {
                    if (!(cf[ey * this.imgWidth + ex] > 0.8f)) continue;
                    alpha = minDistBg == 0.0f ? 0.0f : 1.0f - Math.min(minDistFg / minDistBg, 1.0f);
                    if (alpha < threshold) {
                        alpha = 0.0f;
                    }
                    val = Utils.setAlpha(alpha, orig);
                    cf[ey * this.imgWidth + ex] = alpha;
                    continue;
                }
                throw new IllegalArgumentException("unknown brush mode: " + brushmode);
            }
        }
    }

    private void fillColorRegions(float[] cm, int[] image) {
        Arrays.fill(this.labelField, -1);
        IntArrayList pixelsToVisit = new IntArrayList();
        for (int i = 0; i < cm.length; ++i) {
            int curLabel;
            if (this.labelField[i] != -1 || cm[i] < 0.5f) continue;
            int origColor = image[i];
            this.labelField[i] = curLabel = i + 1;
            cm[i] = 1.0f;
            pixelsToVisit.add(i);
            while (!pixelsToVisit.isEmpty()) {
                int pos = pixelsToVisit.remove(pixelsToVisit.size() - 1);
                int x = pos % this.imgWidth;
                int y = pos / this.imgWidth;
                int left = pos - 1;
                if (x - 1 >= 0 && this.labelField[left] == -1 && (double)Utils.labcolordiff(image[left], origColor) < 1.0) {
                    this.labelField[left] = curLabel;
                    cm[left] = 1.0f;
                    pixelsToVisit.add(left);
                }
                int right = pos + 1;
                if (x + 1 < this.imgWidth && this.labelField[right] == -1 && (double)Utils.labcolordiff(image[right], origColor) < 1.0) {
                    this.labelField[right] = curLabel;
                    cm[right] = 1.0f;
                    pixelsToVisit.add(right);
                }
                int top = pos - this.imgWidth;
                if (y - 1 >= 0 && this.labelField[top] == -1 && (double)Utils.labcolordiff(image[top], origColor) < 1.0) {
                    this.labelField[top] = curLabel;
                    cm[top] = 1.0f;
                    pixelsToVisit.add(top);
                }
                int bottom = pos + this.imgWidth;
                if (y + 1 >= this.imgHeight || this.labelField[bottom] != -1 || !((double)Utils.labcolordiff(image[bottom], origColor) < 1.0)) continue;
                this.labelField[bottom] = curLabel;
                cm[bottom] = 1.0f;
                pixelsToVisit.add(bottom);
            }
        }
    }

    public float[][] getBgSignature() {
        return this.bgSignature;
    }

    public float[][] getFgSignature() {
        return this.fgSignature;
    }

    private final class Tupel {
        float minBgDist;
        int indexMinBg;
        float minFgDist;
        int indexMinFg;

        Tupel(float minBgDist, int indexMinBg, float minFgDist, int indexMinFg) {
            this.minBgDist = minBgDist;
            this.indexMinBg = indexMinBg;
            this.minFgDist = minFgDist;
            this.indexMinFg = indexMinFg;
        }
    }
}

