/*
 * Decompiled with CFR 0.152.
 */
package org.siox.example;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class CursorFactory {
    private CursorFactory() {
    }

    public static Cursor createFilledSquareCursor(double diameter, double scale, Cursor defaultCursor) {
        int size = (int)(diameter * scale);
        if (size < 2) {
            return defaultCursor;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension d = toolkit.getBestCursorSize(size, size);
        if (d.width < size || d.height < size) {
            return defaultCursor;
        }
        BufferedImage im = new BufferedImage(d.width, d.height, 2);
        Graphics g = im.getGraphics();
        int delta = Math.max(1, (int)scale);
        for (int i = 0; i < 3 && 2 * i * delta < size; ++i) {
            g.setColor(i % 2 == 0 ? Color.white : Color.black);
            g.fillRect(i * delta, i * delta, size - 2 * i * delta, size - 2 * i * delta);
        }
        g.dispose();
        Point hotspot = new Point(size / 2, size / 2);
        String name = "FilledSquare" + size;
        return toolkit.createCustomCursor(im, hotspot, name);
    }

    public static Cursor createDiskCursor(int diameter, float scale, Cursor defaultCursor) {
        int size = (int)((double)((float)diameter * scale) + 0.5);
        if (size <= 2) {
            return defaultCursor;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension d = toolkit.getBestCursorSize(size, size);
        if (d.width < size || d.height < size) {
            return defaultCursor;
        }
        BufferedImage im = new BufferedImage(d.width, d.height, 2);
        Graphics2D g = (Graphics2D)im.getGraphics();
        BufferedImage diskImage = (double)scale <= 1.0 ? CursorFactory.getImageWithDisk(size) : CursorFactory.getImageWithDisk(diameter);
        g.drawImage(diskImage, 0, 0, size, size, null);
        g.dispose();
        Point hotspot = new Point(size / 2, size / 2);
        String name = "Disc" + size;
        return toolkit.createCustomCursor(im, hotspot, name);
    }

    private static BufferedImage getImageWithDisk(int size) {
        BufferedImage im = new BufferedImage(size, size, 2);
        Graphics2D g = (Graphics2D)im.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < 3 && 2 * i < size; ++i) {
            g.setColor(i % 2 == 0 ? Color.white : Color.black);
            g.fillOval(i, i, size - 2 * i, size - 2 * i);
        }
        g.dispose();
        return im;
    }

    public static Area getAreaBrushedByRect(int x0, int y0, int x1, int y1, int width, int height) {
        if (x0 > x1) {
            return CursorFactory.getAreaBrushedByRect(x1, y1, x0, y0, width, height);
        }
        if (x0 == x1 && y0 == y1) {
            return new Area(new Rectangle2D.Float((float)x0 - (float)width / 2.0f, (float)y0 - (float)height / 2.0f, width, height));
        }
        GeneralPath path = new GeneralPath(1, 6);
        float dx = (float)width / 2.0f;
        float dy = (float)height / 2.0f;
        path.moveTo((float)x0 - dx, (float)y0 - dy);
        path.lineTo((float)x0 - dx, (float)y0 + dy);
        if (y0 <= y1) {
            path.lineTo((float)x1 - dx, (float)y1 + dy);
            path.lineTo((float)x1 + dx, (float)y1 + dy);
            path.lineTo((float)x1 + dx, (float)y1 - dy);
            path.lineTo((float)x0 + dx, (float)y0 - dy);
        } else {
            path.lineTo((float)x0 + dx, (float)y0 + dy);
            path.lineTo((float)x1 + dx, (float)y1 + dy);
            path.lineTo((float)x1 + dx, (float)y1 - dy);
            path.lineTo((float)x1 - dx, (float)y1 - dy);
        }
        path.closePath();
        return new Area(path);
    }

    public static Area getAreaBrushedByDisk(int x0, int y0, int x1, int y1, int diam) {
        if (x0 > x1) {
            return CursorFactory.getAreaBrushedByDisk(x1, y1, x0, y0, diam);
        }
        if (x0 == x1 && y0 == y1) {
            return new Area(new Ellipse2D.Float((float)x0 - (float)diam / 2.0f, (float)y0 - (float)diam / 2.0f, diam, diam));
        }
        float r = (float)diam / 2.0f;
        Area circle0 = new Area(new Ellipse2D.Float((float)x0 - r, (float)y0 - r, diam, diam));
        Area circle1 = new Area(new Ellipse2D.Float((float)x1 - r, (float)y1 - r, diam, diam));
        float dx = x1 - x0;
        float dy = y1 - y0;
        double rScale = (double)r / Math.sqrt(dx * dx + dy * dy);
        float nx = (float)rScale * dy;
        float ny = (float)(-rScale) * dx;
        GeneralPath path = new GeneralPath(1, 4);
        path.moveTo((float)x0 + nx, (float)y0 + ny);
        path.lineTo((float)x0 - nx, (float)y0 - ny);
        path.lineTo((float)x1 - nx, (float)y1 - ny);
        path.lineTo((float)x1 + nx, (float)y1 + ny);
        path.closePath();
        Area area = new Area(path);
        area.add(circle0);
        area.add(circle1);
        return area;
    }
}

