/*
 * Decompiled with CFR 0.152.
 */
package org.siox.example;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.siox.example.ControlJPanel;
import org.siox.example.ExtensionFileFilter;

public class Main
extends JApplet {
    public static final String FRAME_TITLE = "SIOX Api Demo";
    private static final Icon CHEQUER_ICON = new ChequerIcon(Color.gray, Color.darkGray, 8);
    private static final ExtensionFileFilter PNG_FILEFILTER = new ExtensionFileFilter("PNG images (*.png)", new String[]{"png"});
    private static final ExtensionFileFilter IMAGE_FILEFILTER = new ExtensionFileFilter("Images (*.png, *.jpg, *.gif)", new String[]{"png", "jpg", "jpeg", "jpe", "gif"});
    private static JFileChooser jFileChooser = null;
    private final ControlJPanel ctrlJPanel = new ControlJPanel();
    private final boolean canWriteFiles = Main.canWriteFiles();
    private boolean isInitedAsApplet = false;
    private File targetFile = null;
    private final Action openAction = Main.canReadFiles() ? new OpenAction() : new EmptyAction("Open File");
    private final Action openUrlAction = Main.canReadUrls() ? new OpenUrlAction() : new EmptyAction("Open URL");
    private final Action saveAction = this.canWriteFiles ? new SaveAction() : new EmptyAction("Save");
    private final Action saveAsAction = this.canWriteFiles ? new SaveAsAction((SaveAction)this.saveAction) : new EmptyAction("Save As");
    private final Action resetAction = new ResetAction();
    private final Action[] zoomActions = new Action[9];
    private final Action[] bgActions = new Action[]{this.ctrlJPanel.createSetBgAction(null, "Default", null), this.ctrlJPanel.createSetBgAction(Color.white, "White"), this.ctrlJPanel.createSetBgAction(Color.lightGray, "Light Gray"), this.ctrlJPanel.createSetBgAction(Color.darkGray, "Dark Gray"), this.ctrlJPanel.createSetBgAction(Color.black, "Black"), this.ctrlJPanel.createSetBgAction(Color.red, "Red"), this.ctrlJPanel.createSetBgAction(Color.blue, "Blue"), this.ctrlJPanel.createSetBgAction(Color.green, "Green"), this.ctrlJPanel.createSetBgAction(CHEQUER_ICON, "Chequer", CHEQUER_ICON)};
    private final Action[] rulerActions = new Action[]{this.ctrlJPanel.createSetRulerAction(-1), this.ctrlJPanel.createSetRulerAction(1), this.ctrlJPanel.createSetRulerAction(2), this.ctrlJPanel.createSetRulerAction(3)};
    private final ButtonGroup zoomGroup = new ButtonGroup();
    private final ButtonGroup bgGroup = new ButtonGroup();
    private final ButtonGroup rulerGroup = new ButtonGroup();
    private final HashMap hashMapOfZooms = new HashMap();
    private final HashMap hashMapOfBgs = new HashMap();
    private final HashMap hashMapOfRulers = new HashMap();

    public Main() {
        this.ctrlJPanel.enableCheckForUnsavedChanges(this.canWriteFiles);
        int i = 0;
        int j = 4;
        while (j >= -4) {
            int zoom = 1 << Math.abs(j);
            this.zoomActions[i] = this.ctrlJPanel.createZoomAction(zoom, j >= 0);
            --j;
            ++i;
        }
    }

    @Override
    public void init() {
        String[] imgs;
        this.isInitedAsApplet = true;
        System.err.println(this.getAppletInfo());
        String imagelist = this.getParameter("imagelist");
        if (imagelist == null) {
            imgs = null;
        } else {
            StringTokenizer tok = new StringTokenizer(imagelist, ",");
            imgs = new String[tok.countTokens()];
            for (int i = 0; i < imgs.length; ++i) {
                imgs[i] = tok.nextToken();
            }
        }
        this.setJMenuBar(this.createJMenuBar(null, imgs, null));
        JDesktopPane jDesktopPane = new JDesktopPane();
        this.setContentPane(jDesktopPane);
        this.ctrlJPanel.setDesktopPane(jDesktopPane);
        JInternalFrame jif = new JInternalFrame("SIOX Demo");
        jif.getContentPane().add(this.ctrlJPanel);
        jif.pack();
        jDesktopPane.add(jif);
        jif.show();
    }

    @Override
    public String getAppletInfo() {
        return "Demo Applet for the SIOX Java API.\nCopyright 2005, 2006 by Gerald Friedland, Kristian Jantz and Lars Knipping.\nAll rights reserved.";
    }

    @Override
    public String[][] getParameterInfo() {
        return new String[][]{{"imagelist", "String", "Comma separated list of image resources made available to the user.."}};
    }

    private static void showWarning(ControlJPanel ctrlJPanel, String msg) {
        Main.showMessage(ctrlJPanel, "SIOX Api Demo: Warning", msg, 2);
    }

    private static void showMessage(ControlJPanel ctrlJPanel, String title, String msg, int type) {
        Container c = ctrlJPanel.getParent();
        if (c instanceof JInternalFrame) {
            JOptionPane.showInternalMessageDialog(c, msg, title, type);
        } else {
            JOptionPane.showMessageDialog(ctrlJPanel, msg, title, type);
        }
    }

    private static String getMemStat() {
        Runtime rt = Runtime.getRuntime();
        long max = rt.maxMemory();
        return "used: " + Main.getFormattedMemStat(rt.totalMemory() - rt.freeMemory()) + ", max available=" + (max == Long.MAX_VALUE ? "unlimited" : Main.getFormattedMemStat(max));
    }

    private static String getFormattedMemStat(long bytes) {
        int i;
        if (bytes < 2048L) {
            return bytes + "B";
        }
        double val = (double)bytes / 1024.0;
        String[] units = new String[]{"kB", "MB", "GB", "TB", "PB", "EB"};
        for (i = 0; i < units.length && val > 1024.0; ++i, val /= 1024.0) {
        }
        return (int)val + "." + (int)(val * 10.0) % 10 + units[i];
    }

    private static String getMemSettingsInfo(boolean forApplet) {
        return forApplet ? "Maximum JVM memory for Applets can be set with -Xmx<size> (e.g. \"-Xmx512M\")\nin the Plugin Control Panel, Advanced Tab, as Java Runtime Parameter entry." : "Maximum JVM memory for Applets can be set with -Xmx<size> as parameter,\ne.g. \"java -Xmx512M org.siox.example.Main\"";
    }

    private static JFileChooser getJFileChooser() throws SecurityException {
        JFileChooser fChooser = jFileChooser;
        if (fChooser != null) {
            return fChooser;
        }
        fChooser = new JFileChooser();
        fChooser.setFileSelectionMode(0);
        fChooser.addChoosableFileFilter(PNG_FILEFILTER);
        fChooser.addChoosableFileFilter(IMAGE_FILEFILTER);
        fChooser.setMultiSelectionEnabled(false);
        ImagePreview imagePreview = new ImagePreview(fChooser);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)imagePreview.jCheckBox, "North");
        jPanel.add((Component)imagePreview, "Center");
        fChooser.setAccessory(jPanel);
        jFileChooser = fChooser;
        return jFileChooser;
    }

    private static boolean canReadFiles() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                File file = Main.getJFileChooser().getCurrentDirectory();
                securityManager.checkRead(file.getPath());
            }
            catch (SecurityException e) {
                return false;
            }
        }
        return true;
    }

    private static boolean canReadUrls() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkConnect("java.sun.com", 80);
            }
            catch (SecurityException e) {
                return false;
            }
        }
        return true;
    }

    private static boolean canWriteFiles() {
        try {
            File.createTempFile("siox", null).delete();
        }
        catch (SecurityException e) {
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void open(File file) {
        try {
            BufferedImage image;
            try {
                image = ImageIO.read(file);
            }
            catch (SecurityException e) {
                Main.showWarning(this.ctrlJPanel, "Cannot access file " + file.getPath());
                return;
            }
            catch (IOException e) {
                Main.showWarning(this.ctrlJPanel, "Failed to load image " + file.getPath());
                return;
            }
            if (image != null) {
                String title = "SIOX Api Demo:  " + file.getName() + ", " + image.getWidth() + "x" + image.getHeight();
                this.targetFile = file;
                this.ctrlJPanel.openImage(title, image);
            } else {
                Main.showWarning(this.ctrlJPanel, "Unsupported image format: " + file.getPath());
            }
        }
        catch (OutOfMemoryError e) {
            System.gc();
            Main.showWarning(this.ctrlJPanel, "Not enough memory to load image\n" + file.getPath() + ".\n\nJVM memory\n" + Main.getMemStat() + "\n\n" + Main.getMemSettingsInfo(this.isInitedAsApplet));
        }
    }

    private void imageIsOpenedChanged(boolean open) {
        int i;
        this.saveAction.setEnabled(open && this.canWriteFiles && this.targetFile != null);
        this.saveAsAction.setEnabled(open && this.canWriteFiles);
        this.resetAction.setEnabled(open);
        for (i = 0; i < this.zoomActions.length; ++i) {
            this.zoomActions[i].setEnabled(open);
        }
        for (i = 0; i < this.bgActions.length; ++i) {
            this.bgActions[i].setEnabled(open);
        }
        for (i = 0; i < this.rulerActions.length; ++i) {
            this.rulerActions[i].setEnabled(open);
        }
        if (open) {
            String zoomCmd = this.zoomGroup.getSelection().getActionCommand();
            Action zoomAction = (Action)this.hashMapOfZooms.get(zoomCmd);
            zoomAction.actionPerformed(null);
            String bgCmd = this.bgGroup.getSelection().getActionCommand();
            Action bgAction = (Action)this.hashMapOfBgs.get(bgCmd);
            bgAction.actionPerformed(null);
            String rulerCmd = this.rulerGroup.getSelection().getActionCommand();
            Action rulerAction = (Action)this.hashMapOfRulers.get(rulerCmd);
            rulerAction.actionPerformed(null);
        }
    }

    private JMenuBar createJMenuBar(File file, String[] rsrcList, Action exitAction) {
        JRadioButtonMenuItem jMenuItem;
        Action action;
        int i;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu fileJMenu = new JMenu("File");
        JMenu editJMenu = new JMenu("Edit");
        JMenu viewJMenu = new JMenu("View");
        jMenuBar.add(fileJMenu);
        jMenuBar.add(editJMenu);
        jMenuBar.add(viewJMenu);
        fileJMenu.add(this.openAction);
        fileJMenu.add(this.openUrlAction);
        if (rsrcList != null && rsrcList.length > 0) {
            JMenu openRsrcJMenu = new JMenu("Open Resource");
            for (i = 0; i < rsrcList.length; ++i) {
                if (rsrcList[i].length() <= 0) continue;
                openRsrcJMenu.add(new OpenRsrcAction(rsrcList[i]));
            }
            if (openRsrcJMenu.getMenuComponentCount() > 0) {
                fileJMenu.add(openRsrcJMenu);
            }
        }
        fileJMenu.addSeparator();
        fileJMenu.add(this.saveAction);
        fileJMenu.add(this.saveAsAction);
        if (exitAction != null) {
            fileJMenu.addSeparator();
            fileJMenu.add(exitAction);
        }
        editJMenu.add(this.resetAction);
        JMenu viewZoomJMenu = new JMenu("Set Zoom");
        viewJMenu.add(viewZoomJMenu);
        i = 0;
        int j = 4;
        while (j >= -4) {
            action = this.zoomActions[i];
            jMenuItem = new JRadioButtonMenuItem(action);
            jMenuItem.setSelected(j == 0);
            this.zoomGroup.add(jMenuItem);
            jMenuItem.setActionCommand((String)action.getValue("Name"));
            this.hashMapOfZooms.put(jMenuItem.getActionCommand(), action);
            viewZoomJMenu.add(jMenuItem);
            action.setEnabled(false);
            --j;
            ++i;
        }
        JMenu viewBgJMenu = new JMenu("Set Background");
        viewJMenu.add(viewBgJMenu);
        for (int i2 = 0; i2 < this.bgActions.length; ++i2) {
            action = this.bgActions[i2];
            jMenuItem = new JRadioButtonMenuItem(action);
            jMenuItem.setSelected(i2 == 0);
            this.bgGroup.add(jMenuItem);
            jMenuItem.setActionCommand((String)action.getValue("Name"));
            this.hashMapOfBgs.put(jMenuItem.getActionCommand(), action);
            viewBgJMenu.add(jMenuItem);
            action.setEnabled(false);
        }
        JMenu viewRulerJMenu = new JMenu("Set Ruler");
        viewJMenu.add(viewRulerJMenu);
        for (int i3 = 0; i3 < this.rulerActions.length; ++i3) {
            Action action2 = this.rulerActions[i3];
            JRadioButtonMenuItem jMenuItem2 = new JRadioButtonMenuItem(action2);
            jMenuItem2.setSelected(i3 == 0);
            this.rulerGroup.add(jMenuItem2);
            jMenuItem2.setActionCommand((String)action2.getValue("Name"));
            this.hashMapOfRulers.put(jMenuItem2.getActionCommand(), action2);
            viewRulerJMenu.add(jMenuItem2);
            action2.setEnabled(false);
        }
        viewJMenu.add(new ShowMemStatAction());
        this.ctrlJPanel.addImageWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                Main.this.imageIsOpenedChanged(true);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                Main.this.targetFile = null;
                Main.this.imageIsOpenedChanged(false);
            }
        });
        this.ctrlJPanel.addImageWindowListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                Main.this.imageIsOpenedChanged(true);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                Main.this.targetFile = null;
                Main.this.imageIsOpenedChanged(false);
            }
        });
        if (file != null) {
            this.open(file);
        }
        return jMenuBar;
    }

    private static void printUsage() {
        System.out.println("A Demo program for the SIOX Java API.\n\nusage> java org.siox.example.Main [-h | <infile>]\n\noptions:\n-h         Displays this message.\nparameters:\n<infile>   Image file in format supported by Java (at least PNG, JPG, GIF)\n");
    }

    public static void main(String[] argv) {
        if (argv.length > 1 || argv.length == 1 && argv[0].startsWith("-h")) {
            Main.printUsage();
            System.exit(argv.length > 1 ? -1 : 0);
        }
        Main main = new Main();
        File file = argv.length > 0 ? new File(argv[0]) : null;
        JFrame jFrame = new JFrame(FRAME_TITLE);
        jFrame.setContentPane(main.ctrlJPanel);
        final ExitAction exitAction = new ExitAction(main.ctrlJPanel, jFrame);
        jFrame.setJMenuBar(main.createJMenuBar(file, null, exitAction));
        jFrame.pack();
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                exitAction.actionPerformed(null);
            }
        });
        jFrame.setVisible(true);
    }

    private static class ImagePreview
    extends JComponent
    implements ChangeListener,
    PropertyChangeListener {
        public final JCheckBox jCheckBox = new JCheckBox("Preview Images");
        private final JFileChooser jFileChooser;
        private BufferedImage image = null;

        ImagePreview(JFileChooser jFileChooser) {
            this.setPreferredSize(new Dimension(150, 150));
            this.jFileChooser = jFileChooser;
            jFileChooser.addPropertyChangeListener(this);
            this.jCheckBox.addChangeListener(this);
            String tooltipString = "Show Preview of Any Selected Image.";
            this.setToolTipText("Show Preview of Any Selected Image.");
            this.jCheckBox.setToolTipText("Show Preview of Any Selected Image.");
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            this.updateImage();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateImage();
        }

        @Override
        protected void paintComponent(Graphics g) {
            BufferedImage img = this.image;
            if (img == null) {
                return;
            }
            int w = this.getWidth();
            int h = this.getHeight();
            int iw = img.getWidth();
            int ih = img.getHeight();
            double scale = Math.min(1.0, Math.min((double)w / (double)iw, (double)h / (double)ih));
            AffineTransform af = AffineTransform.getScaleInstance(scale, scale);
            ((Graphics2D)g).drawImage(img, af, null);
            String info = iw + "x" + ih;
            g.setColor(this.getBackground());
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    g.drawString(info, 6 + dx, h - 6 + dy);
                }
            }
            g.setColor(this.getForeground());
            g.drawString(info, 6, h - 6);
        }

        private void updateImage() {
            try {
                File file = this.jCheckBox.isSelected() ? Main.getJFileChooser().getSelectedFile() : null;
                this.image = file == null || !file.isFile() ? null : ImageIO.read(file);
            }
            catch (SecurityException e) {
                this.image = null;
            }
            catch (IOException e) {
                this.image = null;
            }
            finally {
                this.repaint();
            }
        }
    }

    private static class ChequerIcon
    implements Icon {
        private final Color c0;
        private final Color c1;
        private final int size;

        ChequerIcon(Color c0, Color c1, int squareSize) {
            this.c0 = c0;
            this.c1 = c1;
            this.size = 2 * squareSize;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public void paintIcon(Component comp, Graphics graphics, int x, int y) {
            Graphics g = graphics.create();
            int d = this.size / 2;
            g.translate(x, y);
            g.setColor(this.c0);
            g.fillRect(0, 0, d, d);
            g.fillRect(d, d, d, d);
            g.setColor(this.c1);
            g.fillRect(d, 0, d, d);
            g.fillRect(0, d, d, d);
            g.dispose();
        }
    }

    private static class EmptyAction
    extends AbstractAction {
        EmptyAction(String name) {
            super(name);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private static class ExitAction
    extends AbstractAction {
        final ControlJPanel ctrlJPanel;
        final JFrame jFrame;

        ExitAction(ControlJPanel ctrlJPanel, JFrame jFrame) {
            super("Exit");
            this.putValue("ShortDescription", "Exits Application.");
            this.ctrlJPanel = ctrlJPanel;
            this.jFrame = jFrame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.ctrlJPanel.closeImage()) {
                this.jFrame.dispose();
                System.exit(0);
            }
        }
    }

    private class ResetAction
    extends AbstractAction {
        public ResetAction() {
            super("Reset");
            this.putValue("ShortDescription", "Resets Image and Control Panel Components.");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.ctrlJPanel.reset();
        }
    }

    private class ShowMemStatAction
    extends AbstractAction {
        ShowMemStatAction() {
            super("Show Memory Usage");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.gc();
            Main.showMessage(Main.this.ctrlJPanel, "SIOX Api Demo: Memory Usage", "JVM memory\n" + Main.getMemStat(), 1);
        }
    }

    private class SaveAsAction
    extends AbstractAction {
        private final SaveAction saveAction;

        SaveAsAction(SaveAction saveAction) {
            super("Save As");
            this.putValue("ShortDescription", "Saves Image as PNG to User Selected File.");
            this.setEnabled(false);
            this.saveAction = saveAction;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser fChooser;
            try {
                fChooser = Main.getJFileChooser();
            }
            catch (SecurityException e) {
                Main.showWarning(Main.this.ctrlJPanel, "Failed to accesss file system.");
                return;
            }
            fChooser.setDialogTitle("SIOX Api Demo: Save as PNG");
            fChooser.setFileFilter(PNG_FILEFILTER);
            if (0 != fChooser.showSaveDialog(Main.this.ctrlJPanel)) {
                return;
            }
            File file = fChooser.getSelectedFile();
            if (file != null && Main.this.ctrlJPanel.storeCurrentImageTo(file, true)) {
                Main.this.targetFile = file;
                this.saveAction.setEnabled(true);
            }
        }
    }

    private class SaveAction
    extends AbstractAction {
        SaveAction() {
            super("Save");
            this.putValue("ShortDescription", "Saves Image as PNG.");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = Main.this.targetFile;
            if (file == null) {
                throw new IllegalStateException("no target file for save");
            }
            Main.this.ctrlJPanel.storeCurrentImageTo(file, false);
        }
    }

    private class OpenRsrcAction
    extends OpenUrlAction {
        private final String name;

        OpenRsrcAction(String name) {
            super(name, "Opens the Image Resource " + name + ".");
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            URL url;
            if (!Main.this.ctrlJPanel.closeImage()) {
                return;
            }
            try {
                url = this.getClass().getClassLoader().getResource(this.name);
            }
            catch (SecurityException e) {
                Main.showWarning(Main.this.ctrlJPanel, "Failed to access resource " + this.name + ".");
                this.setEnabled(false);
                return;
            }
            if (url != null) {
                try {
                    this.open(url);
                }
                catch (OutOfMemoryError e) {
                    System.gc();
                    Main.showWarning(Main.this.ctrlJPanel, "Not enough memory to load image\n" + url + ".\n\nJVM memory\n" + Main.getMemStat() + "\n\n" + Main.getMemSettingsInfo(Main.this.isInitedAsApplet));
                }
            } else {
                Main.showWarning(Main.this.ctrlJPanel, "Failed to locate resource " + this.name + ".");
            }
        }
    }

    private class OpenUrlAction
    extends AbstractAction {
        private final JTextField jTextField;

        OpenUrlAction() {
            super("Open URL");
            this.jTextField = new JTextField("http://", 30);
            this.putValue("ShortDescription", "Reads an Image from a URL.");
        }

        OpenUrlAction(String name, String tooltip) {
            super(name);
            this.jTextField = new JTextField("http://", 30);
            this.putValue("ShortDescription", tooltip);
        }

        void open(URL url) {
            try {
                BufferedImage image = ImageIO.read(url);
                if (image != null) {
                    String title = "SIOX Api Demo:  " + new File(url.getPath()).getName() + ", " + image.getWidth() + "x" + image.getHeight();
                    Main.this.targetFile = null;
                    Main.this.ctrlJPanel.openImage(title, image);
                } else {
                    Main.showWarning(Main.this.ctrlJPanel, "Unsupported image format: " + url);
                }
            }
            catch (SecurityException e) {
                Main.showWarning(Main.this.ctrlJPanel, "Not allowed to load image " + url);
            }
            catch (IOException e) {
                Main.showWarning(Main.this.ctrlJPanel, "Failed to load image " + url);
            }
        }

        private URL toUrl(String urlString) {
            try {
                return new URL(urlString);
            }
            catch (MalformedURLException e) {
                try {
                    return new URL("http://" + urlString);
                }
                catch (MalformedURLException mue) {
                    return null;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!Main.this.ctrlJPanel.closeImage()) {
                return;
            }
            Object[] msg = new Object[]{"Image URL:", this.jTextField};
            if (0 != JOptionPane.showConfirmDialog(Main.this.ctrlJPanel, msg, "SIOX Api Demo:  Open URL", 2, 3)) {
                return;
            }
            URL url = this.toUrl(this.jTextField.getText());
            if (url == null) {
                Main.showWarning(Main.this.ctrlJPanel, "Not a valid URL: \"" + this.jTextField.getText() + "\".");
            } else {
                try {
                    this.open(url);
                }
                catch (OutOfMemoryError e) {
                    System.gc();
                    Main.showWarning(Main.this.ctrlJPanel, "Not enough memory to load image\n" + url + ".\n\nJVM memory\n" + Main.getMemStat() + "\n\n" + Main.getMemSettingsInfo(Main.this.isInitedAsApplet));
                }
            }
        }
    }

    private class OpenAction
    extends AbstractAction {
        OpenAction() {
            super("Open File");
            this.putValue("ShortDescription", "Opens an Image.");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser fChooser;
            if (!Main.this.ctrlJPanel.closeImage()) {
                return;
            }
            try {
                fChooser = Main.getJFileChooser();
            }
            catch (SecurityException e) {
                Main.showWarning(Main.this.ctrlJPanel, "Failed to accesss file system.");
                this.setEnabled(false);
                return;
            }
            fChooser.setDialogTitle("SIOX Api Demo: Open Image");
            fChooser.setFileFilter(IMAGE_FILEFILTER);
            if (0 != fChooser.showOpenDialog(Main.this.ctrlJPanel)) {
                return;
            }
            File file = fChooser.getSelectedFile();
            if (file != null) {
                Main.this.open(file);
            }
        }
    }
}

