/*
 * Decompiled with CFR 0.152.
 */
package siox;

import fiji.util.gui.OverlayedImageCanvas;
import ij.process.ImageProcessor;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class ImageOverlay
implements OverlayedImageCanvas.Overlay {
    ImageProcessor imp = null;
    Composite composite = AlphaComposite.getInstance(3, 0.5f);

    public ImageOverlay() {
    }

    public ImageOverlay(ImageProcessor imp) {
        this.imp = imp;
    }

    public void paint(Graphics g, int x, int y, double magnification) {
        if (null == this.imp) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform originalTransform = g2d.getTransform();
        AffineTransform at = new AffineTransform();
        at.scale(magnification, magnification);
        at.translate(-x, -y);
        at.concatenate(originalTransform);
        g2d.setTransform(at);
        Composite originalComposite = g2d.getComposite();
        g2d.setComposite(this.composite);
        g2d.drawImage(this.imp.getBufferedImage(), null, null);
        g2d.setTransform(originalTransform);
        g2d.setComposite(originalComposite);
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setImage(ImageProcessor imp) {
        this.imp = imp;
    }
}

