/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.panorama;

import mpicbg.models.NoninvertibleModelException;
import mpicbg.panorama.PanoramaCamera;

public class RectlinearCamera
extends PanoramaCamera<RectlinearCamera> {
    private double sourceMaxSize = 0.0;
    private double sourceWidth = 0.0;
    private double sourceWidth2 = 0.0;
    private double sourceHeight = 0.0;
    private double sourceHeight2 = 0.0;

    public final double getSourceWidth() {
        return this.sourceWidth;
    }

    public final void setSourceWidth(double sourceWidth) {
        this.sourceWidth = sourceWidth;
        this.sourceWidth2 = 0.5 * sourceWidth;
        this.sourceMaxSize = Math.max(sourceWidth, this.sourceHeight);
    }

    public final double getSourceHeight() {
        return this.sourceHeight;
    }

    public final void setSourceHeight(double sourceHeight) {
        this.sourceHeight = sourceHeight;
        this.sourceHeight2 = 0.5 * sourceHeight;
        this.sourceMaxSize = Math.max(this.sourceWidth, sourceHeight);
    }

    public final double[] apply(double[] point) {
        assert (point.length == 3) : "2d homogeneous projections can be applied to 2d homogeneous points only.";
        double[] t = (double[])point.clone();
        this.applyInPlace(t);
        return t;
    }

    public final void applyInPlace(double[] point) {
        assert (point.length == 3) : "2d homogeneous projections can be applied to 2d homogeneous points only.";
        System.err.println("Not yet implemented.  Please feel free to do it yourself.");
    }

    public final double[] applyInverse(double[] point) throws NoninvertibleModelException {
        assert (point.length == 3) : "2d homogeneous projections can be applied to 2d homogeneous points only.";
        double[] t = (double[])point.clone();
        this.applyInPlace(t);
        return null;
    }

    public final void applyInverseInPlace(double[] point) throws NoninvertibleModelException {
        assert (point.length == 3) : "2d homogeneous projections can be applied to 2d homogeneous points only.";
        double x = (point[0] - this.targetWidth2) / this.targetMaxSize;
        double y = (point[1] - this.targetHeight2) / this.targetMaxSize;
        double z = point[2];
        double xt = this.i.m00 * x + this.i.m01 * y + this.i.m02 * z * this.f;
        double yt = this.i.m10 * x + this.i.m11 * y + this.i.m12 * z * this.f;
        double zt = (this.i.m20 * x + this.i.m21 * y + this.i.m22 * z * this.f) * 2.0;
        point[0] = xt / zt * this.sourceMaxSize + this.sourceWidth2;
        point[1] = yt / zt * this.sourceMaxSize + this.sourceHeight2;
        point[2] = zt;
    }

    @Override
    public final RectlinearCamera clone() {
        RectlinearCamera c = new RectlinearCamera();
        c.set(this);
        return c;
    }

    @Override
    public final void set(RectlinearCamera e) {
        super.set(e);
        this.sourceHeight = e.sourceHeight;
        this.sourceHeight2 = e.sourceHeight2;
        this.sourceMaxSize = e.sourceMaxSize;
        this.sourceWidth = e.sourceWidth;
        this.sourceWidth2 = e.sourceWidth2;
    }

    public final String toString() {
        return "";
    }

    public final RectlinearCamera createInverse() {
        RectlinearCamera ict = new RectlinearCamera();
        return ict;
    }
}

