/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import sc.fiji.filamentdetector.model.Filament;
import sc.fiji.filamentdetector.model.Filaments;
import sc.fiji.filamentdetector.model.Tip;

public class TrackedFilament
extends Filaments {
    private static final long serialVersionUID = 1L;
    private static int idCounter = 0;
    private int id;
    private Color color;
    private Tip plusTip;
    private Tip minusTip;

    public boolean lastFilamentIs(Filament filament) {
        return filament.equals(this.get(this.size() - 1));
    }

    public int getId() {
        return this.id;
    }

    public TrackedFilament() {
        this.assignID();
    }

    private synchronized void assignID() {
        this.id = idCounter++;
    }

    public Color getColor() {
        return this.color;
    }

    public String getColorAsHex() {
        return String.format("#%02x%02x%02x%02x", this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
    }

    public void setColor(Color color) {
        this.color = color;
        for (Filament filament : this) {
            filament.setColor(color);
        }
    }

    public List<Double> getLengths() {
        ArrayList<Double> lengths = new ArrayList<Double>();
        for (Filament filament : this) {
            lengths.add(filament.getLength());
        }
        return lengths;
    }

    public List<Double> getFrames() {
        ArrayList<Double> frames = new ArrayList<Double>();
        for (Filament filament : this) {
            frames.add(Double.valueOf(filament.getFrame()));
        }
        return frames;
    }

    public Tip getPlusTip() {
        if (this.plusTip == null) {
            this.detectTips();
        }
        return this.plusTip;
    }

    public Tip getMinusTip() {
        if (this.minusTip == null) {
            this.detectTips();
        }
        return this.minusTip;
    }

    protected void detectTips() {
        double scoreTip2;
        this.matchTips();
        ArrayList<Double> tip1X = new ArrayList<Double>();
        ArrayList<Double> tip1Y = new ArrayList<Double>();
        ArrayList<Double> tip2X = new ArrayList<Double>();
        ArrayList<Double> tip2Y = new ArrayList<Double>();
        ArrayList<Integer> tip1Frame = new ArrayList<Integer>();
        ArrayList<Integer> tip2Frame = new ArrayList<Integer>();
        for (Filament filament : this) {
            double[] x = filament.getXCoordinates();
            double[] y = filament.getYCoordinates();
            tip1X.add(x[0]);
            tip1Y.add(y[0]);
            tip2X.add(x[x.length - 1]);
            tip2Y.add(y[x.length - 1]);
            tip1Frame.add(filament.getFrame());
            tip2Frame.add(filament.getFrame());
        }
        Tip tip1 = new Tip(tip1X.stream().mapToDouble(d -> d).toArray(), tip1Y.stream().mapToDouble(d -> d).toArray(), tip1Frame.stream().mapToInt(d -> d).toArray());
        Tip tip2 = new Tip(tip2X.stream().mapToDouble(d -> d).toArray(), tip2Y.stream().mapToDouble(d -> d).toArray(), tip2Frame.stream().mapToInt(d -> d).toArray());
        boolean reverseCoordinates = false;
        double scoreTip1 = tip1.getStdX() + tip1.getStdY();
        if (scoreTip1 > (scoreTip2 = tip2.getStdX() + tip2.getStdY())) {
            this.plusTip = tip1;
            this.minusTip = tip2;
            reverseCoordinates = true;
        } else {
            this.plusTip = tip2;
            this.minusTip = tip1;
        }
        if (reverseCoordinates) {
            for (Filament filament : this) {
                filament.reverseCoordinates();
            }
        }
    }

    public Filament getFilamentByFrame(double frame) {
        return this.stream().filter(x -> (double)x.getFrame() == frame).findFirst().orElse(null);
    }

    protected void matchTips() {
        Filament lastFilament = (Filament)this.get(0);
        for (Filament filament : this) {
            double dist2;
            double[] tip2;
            double[] tip1 = lastFilament.getTips();
            double dist1 = Math.pow(tip1[0] - (tip2 = filament.getTips())[0], 2.0) + Math.pow(tip1[1] - tip2[1], 2.0);
            if (dist1 > (dist2 = Math.pow(tip1[0] - tip2[2], 2.0) + Math.pow(tip1[1] - tip2[3], 2.0))) {
                filament.reverseCoordinates();
            }
            lastFilament = filament;
        }
    }

    public boolean insideBbox(double[] bbox) {
        for (Filament filament : this) {
            if (filament.insideBbox(bbox)) continue;
            return false;
        }
        return true;
    }
}

