/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.tracking;

import java.util.ArrayList;
import java.util.List;
import net.imagej.ImageJService;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import sc.fiji.filamentdetector.tracking.BBoxLAPFilamentsTracker;
import sc.fiji.filamentdetector.tracking.FilamentsTracker;

@Plugin(type=Service.class)
public class FilamentTrackerService
extends AbstractService
implements ImageJService {
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    @Parameter
    private PluginService pluginService;

    public List<FilamentsTracker> getDetectors() {
        ArrayList<FilamentsTracker> plugins = new ArrayList<FilamentsTracker>();
        for (PluginInfo pluginInfo : this.pluginService.getPluginsOfType(FilamentsTracker.class)) {
            try {
                FilamentsTracker plugin = (FilamentsTracker)pluginInfo.createInstance();
                plugin.setContext(this.context);
                plugins.add(plugin);
            }
            catch (InstantiableException e) {
                this.log.error((Object)("Can't load the following Filament Tracker : " + pluginInfo.getName()));
                this.log.error((Object)e.getMessage());
            }
        }
        return plugins;
    }

    public BBoxLAPFilamentsTracker getBBoxTracker() {
        PluginInfo pluginInfo = this.pluginService.getPlugin(BBoxLAPFilamentsTracker.class);
        try {
            BBoxLAPFilamentsTracker plugin = (BBoxLAPFilamentsTracker)pluginInfo.createInstance();
            plugin.setContext(this.context);
            return plugin;
        }
        catch (InstantiableException e) {
            this.log.error((Object)("Can't load the following Filament Tracker : " + pluginInfo.getName()));
            this.log.error((Object)e.getMessage());
            return null;
        }
    }
}

