/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.tree.FieldConstruction;

public class IdentifierKeyFieldConstruction
implements FieldConstruction {
    private final String key;
    private final Expression value;

    public IdentifierKeyFieldConstruction(String key, Expression value) {
        this.key = key;
        this.value = value;
    }

    public IdentifierKeyFieldConstruction(String key) {
        this(key, null);
    }

    @Override
    public void evaluate(Scope scope, JsonNode in, FieldConstruction.FieldConsumer consumer) throws JsonQueryException {
        if (this.value == null) {
            consumer.accept(this.key, JsonNodeUtils.nullToNullNode(in.get(this.key)));
        } else {
            this.value.apply(scope, in, v -> consumer.accept(this.key, v));
        }
    }

    public String toString() {
        if (this.value == null) {
            return this.key;
        }
        return this.key + ": " + this.value.toString();
    }
}

