/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

public class ByteUtils {
    public static final int BYTE_SIZE = 1;
    public static final int BOOLEAN_SIZE = 1;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int FLOAT_SIZE = 4;
    public static final int DOUBLE_SIZE = 8;
    private static final Unsafe UNSAFE;
    private static final long LONG_ARRAY_OFFSET;

    public static void putByte(byte value, long[] array, long offset) {
        UNSAFE.putByte(array, LONG_ARRAY_OFFSET + offset, value);
    }

    public static byte getByte(long[] array, long offset) {
        return UNSAFE.getByte(array, LONG_ARRAY_OFFSET + offset);
    }

    public static void putBoolean(boolean value, long[] array, long offset) {
        ByteUtils.putByte(value ? (byte)1 : 0, array, offset);
    }

    public static boolean getBoolean(long[] array, long offset) {
        return ByteUtils.getByte(array, offset) != 0;
    }

    public static void putInt(int value, long[] array, long offset) {
        UNSAFE.putInt(array, LONG_ARRAY_OFFSET + offset, value);
    }

    public static int getInt(long[] array, long offset) {
        return UNSAFE.getInt(array, LONG_ARRAY_OFFSET + offset);
    }

    public static void putLong(long value, long[] array, long offset) {
        UNSAFE.putLong(array, LONG_ARRAY_OFFSET + offset, value);
    }

    public static long getLong(long[] array, long offset) {
        return UNSAFE.getLong(array, LONG_ARRAY_OFFSET + offset);
    }

    public static void putFloat(float value, long[] array, long offset) {
        UNSAFE.putFloat(array, LONG_ARRAY_OFFSET + offset, value);
    }

    public static float getFloat(long[] array, long offset) {
        return UNSAFE.getFloat(array, LONG_ARRAY_OFFSET + offset);
    }

    public static void putDouble(double value, long[] array, long offset) {
        UNSAFE.putDouble(array, LONG_ARRAY_OFFSET + offset, value);
    }

    public static double getDouble(long[] array, long offset) {
        return UNSAFE.getDouble(array, LONG_ARRAY_OFFSET + offset);
    }

    public static void copyBytes(long[] srcArray, long srcOffset, long[] dstArray, long dstOffset, int size) {
        UNSAFE.copyMemory(srcArray, LONG_ARRAY_OFFSET + srcOffset, dstArray, LONG_ARRAY_OFFSET + dstOffset, size);
    }

    static {
        try {
            PrivilegedExceptionAction<Unsafe> action = () -> {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            };
            UNSAFE = AccessController.doPrivileged(action);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        LONG_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
    }
}

