/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.Monomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PFunction;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.POperator;
import org.lsmp.djep.sjep.PVariable;
import org.lsmp.djep.sjep.Polynomial;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.ParseException;

public abstract class AbstractPNode
implements PNodeI {
    protected PolynomialCreator pc;

    private AbstractPNode() {
    }

    public AbstractPNode(PolynomialCreator pc) {
        this.pc = pc;
    }

    @Override
    public PNodeI add(PNodeI node) throws ParseException {
        if (node.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return node;
        }
        if (this.equals(node)) {
            return new Monomial(this.pc, this.pc.twoConstant, this);
        }
        if (node instanceof Polynomial) {
            return node.add(this);
        }
        if (this.compareTo(node) < 0) {
            return new Polynomial(this.pc, new PNodeI[]{this, node});
        }
        return new Polynomial(this.pc, new PNodeI[]{node, this});
    }

    @Override
    public PNodeI sub(PNodeI node) throws ParseException {
        if (node.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return node.negate();
        }
        if (this.equals(node)) {
            return this.pc.zeroConstant;
        }
        if (node instanceof Polynomial) {
            return node.negate().add(this);
        }
        if (node instanceof PConstant) {
            return this.add(node.negate());
        }
        return new Polynomial(this.pc, new PNodeI[]{this, new Monomial(this.pc, this.pc.minusOneConstant, node)});
    }

    @Override
    public PNodeI negate() throws ParseException {
        return new Monomial(this.pc, this.pc.minusOneConstant, this);
    }

    @Override
    public PNodeI mul(PNodeI node) throws ParseException {
        if (node.isZero()) {
            return this.pc.zeroConstant;
        }
        if (node.isOne()) {
            return this;
        }
        if (this.equals(node)) {
            return new Monomial(this.pc, this.pc.oneConstant, this, this.pc.twoConstant);
        }
        if (node instanceof PConstant) {
            return new Monomial(this.pc, (PConstant)node, this);
        }
        if (node instanceof Monomial) {
            return ((Monomial)node).mul(this);
        }
        if (this instanceof PConstant) {
            return new Monomial(this.pc, (PConstant)this, node);
        }
        if (this.compareTo(node) < 0) {
            return new Monomial(this.pc, this.pc.oneConstant, new PNodeI[]{this, node}, new PNodeI[]{this.pc.oneConstant, this.pc.oneConstant});
        }
        return new Monomial(this.pc, this.pc.oneConstant, new PNodeI[]{node, this}, new PNodeI[]{this.pc.oneConstant, this.pc.oneConstant});
    }

    @Override
    public PNodeI div(PNodeI node) throws ParseException {
        if (this.equals(node)) {
            return this.pc.oneConstant;
        }
        if (node.isZero()) {
            return this.pc.infConstant;
        }
        if (node.isOne()) {
            return this;
        }
        if (node instanceof Monomial) {
            return ((Monomial)node).invert().mul(this);
        }
        if (this instanceof PConstant) {
            return new Monomial(this.pc, (PConstant)this, node, this.pc.minusOneConstant);
        }
        if (node instanceof PConstant) {
            return new Monomial(this.pc, (PConstant)node.invert(), this);
        }
        return new Monomial(this.pc, this.pc.oneConstant, new PNodeI[]{this, node}, new PNodeI[]{this.pc.oneConstant, this.pc.minusOneConstant});
    }

    @Override
    public PNodeI invert() throws ParseException {
        return this.pow(this.pc.minusOneConstant);
    }

    @Override
    public PNodeI pow(PNodeI node) throws ParseException {
        if (node.isZero()) {
            return this.pc.oneConstant;
        }
        if (node.isOne()) {
            return this;
        }
        return new Monomial(this.pc, this.pc.oneConstant, this, node);
    }

    @Override
    public boolean equals(PNodeI node) {
        return false;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean isOne() {
        return false;
    }

    @Override
    public int compareTo(PNodeI node) {
        if (this instanceof PConstant) {
            if (node instanceof PConstant) {
                return ((PConstant)this).compareTo((PConstant)node);
            }
            return -1;
        }
        if (this instanceof PVariable) {
            if (node instanceof PConstant) {
                return 1;
            }
            if (node instanceof PVariable) {
                return ((PVariable)this).compareTo((PVariable)node);
            }
            if (node instanceof PFunction || node instanceof POperator) {
                return -1;
            }
        }
        if (this instanceof POperator) {
            if (node instanceof PConstant || node instanceof PVariable) {
                return 1;
            }
            if (node instanceof POperator) {
                return ((POperator)this).compareTo((POperator)node);
            }
            if (node instanceof PFunction) {
                return -1;
            }
        }
        if (this instanceof PFunction) {
            if (node instanceof PConstant || node instanceof PVariable || node instanceof PFunction) {
                return 1;
            }
            if (node instanceof PFunction) {
                return ((PFunction)this).compareTo((PFunction)node);
            }
        }
        if (this instanceof Monomial || this instanceof Polynomial) {
            throw new IllegalStateException("Comparison failed " + this.getClass().getName() + " " + node.getClass().getName());
        }
        if (node instanceof Monomial) {
            return -((Monomial)node).compareTo(this);
        }
        if (node instanceof Polynomial) {
            return -((Polynomial)node).compareTo(this);
        }
        throw new IllegalArgumentException("Comparison failed " + this.getClass().getName() + " " + node.getClass().getName());
    }
}

