/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import java.util.Stack;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.UnaryOperatorI;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Scaler;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Add;
import org.nfunk.jep.function.Multiply;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.Subtract;

public class Determinant
extends PostfixMathCommand
implements UnaryOperatorI {
    Add add = new Add();
    Subtract sub = new Subtract();
    Multiply mul = new Multiply();

    public Determinant() {
        this.numberOfParameters = 1;
    }

    @Override
    public Dimensions calcDim(Dimensions ldim) {
        return Dimensions.ONE;
    }

    @Override
    public MatrixValueI calcValue(MatrixValueI res, MatrixValueI lhs) throws ParseException {
        if (!(res instanceof Scaler)) {
            throw new ParseException("det: result must be a scaler");
        }
        if (!(lhs instanceof Matrix)) {
            throw new ParseException("det: argument must be a matrix");
        }
        Matrix mat = (Matrix)lhs;
        if (mat.getNumRows() != mat.getNumCols()) {
            throw new ParseException("det: argument must be a square matrix " + mat);
        }
        if (mat.getNumRows() == 2) {
            res.setEle(0, this.sub.sub(this.mul.mul(mat.getEle(0, 0), mat.getEle(1, 1)), this.mul.mul(mat.getEle(1, 0), mat.getEle(0, 1))));
        } else if (mat.getNumRows() == 3) {
            Object r1 = this.mul.mul(mat.getEle(0, 0), this.mul.mul(mat.getEle(1, 1), mat.getEle(2, 2)));
            Object r2 = this.mul.mul(mat.getEle(0, 1), this.mul.mul(mat.getEle(1, 2), mat.getEle(2, 0)));
            Object r3 = this.mul.mul(mat.getEle(0, 2), this.mul.mul(mat.getEle(1, 0), mat.getEle(2, 1)));
            Object r4 = this.mul.mul(mat.getEle(0, 0), this.mul.mul(mat.getEle(1, 2), mat.getEle(2, 1)));
            Object r5 = this.mul.mul(mat.getEle(0, 1), this.mul.mul(mat.getEle(1, 0), mat.getEle(2, 2)));
            Object r6 = this.mul.mul(mat.getEle(0, 2), this.mul.mul(mat.getEle(1, 1), mat.getEle(2, 0)));
            Object r7 = this.add.add(r1, this.add.add(r2, r3));
            Object r8 = this.add.add(r4, this.add.add(r5, r6));
            res.setEle(0, this.sub.sub(r7, r8));
        } else {
            Object[][] m = mat.getEles();
            res.setEle(0, this.det(m));
        }
        return res;
    }

    public static Object[][] dropRowCol(Object[][] mat, int xrow, int xcol) {
        int nrows = mat.length;
        int ncols = mat[0].length;
        Object[][] res = new Object[nrows - 1][ncols - 1];
        int currow = 0;
        for (int i = 0; i < nrows; ++i) {
            if (i == xrow) continue;
            int curcol = 0;
            for (int j = 0; j < ncols; ++j) {
                if (j == xcol) continue;
                res[currow][curcol] = mat[i][j];
                ++curcol;
            }
            ++currow;
        }
        return res;
    }

    public Object det(Object[][] mat) throws ParseException {
        if (mat.length == 1) {
            return mat[0][0];
        }
        if (mat.length == 2) {
            return this.sub.sub(this.mul.mul(mat[0][0], mat[1][1]), this.mul.mul(mat[1][0], mat[0][1]));
        }
        Object res = new Double(0.0);
        for (int i = 0; i < mat.length; ++i) {
            Object[][] m = Determinant.dropRowCol(mat, 0, i);
            Object det = this.det(m);
            res = i % 2 == 0 ? this.add.add(res, this.mul.mul(mat[0][i], det)) : this.sub.sub(res, this.mul.mul(mat[0][i], det));
        }
        return res;
    }

    @Override
    public void run(Stack s) throws ParseException {
        MatrixValueI obj = (MatrixValueI)s.pop();
        MatrixValueI res = Tensor.getInstance(this.calcDim(obj.getDim()));
        this.calcValue(res, obj);
        s.push(res);
    }
}

