/*
 * Decompiled with CFR 0.152.
 */
package ij3d.segmentation;

import customnode.CustomTriangleMesh;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Plot;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import ij3d.Content;
import ij3d.Image3DUniverse;
import ij3d.behaviors.InteractiveBehavior;
import ij3d.behaviors.Picker;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import levelsets.ij.LevelSet;
import marchingcubes.MCTriangulator;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3d;

public class Blob_Segmentation_in_3D
implements PlugIn {
    public static boolean debug = false;

    public void run(String arg) {
        IJ.log((String)"Segment blob in 3D Viewer:\n * Click with the WAND tool on any 3D blob.\n * Shift-click with WAND to edit Level Sets options.");
        if (Image3DUniverse.universes.isEmpty()) {
            Image3DUniverse univ = new Image3DUniverse();
            univ.addInteractiveBehavior(new GrowBlob(univ));
            univ.show();
        } else {
            for (Image3DUniverse univ : Image3DUniverse.universes) {
                univ.addInteractiveBehavior(new GrowBlob(univ));
            }
        }
    }

    public static final double measureSurface(List<Point3f> triangles) {
        if (0 != triangles.size() % 3) {
            IJ.log((String)"Could not measure surface: triangle list is not a multiple of 3.");
            return 0.0;
        }
        double s = 0.0;
        Iterator<Point3f> it = triangles.iterator();
        while (it.hasNext()) {
            s += Blob_Segmentation_in_3D.measureArea(it.next(), it.next(), it.next());
        }
        return s;
    }

    public static final double measureArea(Point3f p1, Point3f p2, Point3f p3) {
        return 0.5 * Blob_Segmentation_in_3D.distancePointToLine(p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, p3.x, p3.y, p3.z) * (double)p2.distance(p3);
    }

    public static double distancePointToLine(double px, double py, double pz, double lx1, double ly1, double lz1, double lx2, double ly2, double lz2) {
        double segment_length = new Vector3d(lx2 - lx1, ly2 - ly1, lz2 - lz1).length();
        if (0.0 == segment_length) {
            return 0.0;
        }
        Vector3d cross = new Vector3d();
        cross.cross(new Vector3d(px - lx1, py - ly1, pz - lz1), new Vector3d(px - lx2, py - ly2, pz - lz2));
        return cross.length() / segment_length;
    }

    public class GrowBlob
    extends InteractiveBehavior {
        private ResultsTable rt;
        private LevelSet levelsets;
        private Image3DUniverse univ;
        private Thread thread;

        public GrowBlob(Image3DUniverse univ) {
            super(univ);
            this.rt = null;
            this.levelsets = new LevelSet();
            this.thread = null;
            this.univ = univ;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doProcess(final MouseEvent me) {
            if (me.getID() != 501) {
                return;
            }
            GrowBlob growBlob = this;
            synchronized (growBlob) {
                if (null != this.thread) {
                    IJ.showMessage((String)"A blob segmentation is currently running.\nWait until it finishes, or push ESC to cancel it.");
                    return;
                }
            }
            if (me.isConsumed() || Toolbar.getToolId() != 8) {
                return;
            }
            me.consume();
            growBlob = this;
            synchronized (growBlob) {
                this.thread = new Thread(){
                    {
                        this.setPriority(5);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (me.isShiftDown()) {
                                GrowBlob.this.levelsets.showDialog();
                                return;
                            }
                            Object blob = GrowBlob.this.segment(me.getX(), me.getY());
                            if (null == blob) {
                                return;
                            }
                            blob.show();
                            double[] m = blob.measure();
                            String name = blob.c.getName();
                            if (null == GrowBlob.this.rt || null == WindowManager.getFrame((String)name)) {
                                GrowBlob.this.rt = new ResultsTable();
                                GrowBlob.this.rt.setHeading(0, "Volume");
                                GrowBlob.this.rt.setHeading(1, "Surface");
                                GrowBlob.this.rt.setHeading(2, "X-center");
                                GrowBlob.this.rt.setHeading(3, "Y-center");
                                GrowBlob.this.rt.setHeading(4, "Z-center");
                            }
                            GrowBlob.this.rt.incrementCounter();
                            GrowBlob.this.rt.addLabel("units", blob.seg.getCalibration().getUnits());
                            for (int i = 0; i < m.length; ++i) {
                                GrowBlob.this.rt.addValue(i, m[i]);
                            }
                            GrowBlob.this.rt.show(name);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            IJ.handleException((Throwable)e);
                        }
                        finally {
                            GrowBlob growBlob = GrowBlob.this;
                            synchronized (growBlob) {
                                GrowBlob.this.thread = null;
                            }
                        }
                    }
                };
                this.thread.start();
            }
        }

        public Blob segment(int mouse_x, int mouse_y) {
            ImagePlus imagePlus;
            Picker picker = this.univ.getPicker();
            Content c = picker.getPickedContent(mouse_x, mouse_y);
            if (null == c) {
                return null;
            }
            ImagePlus imp = c.getImage();
            if (null == imp) {
                IJ.log((String)"Cannot segment non-image object!");
                return null;
            }
            float p = 1.0f;
            Point3d point = null;
            float transp = c.getTransparency();
            float max_value = -3.4028235E38f;
            List<Map.Entry<Point3d, Float>> column = picker.getPickPointColumn(c, mouse_x, mouse_y);
            float[] vals = new float[column.size()];
            float[] w = new float[column.size()];
            float[] indices = new float[column.size()];
            int index = 0;
            int next = 0;
            for (Map.Entry<Point3d, Float> entry : column) {
                float f = entry.getValue().floatValue() / 255.0f;
                float alpha = (1.0f - transp) * f;
                float beta = alpha * p;
                p *= 1.0f - alpha;
                float weighted_value = beta * f;
                if (weighted_value > max_value) {
                    max_value = weighted_value;
                    point = entry.getKey();
                    index = next;
                }
                vals[next] = f;
                w[next] = weighted_value;
                indices[next] = next;
                ++next;
            }
            float max = column.get(index).getValue().floatValue();
            for (Map.Entry<Point3d, Float> entry : column.subList(index + 1, column.size())) {
                if (entry.getValue().floatValue() > max) {
                    max = entry.getValue().floatValue();
                    ++index;
                    continue;
                }
                point = column.get(index).getKey();
                break;
            }
            if (debug) {
                Plot plot = new Plot("ray", "depth", "amount", indices, vals);
                plot.setColor(Color.red);
                plot.addPoints(indices, w, 6);
                plot.show();
            }
            Calibration calibration = imp.getCalibration();
            imp = new Duplicator().run(imp);
            imp.setSlice(1 + (int)(point.z / calibration.pixelDepth));
            imp.setRoi((Roi)new PointRoi((int)(point.x / calibration.pixelWidth), (int)(point.y / calibration.pixelHeight)));
            if (debug) {
                imp.show();
            }
            if (null == (imagePlus = this.levelsets.execute(imp, false))) {
                IJ.log((String)"3D Blob segmentation failed!\nPlease click on a brigther voxel.");
                return null;
            }
            imagePlus.setCalibration(imp.getCalibration());
            if (debug) {
                imagePlus.show();
            }
            if (null == imagePlus) {
                IJ.log((String)"3D Blob segmentation failed!");
                return null;
            }
            for (int i = imagePlus.getNSlices(); i > 0; --i) {
                imagePlus.getStack().getProcessor(i).invert();
            }
            return new Blob(c, point, imagePlus);
        }

        public final class Blob {
            Content c;
            Point3d point;
            ImagePlus seg;
            List<Point3f> triangles;

            Blob(Content c, Point3d point, ImagePlus seg) {
                this.c = c;
                this.point = point;
                this.seg = seg;
            }

            public List<Point3f> show() {
                String title = this.c.getName() + "--" + this.point;
                int num = 1;
                while (GrowBlob.this.univ.contains(title)) {
                    title = this.c.getName() + "--" + this.point + "-" + num;
                    ++num;
                }
                List triangles = new MCTriangulator().getTriangles(this.seg, 1, new boolean[]{true, true, true}, this.c.getResamplingFactor());
                this.c.setLocked(true);
                Content mesh = GrowBlob.this.univ.createContent(new CustomTriangleMesh(triangles, new Color3f(0.0f, 1.0f, 0.0f), 0.0f), title);
                mesh.setLocked(true);
                GrowBlob.this.univ.addContentLater(mesh);
                this.triangles = triangles;
                return triangles;
            }

            public double[] measure() {
                if (0 != this.seg.getType()) {
                    return null;
                }
                byte[][] pix = new byte[this.seg.getNSlices()][];
                if (1 == this.seg.getNSlices()) {
                    pix[0] = (byte[])this.seg.getProcessor().getPixels();
                } else {
                    Object[] ob = this.seg.getStack().getImageArray();
                    for (int i = 0; i < pix.length; ++i) {
                        pix[i] = (byte[])ob[i];
                    }
                }
                int w = this.seg.getWidth();
                int h = this.seg.getHeight();
                int X = 0;
                int Y = 0;
                int Z = 0;
                int N = 0;
                for (int z = 0; z < pix.length; ++z) {
                    byte[] pixels = pix[z];
                    for (int y = 0; y < h; ++y) {
                        int offset = y * w;
                        for (int x = 0; x < w; ++x) {
                            byte val = pixels[offset + x];
                            if (0 == val) continue;
                            ++N;
                            X += x;
                            Y += y;
                            Z += z;
                        }
                    }
                }
                Calibration cal = this.seg.getCalibration();
                return new double[]{(double)N * cal.pixelWidth * cal.pixelHeight * cal.pixelDepth, Blob_Segmentation_in_3D.measureSurface(this.triangles), (double)X * cal.pixelWidth, (double)Y * cal.pixelHeight, (double)Z * cal.pixelDepth};
            }
        }
    }
}

