/*
 * Decompiled with CFR 0.152.
 */
package mmorpho;

import ij.IJ;
import java.util.StringTokenizer;
import mmorpho.Constants;

public class StructureElement
implements Constants {
    private int[] mask;
    private int width = 1;
    private int height = 1;
    private double radius = 0.0;
    private int[][] vect;
    private int[] offset = OFFSET0;
    private int shift = 1;
    public int type = -1;
    public boolean offsetmodified = false;
    static final String EOL = System.getProperty("line.separator");

    public StructureElement(int[] amask, int width) {
        this.width = width;
        this.height = amask.length / width;
        this.shift = 0;
        this.setMask(amask);
        this.vect = this.calcVect(this.mask, width);
    }

    public StructureElement(String tokenString) {
        this.shift = 0;
        this.type = -1;
        this.mask = this.inputMask(tokenString);
        this.vect = this.calcVect(this.mask, this.width);
    }

    public StructureElement(int type, int shift, float radius, int[] offset) {
        int r = 0;
        this.shift = shift;
        this.radius = radius;
        if ((float)(offset[0] * offset[0] + offset[1] * offset[1]) >= radius / 2.0f) {
            offset = OFFSET0;
        }
        this.offset = offset;
        this.type = type;
        switch (type) {
            case 0: {
                this.mask = this.createCircularMask(shift, radius, offset);
                break;
            }
            case 1: {
                this.mask = this.createDiamondMask(shift, radius, offset);
                break;
            }
            case 7: {
                this.mask = this.createSquareMask(shift, 2.0f * radius, offset);
                break;
            }
            case 4: {
                this.shift = 1;
                this.mask = this.createLineMask(shift, 2.0f * radius, 0.0, offset);
                break;
            }
            case 3: {
                this.shift = 1;
                this.mask = this.createLineMask(shift, 2.0f * radius, 1.5707963267948966, offset);
                break;
            }
            case 6: {
                r = (int)radius;
                this.width = r + 2;
                this.height = 1;
                this.mask = new int[this.width];
                this.mask[1] = 255;
                this.mask[this.width - 1] = 255;
                break;
            }
            case 5: {
                r = (int)radius;
                this.height = r + 2;
                this.width = 1;
                this.mask = new int[this.height];
                this.mask[1] = 255;
                this.mask[this.height - 1] = 255;
                break;
            }
        }
        this.vect = this.calcVect(this.mask, this.width);
    }

    private int[] createCircularMask(int shift, double radius, int[] offset) {
        this.height = this.width = (int)(radius + (double)shift + 0.5) * 2 + 1;
        int[] mask = new int[this.width * this.width];
        double r = (double)this.width / 2.0 - 0.5;
        double r2 = radius * radius + 1.0;
        int index = 0;
        for (double x = -r; x <= r; x += 1.0) {
            for (double y = -r; y <= r; y += 1.0) {
                if ((x - (double)offset[0]) * (x - (double)offset[0]) + (y - (double)offset[1]) * (y - (double)offset[1]) < r2) {
                    mask[index] = 255;
                }
                ++index;
            }
        }
        return mask;
    }

    private int[] createDiamondMask(int shift, double radius, int[] offset) {
        this.height = this.width = (int)(radius + (double)shift + 0.5) * 2 + 1;
        int[] mask = new int[this.width * this.width];
        int r = this.width / 2;
        for (int x = -r; x <= r; ++x) {
            for (int y = -r; y <= r; ++y) {
                if (!((double)(Math.abs(x - offset[0]) + Math.abs(y - offset[1])) <= radius)) continue;
                mask[r + x + (r + y) * this.width] = 255;
            }
        }
        return mask;
    }

    private int[] createSquareMask(int shift, double radius, int[] offset) {
        if (radius == 0.0) {
            radius = 0.5;
        }
        int c = 0;
        this.height = this.width = (int)(2.0 * radius + (double)(2 * shift));
        int sz = this.width * this.height;
        int[] mask = new int[sz];
        for (int counter = 0; counter < sz; ++counter) {
            int r = counter / this.width;
            c = counter % this.width;
            if (r <= shift && r >= this.height - shift && c <= shift && c >= this.width - shift) continue;
            mask[counter] = 255;
        }
        return mask;
    }

    private int[] createLineMask(int shift, double l, double alpha, int[] offset) {
        int r = (int)(l / 2.0 - 1.0);
        if (StructureElement.validate((float)(alpha / Math.PI), 1)) {
            alpha = 0.0;
        }
        this.width = (int)((l + (double)(2 * shift)) * Math.cos(alpha));
        this.height = (int)((l + (double)(2 * shift)) * Math.sin(alpha));
        if (this.width == 0) {
            ++this.width;
        }
        if (this.height == 0) {
            ++this.height;
        }
        int sz = this.width * this.height;
        int[] mask = new int[sz];
        if (alpha == 0.0 || alpha == Math.PI) {
            for (int j = shift; j < this.width - shift; ++j) {
                mask[j] = 255;
            }
        } else if (alpha == 1.5707963267948966) {
            for (int i = shift; i < this.height - shift; ++i) {
                mask[i] = 255;
            }
        } else {
            for (int x = r - shift; x <= r - shift; ++x) {
                for (int y = r - shift; y <= r - shift; ++y) {
                    if (Math.abs(alpha) < 1.5707963267948966) {
                        if ((double)y - Math.tan(alpha) * (double)x != 0.0) continue;
                        mask[r + x - offset[0] + (r + y - offset[1]) * this.width] = 255;
                        continue;
                    }
                    if (Math.tan(1.5707963267948966 - alpha) * (double)y - (double)x != 0.0) continue;
                    mask[r + x - offset[0] + (r + y - offset[1]) * this.width] = 255;
                }
            }
        }
        return mask;
    }

    private int[] inputMask(String tokenString) {
        int kw;
        StringTokenizer st = new StringTokenizer(tokenString);
        int n = st.countTokens();
        int kh = kw = (int)Math.sqrt(n);
        int sz = kw * kh;
        int[] k = new int[sz];
        for (int i = 0; i < sz; ++i) {
            k[i] = (int)this.getNum(st);
        }
        this.height = this.width = kw;
        return k;
    }

    public int[] getMask() {
        return this.mask;
    }

    public int getMaskAt(int index) {
        if (index <= this.mask.length) {
            return this.mask[index];
        }
        return -1;
    }

    public int getMaskAt(int x, int y) {
        if (x <= 0) {
            x = 0;
        }
        if (x > this.height) {
            x = this.height;
        }
        if (y <= 0) {
            y = 0;
        }
        if (y >= this.width) {
            y = this.width - 1;
        }
        int index = x + this.width * y;
        return this.mask[index];
    }

    public void setMask(int[] amask) {
        this.mask = amask;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getShift() {
        return this.shift;
    }

    public double getR() {
        return this.radius;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int[] getOffset() {
        return this.offset;
    }

    public void setOffset(int[] offset) {
        this.offset = offset;
        this.offsetmodified = true;
    }

    double getNum(StringTokenizer st) {
        Double d;
        String token = st.nextToken();
        try {
            d = new Double(token);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    private static boolean validate(float var, int k) {
        float a = (float)k * var;
        int b = (int)((float)k * var);
        return a - (float)b == 0.0f || var < 0.0f;
    }

    public int[] T(int[] h) {
        int[] strel = new int[this.mask.length];
        for (int i = 0; i < this.height - 1; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int m = i + h[0];
                int n = j + h[1];
                if (m < 0) {
                    m = 0;
                }
                if (n < 0) {
                    n = 0;
                }
                if (n > this.width) {
                    n = this.width;
                }
                if (m > this.width - 1) {
                    m = this.width - 1;
                }
                int index = n + this.width * m;
                int ind = j + this.width * i;
                try {
                    strel[ind] = this.mask[index];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    IJ.log((String)("mask: " + this.mask.length));
                    IJ.log((String)("index2: " + index));
                    IJ.log((String)("index1: " + ind));
                }
            }
        }
        return strel;
    }

    public StructureElement Tr(int[] h) {
        return new StructureElement(this.T(h), this.width);
    }

    public int[] Delta(int[] offset) {
        int[] astrel = this.T(offset);
        for (int index = 0; index < this.mask.length; ++index) {
            astrel[index] = this.mask[index] - astrel[index];
        }
        return astrel;
    }

    public int[] H(int[] strel, int sign) {
        for (int i = 0; i < strel.length; ++i) {
            strel[i] = strel[i] * sign >= 0 ? 0 : 255;
        }
        return strel;
    }

    public int getArea() {
        int maskSize = 0;
        for (int i = 0; i < this.mask.length; ++i) {
            if (this.mask[i] == 0) continue;
            ++maskSize;
        }
        return maskSize;
    }

    public int[] getBorder() {
        int sz = this.mask.length;
        int[] perim = new int[sz];
        int n = -1;
        int j = 0;
        for (int c = 0; c < sz; ++c) {
            int i = c / this.width;
            j = c % this.width;
            int k = j + 1 > this.width - 1 ? 0 : this.mask[i * this.width + j + 1];
            int l = i + 1 > this.height - 1 ? 0 : this.mask[(i + 1) * this.width + j];
            int m = j == 0 ? 0 : this.mask[i * this.width + j - 1];
            n = i == 0 ? 0 : this.mask[(i - 1) * this.width + j];
            if (this.mask[c] <= k && this.mask[c] <= m && this.mask[c] <= l && this.mask[c] <= n) continue;
            perim[c] = this.mask[c];
        }
        return perim;
    }

    private int[][] calcVect(int[] perim, int w) {
        int N = 0;
        int sz = perim.length;
        for (int i = 0; i < perim.length; ++i) {
            if (perim[i] <= 0) continue;
            ++N;
        }
        int h = sz / w;
        int p = (int)Math.floor(h / 2);
        int q = (int)Math.floor(w / 2);
        int[][] pg = new int[N][4];
        int counter = 0;
        for (int c = 0; c < sz; ++c) {
            int i = c / w;
            int j = c % w;
            if (perim[c] <= 0) continue;
            pg[counter][0] = i - p;
            pg[counter][1] = j - q;
            pg[counter][2] = perim[c];
            int[] a = new int[]{pg[counter][1], pg[counter][0]};
            double d = this.getDistance(a, this.type);
            pg[counter][3] = (int)Math.round(d);
            ++counter;
        }
        return pg;
    }

    public double getDistance(int[] X, int metrics) {
        double d = 0.0;
        double g = 0.0;
        switch (metrics) {
            case 0: {
                g = X[0] * X[0] + X[1] * X[1];
                d = Math.sqrt(g + 1.0) + cor3;
                break;
            }
            case 1: {
                d = Math.abs(X[0]) + Math.abs(X[1]);
                break;
            }
            case 7: {
                d = Math.max(Math.abs(X[0]), Math.abs(X[1]));
                break;
            }
            default: {
                d = Math.sqrt(X[0] * X[0] + X[1] * X[1]);
            }
        }
        return d;
    }

    public int[][] VectTransform(int opt) {
        if (opt == -16) {
            return this.calcVect(this.getBorder(), this.width);
        }
        return this.calcVect(this.mask, this.width);
    }

    public int[][] getVect() {
        return this.vect;
    }
}

