/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.nls;

import java.io.IOException;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.matrix.DoubleMatrixBuilder;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;
import org.renjin.stats.nls.NlsControl;
import org.renjin.stats.nls.NlsModel;

public class NonlinearLeastSquares {
    @Internal
    public static SEXP iterate(@Current Context context, ListVector modelExpression, ListVector controlExpression, boolean doTrace) throws IOException {
        int iterationNumber;
        NlsModel model = new NlsModel(context, modelExpression);
        NlsControl control = new NlsControl(controlExpression);
        AtomicVector parameters = model.getParameterValues();
        int numParameters = parameters.length();
        double dev = model.calculateDeviation();
        if (doTrace) {
            model.trace();
        }
        double factor = 1.0;
        boolean hasConverged = false;
        double[] newParameters = new double[numParameters];
        int totalEvaluationCount = 1;
        double newConvergence = Double.POSITIVE_INFINITY;
        for (iterationNumber = 0; iterationNumber < control.getMaxIterations(); ++iterationNumber) {
            int evaluationCount = -1;
            newConvergence = model.getConvergence();
            if (newConvergence < control.getTolerance()) {
                hasConverged = true;
                break;
            }
            DoubleVector newIncrement = model.calculateIncrements();
            evaluationCount = 1;
            while (factor >= control.getMinFactor()) {
                if (control.isPrintEval()) {
                    context.getSession().getStdOut().printf("  It. %3d, fac= %11.6f, eval (no.,total): (%2d,%3d):\n", iterationNumber + 1, factor, evaluationCount, totalEvaluationCount);
                    ++evaluationCount;
                    ++totalEvaluationCount;
                }
                for (int j = 0; j < numParameters; ++j) {
                    newParameters[j] = parameters.getElementAsDouble(j) + factor * newIncrement.getElementAsDouble(j);
                }
                if (model.updateParameters(newParameters)) {
                    return NonlinearLeastSquares.convergenceResult(control, "singular gradient", iterationNumber, StopReason.SINGULAR_GRADIENT, newConvergence);
                }
                double newDev = model.calculateDeviation();
                if (control.isPrintEval()) {
                    context.getSession().getStdOut().printf(" new dev = %f\n", newDev);
                }
                if (newDev <= dev) {
                    dev = newDev;
                    factor = Math.min(2.0 * factor, 1.0);
                    parameters = new DoubleArrayVector(newParameters);
                    break;
                }
                factor /= 2.0;
            }
            if (factor < control.getMinFactor()) {
                return NonlinearLeastSquares.convergenceResult(control, String.format("step factor %f reduced below 'minFactor' of %f", factor, control.getMinFactor()), iterationNumber, StopReason.MIN_FACTOR_REACHED, newConvergence);
            }
            if (!doTrace) continue;
            model.trace();
        }
        if (!hasConverged) {
            return NonlinearLeastSquares.convergenceResult(control, String.format("number of iterations exceeded maximum of %d", control.getMaxIterations()), iterationNumber, StopReason.MAX_ITERATIONS_EXCEEDED, newConvergence);
        }
        return NonlinearLeastSquares.convergenceResult(control, "converged", iterationNumber, StopReason.CONVERGED, newConvergence);
    }

    private static SEXP convergenceResult(NlsControl control, String msg, int iterationNumber, StopReason stopReason, double newConvergence) {
        if (!control.isWarnOnly() && stopReason != StopReason.CONVERGED) {
            throw new EvalException(msg, new Object[0]);
        }
        ListVector.NamedBuilder result = ListVector.newNamedBuilder();
        result.add("isConv", stopReason == StopReason.CONVERGED);
        result.add("finIter", iterationNumber);
        result.add("finTol", newConvergence);
        result.add("stopCode", stopReason.ordinal());
        result.add("stopMessage", msg);
        return result.build();
    }

    public static SEXP numericDerivative(@Current Context context, SEXP modelExpr, StringVector theta, Environment rho, DoubleVector dir) {
        if (dir.length() != theta.length()) {
            throw new EvalException("'dir' is not a numeric vector of the correct length", new Object[0]);
        }
        SEXP responseExpr = context.evaluate(modelExpr, rho);
        if (!(responseExpr instanceof Vector)) {
            throw new EvalException("Expected numeric response from model", new Object[0]);
        }
        Vector response = (Vector)responseExpr;
        for (int i = 0; i != response.length(); ++i) {
            if (DoubleVector.isFinite((double)response.getElementAsDouble(i))) continue;
            throw new EvalException("Missing value or an infinity produced when evaluating the model", new Object[0]);
        }
        double[][] parameterValues = new double[theta.length()][];
        int totalParameterValueCount = 0;
        for (int i = 0; i < theta.length(); ++i) {
            String parameterName = theta.getElementAsString(i);
            SEXP parameterValue = rho.findVariable(Symbol.get((String)parameterName));
            if (!(parameterValue instanceof AtomicVector)) {
                throw new EvalException("variable '%s' is not numeric", new Object[]{parameterName});
            }
            parameterValues[i] = ((AtomicVector)parameterValue).toDoubleArray();
            totalParameterValueCount += parameterValues[i].length;
        }
        double eps = Math.sqrt(2.220446E-16);
        DoubleMatrixBuilder gradient = new DoubleMatrixBuilder(response.length(), totalParameterValueCount);
        int gradientColumn = 0;
        for (int parameterIndex = 0; parameterIndex < theta.length(); ++parameterIndex) {
            double direction = dir.getElementAsDouble(parameterIndex);
            for (int parameterValueIndex = 0; parameterValueIndex < parameterValues[parameterIndex].length; ++parameterValueIndex) {
                double startingParameterValue = parameterValues[parameterIndex][parameterValueIndex];
                double absoluteParameterValue = Math.abs(startingParameterValue);
                double delta = absoluteParameterValue == 0.0 ? eps : absoluteParameterValue * eps;
                double[] dArray = parameterValues[parameterIndex];
                int n = parameterValueIndex;
                dArray[n] = dArray[n] + direction * delta;
                rho.setVariable(theta.getElementAsString(parameterIndex), (SEXP)new DoubleArrayVector(parameterValues[parameterIndex]));
                DoubleVector responseDelta = (DoubleVector)context.evaluate(modelExpr, rho);
                for (int k = 0; k < response.length(); ++k) {
                    if (!DoubleVector.isFinite((double)responseDelta.getElementAsDouble(k))) {
                        throw new EvalException("Missing value or an infinity produced when evaluating the model", new Object[0]);
                    }
                    double difference = responseDelta.getElementAsDouble(k) - response.getElementAsDouble(k);
                    double relativeDifference = difference / delta;
                    gradient.set(k, gradientColumn, direction * relativeDifference);
                }
                parameterValues[parameterIndex][parameterValueIndex] = startingParameterValue;
                ++gradientColumn;
            }
            rho.setVariable(theta.getElementAsString(parameterIndex), (SEXP)new DoubleArrayVector(parameterValues[parameterIndex]));
        }
        return response.setAttribute(Symbol.get((String)"gradient"), (SEXP)gradient.build());
    }

    private static enum StopReason {
        CONVERGED,
        SINGULAR_GRADIENT,
        MIN_FACTOR_REACHED,
        MAX_ITERATIONS_EXCEEDED;

    }
}

