/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.imagej.updater.FileObject;
import net.imagej.updater.XMLFileErrorHandler;
import net.imagej.updater.util.UpdaterUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class POMParser
extends DefaultHandler {
    private FileObject file;
    private String body;
    private String prefix;

    public POMParser(FileObject file) {
        this.file = file;
    }

    public static void fillMetadataFromJar(FileObject object, File file) throws ParserConfigurationException, IOException, SAXException {
        JarFile jar = new JarFile(file);
        for (JarEntry entry : UpdaterUtil.iterate(jar.entries())) {
            if (!entry.getName().matches("META-INF/maven/.*/pom.xml")) continue;
            new POMParser(object).read(jar.getInputStream(entry));
            break;
        }
        jar.close();
    }

    public void read(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        InputSource inputSource = new InputSource(in);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        XMLReader xr = parser.getXMLReader();
        xr.setContentHandler(this);
        xr.setErrorHandler(new XMLFileErrorHandler());
        xr.parse(inputSource);
    }

    @Override
    public void startDocument() {
        this.body = "";
        this.prefix = "";
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        this.prefix = this.prefix + ">" + qName;
        this.body = "";
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.prefix.equals(">project>description")) {
            if (!"".equals(this.body)) {
                this.file.description = this.body;
                this.file.descriptionFromPOM = true;
            }
        } else if (this.prefix.equals(">project>developers>developer>name")) {
            this.file.addAuthor(this.body);
        }
        this.prefix = this.prefix.substring(0, this.prefix.length() - 1 - qName.length());
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.body = this.body + new String(ch, start, length);
    }
}

