/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import java.util.Iterator;

public class ByteCodeAnalyzer
implements Iterable<String> {
    private byte[] buffer;
    private int[] poolOffsets;
    private int endOffset;
    private int interfacesOffset;
    private int fieldsOffset;
    private int methodsOffset;
    private int attributesOffset;
    private Interface[] interfaces;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;

    public ByteCodeAnalyzer(byte[] buffer) {
        this(buffer, false);
    }

    public ByteCodeAnalyzer(byte[] buffer, boolean readAll) {
        this(buffer, readAll ? Mode.ALL : Mode.CONSTANTS);
    }

    public ByteCodeAnalyzer(byte[] buffer, Mode mode) {
        this.buffer = buffer;
        if ((int)this.getU4(0) != -889275714) {
            throw new RuntimeException("No class");
        }
        this.getConstantPoolOffsets();
        if (mode.ordinal() >= Mode.INTERFACES.ordinal()) {
            this.getAllInterfaces();
        }
        if (mode.ordinal() >= Mode.FIELDS.ordinal()) {
            this.getAllFields();
        }
        if (mode.ordinal() >= Mode.METHODS.ordinal()) {
            this.getAllMethods();
        }
        if (mode.ordinal() >= Mode.ALL.ordinal()) {
            this.getAllAttributes();
        }
    }

    public String getPathForClass() {
        int thisOffset = this.dereferenceOffset(this.endOffset + 2);
        if (this.getU1(thisOffset) != 7) {
            throw new RuntimeException("Parse error");
        }
        return this.getString(this.dereferenceOffset(thisOffset + 1));
    }

    public String getClassNameConstant(int index) {
        int offset = this.poolOffsets[index - 1];
        if (this.getU1(offset) != 7) {
            throw new RuntimeException("Constant " + index + " does not refer to a class");
        }
        return this.getStringConstant(this.getU2(offset + 1)).replace('/', '.');
    }

    public String getStringConstant(int index) {
        return this.getString(this.poolOffsets[index - 1]);
    }

    public boolean containsDebugInfo() {
        for (Method method : this.methods) {
            if (!method.containsDebugInfo()) continue;
            return true;
        }
        return false;
    }

    int dereferenceOffset(int offset) {
        int index = this.getU2(offset);
        return this.poolOffsets[index - 1];
    }

    void getConstantPoolOffsets() {
        int poolCount = this.getU2(8) - 1;
        this.poolOffsets = new int[poolCount];
        int offset = 10;
        for (int i = 0; i < poolCount; ++i) {
            this.poolOffsets[i] = offset;
            int tag = this.getU1(offset);
            if (tag == 7 || tag == 8 || tag == 16) {
                offset += 3;
                continue;
            }
            if (tag == 15) {
                offset += 4;
                continue;
            }
            if (tag == 9 || tag == 10 || tag == 11 || tag == 3 || tag == 4 || tag == 12 || tag == 18) {
                offset += 5;
                continue;
            }
            if (tag == 5 || tag == 6) {
                this.poolOffsets[++i] = offset;
                offset += 9;
                continue;
            }
            if (tag == 1) {
                offset += 3 + this.getU2(offset + 1);
                continue;
            }
            throw new RuntimeException("Unknown tag " + tag);
        }
        this.endOffset = offset;
    }

    @Override
    public Iterator<String> iterator() {
        return new ClassNameIterator();
    }

    public Iterable<String> getInterfaces() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new InterfaceIterator();
            }
        };
    }

    public String getSuperclass() {
        int index = this.getU2(this.endOffset + 4);
        if (index == 0) {
            return null;
        }
        return this.getClassNameConstant(index);
    }

    public String getSourceFile() {
        for (Attribute attribute : this.attributes) {
            if (!this.getStringConstant(attribute.nameIndex).equals("SourceFile")) continue;
            return this.getStringConstant(this.getU2(attribute.attributeEndOffset - 2));
        }
        return null;
    }

    public String toString() {
        int i;
        String result = "";
        for (i = 0; i < this.poolOffsets.length; ++i) {
            int offset = this.poolOffsets[i];
            result = result + "index #" + (i + 1) + ": " + this.format(offset) + "\n";
            int tag = this.getU1(offset);
            if (tag != 5 && tag != 6) continue;
            ++i;
        }
        if (this.interfaces != null) {
            for (i = 0; i < this.interfaces.length; ++i) {
                result = result + "interface #" + (i + 1) + ": " + this.interfaces[i] + "\n";
            }
        }
        if (this.fields != null) {
            for (i = 0; i < this.fields.length; ++i) {
                result = result + "field #" + (i + 1) + ": " + this.fields[i] + "\n";
            }
        }
        if (this.methods != null) {
            for (i = 0; i < this.methods.length; ++i) {
                result = result + "method #" + (i + 1) + ": " + this.methods[i] + "\n";
            }
        }
        if (this.attributes != null) {
            for (i = 0; i < this.attributes.length; ++i) {
                result = result + "attribute #" + (i + 1) + ": " + this.attributes[i] + "\n";
            }
        }
        return result;
    }

    int getU1(int offset) {
        return this.buffer[offset] & 0xFF;
    }

    int getU2(int offset) {
        return this.getU1(offset) << 8 | this.getU1(offset + 1);
    }

    long getU4(int offset) {
        return (long)this.getU2(offset) << 16 | (long)this.getU2(offset + 2);
    }

    String getString(int offset) {
        try {
            return new String(this.buffer, offset + 3, this.getU2(offset + 1), "UTF-8");
        }
        catch (Exception e) {
            return "";
        }
    }

    String format(int offset) {
        int tag = this.getU1(offset);
        int u2 = this.getU2(offset + 1);
        String result = "offset: " + offset + "(" + tag + "), ";
        if (tag == 7) {
            return result + "class #" + u2;
        }
        if (tag == 9) {
            return result + "field #" + u2 + ", #" + this.getU2(offset + 3);
        }
        if (tag == 10) {
            return result + "method #" + u2 + ", #" + this.getU2(offset + 3);
        }
        if (tag == 11) {
            return result + "interface method #" + u2 + ", #" + this.getU2(offset + 3);
        }
        if (tag == 8) {
            return result + "string #" + u2;
        }
        if (tag == 3) {
            return result + "integer " + this.getU4(offset + 1);
        }
        if (tag == 4) {
            return result + "float " + this.getU4(offset + 1);
        }
        if (tag == 12) {
            return result + "name and type #" + u2 + ", #" + this.getU2(offset + 3);
        }
        if (tag == 5) {
            return result + "long " + this.getU4(offset + 1) + ", " + this.getU4(offset + 5);
        }
        if (tag == 6) {
            return result + "double " + this.getU4(offset + 1) + ", " + this.getU4(offset + 5);
        }
        if (tag == 1) {
            return result + "utf8 " + u2 + " " + this.getString(offset);
        }
        return result + "unknown";
    }

    protected void getAllInterfaces() {
        this.interfacesOffset = this.endOffset + 6;
        this.interfaces = new Interface[this.getU2(this.interfacesOffset)];
        for (int i = 0; i < this.interfaces.length; ++i) {
            this.interfaces[i] = new Interface(this.interfacesOffset + 2 + i * 2);
        }
    }

    protected void getAllFields() {
        this.fieldsOffset = this.interfacesOffset + 2 + 2 * this.interfaces.length;
        this.fields = new Field[this.getU2(this.fieldsOffset)];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = new Field(i == 0 ? this.fieldsOffset + 2 : this.fields[i - 1].fieldEndOffset);
        }
    }

    protected void getAllMethods() {
        this.methodsOffset = this.fields.length == 0 ? this.fieldsOffset + 2 : this.fields[this.fields.length - 1].fieldEndOffset;
        this.methods = new Method[this.getU2(this.methodsOffset)];
        for (int i = 0; i < this.methods.length; ++i) {
            this.methods[i] = new Method(i == 0 ? this.methodsOffset + 2 : this.methods[i - 1].fieldEndOffset);
        }
    }

    protected void getAllAttributes() {
        this.attributesOffset = this.methods.length == 0 ? this.methodsOffset + 2 : this.methods[this.methods.length - 1].fieldEndOffset;
        this.attributes = this.getAttributes(this.attributesOffset);
    }

    protected Attribute[] getAttributes(int offset) {
        Attribute[] result = new Attribute[this.getU2(offset)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Attribute(i == 0 ? offset + 2 : result[i - 1].attributeEndOffset);
        }
        return result;
    }

    protected String toString(Attribute[] attributes) {
        String result = "";
        for (Attribute attribute : attributes) {
            result = result + (result.equals("") ? "(" : ";") + attribute;
        }
        return result.equals("") ? "" : result + ")";
    }

    protected class Attribute {
        int nameIndex;
        byte[] attribute;
        int attributeEndOffset;

        public Attribute(int offset) {
            this.nameIndex = ByteCodeAnalyzer.this.getU2(offset);
            this.attribute = new byte[(int)ByteCodeAnalyzer.this.getU4(offset + 2)];
            System.arraycopy(ByteCodeAnalyzer.this.buffer, offset + 6, this.attribute, 0, this.attribute.length);
            this.attributeEndOffset = offset + 6 + this.attribute.length;
        }

        public boolean containsDebugInfo() {
            if (!ByteCodeAnalyzer.this.getStringConstant(this.nameIndex).equals("Code")) {
                return false;
            }
            for (Attribute attribute : this.getAttributes()) {
                if (!ByteCodeAnalyzer.this.getStringConstant(attribute.nameIndex).equals("LocalVariableTable")) continue;
                return true;
            }
            return false;
        }

        protected Attribute[] getAttributes() {
            int offset = this.attributeEndOffset - 6 - this.attribute.length;
            int codeLength = (int)ByteCodeAnalyzer.this.getU4(offset + 10);
            int exceptionTableLength = ByteCodeAnalyzer.this.getU2(offset + 14 + codeLength);
            int attributesOffset = offset + 14 + codeLength + 2 + 8 * exceptionTableLength;
            return ByteCodeAnalyzer.this.getAttributes(attributesOffset);
        }

        public String toString() {
            if (ByteCodeAnalyzer.this.getStringConstant(this.nameIndex).equals("Code")) {
                return "Code" + ByteCodeAnalyzer.this.toString(this.getAttributes());
            }
            return ByteCodeAnalyzer.this.getStringConstant(this.nameIndex) + " (length " + this.attribute.length + ")";
        }
    }

    protected class Method
    extends Field {
        public Method(int offset) {
            super(offset);
        }

        public boolean containsDebugInfo() {
            for (Attribute attribute : this.fieldAttributes) {
                if (!attribute.containsDebugInfo()) continue;
                return true;
            }
            return false;
        }
    }

    protected class Field {
        int accessFlags;
        int nameIndex;
        int descriptorIndex;
        Attribute[] fieldAttributes;
        int fieldEndOffset;

        public Field(int offset) {
            this.accessFlags = ByteCodeAnalyzer.this.getU2(offset);
            this.nameIndex = ByteCodeAnalyzer.this.getU2(offset + 2);
            this.descriptorIndex = ByteCodeAnalyzer.this.getU2(offset + 4);
            this.fieldAttributes = ByteCodeAnalyzer.this.getAttributes(offset + 6);
            this.fieldEndOffset = this.fieldAttributes.length == 0 ? offset + 8 : this.fieldAttributes[this.fieldAttributes.length - 1].attributeEndOffset;
        }

        public String toString() {
            return ByteCodeAnalyzer.this.getStringConstant(this.nameIndex) + ByteCodeAnalyzer.this.toString(this.fieldAttributes);
        }
    }

    protected class Interface {
        int nameIndex;

        public Interface(int offset) {
            this.nameIndex = ByteCodeAnalyzer.this.getU2(offset);
        }

        public String toString() {
            return ByteCodeAnalyzer.this.getClassNameConstant(this.nameIndex);
        }
    }

    class InterfaceIterator
    implements Iterator<String> {
        int index = 0;
        int count;

        InterfaceIterator() {
            this.count = ByteCodeAnalyzer.this.getU2(ByteCodeAnalyzer.this.endOffset + 6);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        @Override
        public String next() {
            return ByteCodeAnalyzer.this.getClassNameConstant(ByteCodeAnalyzer.this.getU2(ByteCodeAnalyzer.this.endOffset + 8 + this.index++ * 2));
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    class ClassNameIterator
    implements Iterator<String> {
        int index = 0;

        ClassNameIterator() {
            this.findNext();
        }

        void findNext() {
            while (++this.index <= ByteCodeAnalyzer.this.poolOffsets.length && ByteCodeAnalyzer.this.getU1(ByteCodeAnalyzer.this.poolOffsets[this.index - 1]) != 7) {
            }
        }

        @Override
        public boolean hasNext() {
            return this.index <= ByteCodeAnalyzer.this.poolOffsets.length;
        }

        @Override
        public String next() {
            int current = this.index;
            this.findNext();
            return ByteCodeAnalyzer.this.getClassNameConstant(current);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Mode {
        CONSTANTS,
        INTERFACES,
        FIELDS,
        METHODS,
        ALL;

    }
}

