/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d;

import math.geom3d.Box3D;
import math.geom3d.Shape3D;
import math.geom3d.transform.AffineTransform3D;

public class Point3D
implements Shape3D {
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;

    public Point3D() {
        this(0.0, 0.0, 0.0);
    }

    public Point3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double distance(Point3D point) {
        double dx = point.x - this.x;
        double dy = point.y - this.y;
        double dz = point.z - this.z;
        return Math.hypot(Math.hypot(dx, dy), dz);
    }

    public boolean contains(Point3D point) {
        return !(this.distance(point) > 1.0E-12);
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isBounded() {
        return true;
    }

    public Box3D boundingBox() {
        return new Box3D(this.x, this.x, this.y, this.y, this.z, this.z);
    }

    public Shape3D clip(Box3D box) {
        if (this.x < box.getMinX() || this.x > box.getMaxX()) {
            return null;
        }
        if (this.y < box.getMinY() || this.y > box.getMaxY()) {
            return null;
        }
        if (this.z < box.getMinZ() || this.z > box.getMaxZ()) {
            return null;
        }
        return this;
    }

    public Point3D transform(AffineTransform3D trans) {
        double[] coef = trans.coefficients();
        return new Point3D(this.x * coef[0] + this.y * coef[1] + this.z * coef[2] + coef[3], this.x * coef[4] + this.y * coef[5] + this.z * coef[6] + coef[7], this.x * coef[8] + this.y * coef[9] + this.z * coef[10] + coef[12]);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Point3D)) {
            return false;
        }
        Point3D point = (Point3D)obj;
        if (Math.abs(point.x - this.x) > 1.0E-12) {
            return false;
        }
        if (Math.abs(point.y - this.y) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(point.z - this.z) > 1.0E-12);
    }
}

