/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.reconstructreader.trakem2;

import edu.utexas.clm.reconstructreader.Utils;
import edu.utexas.clm.reconstructreader.trakem2.DefaultTemplate;
import edu.utexas.clm.reconstructreader.trakem2.SeriesTemplate;
import ini.trakem2.Project;
import ini.trakem2.display.AreaList;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Profile;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.tree.Thing;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Trakem2Translator
implements Runnable {
    private final String name;
    private final File dir;
    private final Project project;
    private final double mag;
    private final LayerSet rootLayerSet;
    private final SeriesTemplate template;
    private final Display display;
    private boolean success;
    private final List<ProjectThing> reconstructThings;

    public Trakem2Translator(Project p, File outdir) {
        this(p, outdir, p.getTitle().replace(".xml", "") + " export");
    }

    public Trakem2Translator(Project p, File outdir, String projectName) {
        this.project = p;
        this.dir = outdir;
        this.name = projectName;
        this.rootLayerSet = p.getRootLayerSet();
        this.mag = (this.rootLayerSet.getCalibration().pixelHeight + this.rootLayerSet.getCalibration().pixelWidth) / 2.0;
        this.template = DefaultTemplate.getTemplate();
        this.display = Display.getFront((Project)this.project);
        this.success = false;
        ProjectThing rootPT = this.project.getRootProjectThing();
        this.reconstructThings = rootPT.findChildrenOfType("reconstruct");
    }

    @Override
    public void run() {
        try {
            this.writeSeriesDoc();
            this.writeSectionDocs();
            this.success = true;
        }
        catch (IOException ioe) {
            System.err.println("IOException while writing files");
            this.success = false;
        }
    }

    public boolean getSuccess() {
        return this.success;
    }

    private void writeSeriesDoc() throws IOException {
        File serFile = new File(this.dir, this.name + ".ser");
        StringBuilder sb = new StringBuilder();
        Layer frontLayer = Display.getFrontLayer((Project)this.project);
        if (frontLayer == null) {
            frontLayer = this.project.getRootLayerSet().getLayer(0);
        }
        sb.append("<?xml version = \"1.0\"?>\n");
        sb.append("<!DOCTYPE Series SYSTEM \"series.dtd\">\n");
        sb.append("<Series index=\"").append(this.project.getRootLayerSet().indexOf(frontLayer)).append("\"\n");
        sb.append("");
        for (String key : Utils.getSeriesKeys()) {
            sb.append(key).append("=\"").append(this.template.getValue(key)).append("\"\n");
        }
        sb.append(">\n");
        this.template.setContourText(sb);
        sb.append("</Series>\n");
        FileOutputStream fos = new FileOutputStream(serFile);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fos), "8859_1");
        writer.write(sb.toString());
        writer.flush();
        writer.close();
    }

    private HashMap<Long, ArrayList<ProfileData>> sortProfileLists() {
        HashMap<Long, ArrayList<ProfileData>> map = new HashMap<Long, ArrayList<ProfileData>>();
        for (Layer layer : this.rootLayerSet.getLayers()) {
            map.put(layer.getId(), new ArrayList());
        }
        for (ProjectThing rt : this.reconstructThings) {
            ArrayList profileLists = rt.findChildren("profile_list", null, false);
            for (ProjectThing pList : profileLists) {
                ArrayList profiles = pList.findChildrenOfType(Profile.class);
                for (Profile p : profiles) {
                    long id = p.getLayer().getId();
                    map.get(id).add(new ProfileData(p, pList));
                }
            }
        }
        return map;
    }

    private void writeSectionDocs() throws IOException {
        List areaLists = this.rootLayerSet.getAll(AreaList.class);
        int numLayers = this.rootLayerSet.size();
        Rectangle r = this.project.getRootLayerSet().get2DBounds();
        float w = r.width;
        float h = r.height;
        HashMap<Long, ArrayList<ProfileData>> profileMap = this.sortProfileLists();
        for (int l = 0; l < numLayers; ++l) {
            String im = this.rootLayerSet.getLayer(l).getPrintableTitle() + ".tif";
            File sectionFile = new File(this.dir, this.name + "." + l);
            FileOutputStream fos = new FileOutputStream(sectionFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fos), "8859_1");
            writer.write("<?xml version=\"1.0\"?>\n");
            writer.write("<!DOCTYPE Series SYSTEM \"series.dtd\">\n\n");
            writer.write("<Section index=\"" + l + "\" thickness=\"" + this.rootLayerSet.getLayer(l).getCalibratedThickness() + " \" alignLocked=\"true\" >\n");
            writer.write("<Transform dim=\"0\"\nxcoef=\"0 1 0 0 0 0\"\nycoef=\"0 0 1 0 0 0\">\n");
            writer.write("<Image mag=\"" + this.mag + "\" contrast=\"1.14434\" brightness=\"-0.15\" red=\"true\" green=\"true\" blue=\"true\" src=\"" + im + "\" />\n");
            writer.write("<Contour name=\"domain1\" hidden=\"false\" closed=\"true\" simplified=\"false\" border=\"1 0 1\" fill=\"1 0 1\" mode=\"11\" points=\" 0 0,\n\t " + w + " 0,\n\t " + w + " " + h + ",\n\t 0 " + h + ",\n\t\" />\n");
            writer.write("</Transform>\n");
            writer.write("<Transform dim=\"0\"\nxcoef=\"0 1 0 0 0 0\"\nycoef=\"0 0 1 0 0 0\">\n");
            for (AreaList al : areaLists) {
                Area area = al.getArea(this.rootLayerSet.getLayer(l));
                if (area == null || area.isEmpty()) continue;
                Thing thing = this.project.findProjectThing((Object)al).getParent();
                PathIterator pathIter = area.getPathIterator(al.getAffineTransform());
                float[] rgb = new float[3];
                al.getColor().getColorComponents(rgb);
                while (!pathIter.isDone()) {
                    ArrayList<float[]> path = this.getNextPath(pathIter);
                    this.writePathXML(writer, (Displayable)al, thing, path, true, h);
                }
            }
            for (ProfileData profileData : profileMap.get(this.rootLayerSet.getLayer(l).getId())) {
                ArrayList<float[]> path = this.getPathFromProfile(profileData.profile);
                this.writePathXML(writer, (Displayable)profileData.profile, profileData.parent.getParent(), path, false, h);
            }
            writer.write("</Transform>");
            writer.write("</Section>");
            writer.flush();
            writer.close();
        }
    }

    private void writePathXML(Writer writer, Displayable d, Thing t, List<float[]> path, boolean isClosed, float h) throws IOException {
        String alname = t.getTitle();
        float[] rgb = new float[3];
        boolean isVisible = d.isVisible();
        d.getColor().getColorComponents(rgb);
        if (!path.isEmpty()) {
            String tab = "";
            writer.write("<Contour name=\"" + alname + "\" hidden=\"" + !isVisible);
            writer.write("\" closed=\"" + isClosed + "\" simplified=\"true\" ");
            writer.write("border=\"" + rgb[0] + " " + rgb[1] + " " + rgb[2] + "\" ");
            writer.write("fill=\"" + rgb[0] + " " + rgb[1] + " " + rgb[2] + "\" ");
            writer.write("mode=\"11\" points=\"");
            for (float[] pt : path) {
                writer.write(tab + " " + (double)pt[0] * this.mag + " " + (double)(h - pt[1]) * this.mag + ",\n");
                tab = "\t";
            }
            writer.write(tab + "\" />\n");
        }
    }

    private ArrayList<float[]> getPathFromProfile(Profile profile) {
        ArrayList<float[]> path = new ArrayList<float[]>();
        AffineTransform at = profile.getAffineTransform();
        double[][][] ba = profile.getBezierArrays();
        if (profile.getPointCount() > 0) {
            double[][] pts = profile.transformPoints(ba[1]);
            double[] xpts = pts[0];
            double[] ypts = pts[1];
            for (int i = 0; i < xpts.length; ++i) {
                path.add(new float[]{(float)xpts[i], (float)ypts[i]});
            }
        }
        return path;
    }

    private ArrayList<float[]> getNextPath(PathIterator pi) {
        float[] end;
        ArrayList<float[]> path = new ArrayList<float[]>();
        boolean cont = !pi.isDone();
        boolean firstPt = true;
        while (cont) {
            float[] pt = new float[]{Float.NaN, Float.NaN};
            int type = pi.currentSegment(pt);
            if (type == 0 && !firstPt) {
                cont = false;
                continue;
            }
            if (!Float.isNaN(pt[0])) {
                path.add(pt);
            }
            pi.next();
            cont = !pi.isDone();
            firstPt = false;
        }
        float[] start = (float[])path.get(0);
        if (start[0] == (end = (float[])path.get(path.size() - 1))[0] && start[1] == end[1]) {
            path.remove(path.size() - 1);
        }
        if (this.isCCW(path)) {
            Collections.reverse(path);
        }
        return path;
    }

    private boolean isCCW(List<float[]> path) {
        float[] pt1;
        float twiceA = 0.0f;
        int i = 0;
        while (i + 1 < path.size()) {
            float[] pt0 = path.get(i);
            float[] pt12 = path.get(i + 1);
            twiceA += pt0[0] * pt12[1] - pt0[1] * pt12[0];
            ++i;
        }
        float[] pt0 = path.get(path.size() - 1);
        return (twiceA += pt0[0] * (pt1 = path.get(0))[1] - pt0[1] * pt1[0]) >= 0.0f;
    }

    private class ProfileData {
        public final Profile profile;
        public final ProjectThing parent;

        public ProfileData(Profile profileIn, ProjectThing parentIn) {
            this.profile = profileIn;
            this.parent = parentIn;
        }
    }
}

