/*
 * Decompiled with CFR 0.152.
 */
package levelsets.algorithm;

import ij.IJ;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import levelsets.algorithm.BandElement;
import levelsets.algorithm.BandElementCache;
import levelsets.algorithm.DeferredDoubleArray3D;
import levelsets.algorithm.DeferredIntArray3D;
import levelsets.algorithm.DeferredObjectArray3D;
import levelsets.algorithm.StagedAlgorithm;
import levelsets.ij.ImageContainer;
import levelsets.ij.ImageProgressContainer;
import levelsets.ij.StateContainer;

public abstract class SparseFieldLevelSet
implements StagedAlgorithm {
    protected DeferredDoubleArray3D phi = null;
    private DeferredObjectArray3D<BandElement> elementLUT = null;
    private int[][][] state = null;
    public static final int INSIDE = -1;
    public static final int OUTSIDE = 1;
    public static final int STATE_ZERO = 0;
    public static final int INSIDE_FAR = Integer.MIN_VALUE;
    public static final int OUTSIDE_FAR = Integer.MAX_VALUE;
    private DeferredIntArray3D action = null;
    private static final int NO_ACTION = 0;
    private static final int CHANGE_LAYER = 2;
    private static final int ACTIVE_OUTSIDE = 1;
    private static final int ACTIVE_INSIDE = -1;
    private static final int NO_DRAG = 0x7FFFFFFE;
    private static final double PHI_THRESHOLD = 0.5;
    protected ImageContainer source = null;
    protected ImageContainer img = null;
    private ImageProgressContainer progress = null;
    private static final int NUM_LAYERS = 2;
    private static final int ZERO_LAYER = 2;
    private static final int INITIAL_LISTSIZE = 500;
    private final ArrayList[] layers = new ArrayList[5];
    private ArrayList<BandElement> outside_list = new ArrayList(500);
    private ArrayList<BandElement> inside_list = new ArrayList(500);
    private ArrayList<BandElement> result_outside_list = new ArrayList(500);
    private ArrayList<BandElement> result_inside_list = new ArrayList(500);
    private ArrayList<BandElement> update_list = new ArrayList(500);
    private BandElementCache elem_cache = null;
    private static int ELEMENT_CACHE_SIZE = 10000;
    protected StateContainer init_state = null;
    protected boolean needInit = true;
    private boolean convergence = false;
    private boolean invalid = false;
    protected int seed_greyvalue = 0;
    protected boolean seed_grey_zero = true;
    private double total_change = 0.0;
    private int num_updated = 0;
    int[] pixel = new int[4];
    protected double DELTA_T = 0.16666666666666666;
    protected final double CONVERGENCE_WEIGHT;
    protected double CONVERGENCE_FACTOR;
    protected double zScale = 0.0;
    final int verbose = 0;

    public SparseFieldLevelSet(ImageContainer image, ImageProgressContainer img_progress, StateContainer init_state, double convergence) {
        this.init_state = init_state;
        this.source = image;
        this.progress = img_progress;
        this.zScale = this.source.getzScale();
        this.needInit = true;
        this.CONVERGENCE_WEIGHT = convergence;
    }

    public int[][][] getStateMap() {
        return this.state;
    }

    public StateContainer getStateContainer() {
        if (this.invalid) {
            return null;
        }
        StateContainer sc = new StateContainer();
        sc.setSparseField(this.state);
        return sc;
    }

    protected abstract void updateDeltaT();

    protected void init() {
        this.phi = new DeferredDoubleArray3D(this.source.getWidth(), this.source.getHeight(), this.source.getImageCount(), 5, 0.0);
        this.state = new int[this.source.getWidth()][this.source.getHeight()][this.source.getImageCount()];
        this.action = new DeferredIntArray3D(this.source.getWidth(), this.source.getHeight(), this.source.getImageCount(), 5, 0);
        this.elementLUT = new DeferredObjectArray3D<Object>(this.source.getWidth(), this.source.getHeight(), this.source.getImageCount(), 5, null);
        this.elem_cache = new BandElementCache(ELEMENT_CACHE_SIZE);
        this.updateDeltaT();
        this.CONVERGENCE_FACTOR = this.CONVERGENCE_WEIGHT * this.DELTA_T;
        this.seed_greyvalue = this.init_state.getZeroGreyValue();
        for (int i = 0; i < 5; ++i) {
            this.layers[i] = new ArrayList(500);
        }
        this.img = this.source.deepCopy();
        this.createActiveLayer();
        this.init_state = null;
        this.createInactiveLayers();
        this.checkConsistency();
        this.visualize(true);
        this.needInit = false;
        IJ.log((String)("Delta t = " + this.DELTA_T));
    }

    @Override
    public boolean step(int granularity) {
        if (this.invalid) {
            return false;
        }
        if (this.needInit) {
            this.init();
        }
        for (int i = 0; i < granularity; ++i) {
            assert (this.outside_list.size() == 0 && this.inside_list.size() == 0 && this.result_inside_list.size() == 0 && this.result_outside_list.size() == 0);
            assert (this.layers[0].size() != 0 && this.layers[1].size() != 0 && this.layers[2].size() != 0 && this.layers[3].size() != 0 && this.layers[4].size() != 0);
            this.iterate();
            if (!this.convergence) continue;
            IJ.log((String)"Converged! Final iteration:");
            break;
        }
        this.visualize(true);
        if (this.convergence) {
            this.cleanup();
        }
        if (Double.isNaN(this.total_change) || this.layers[2].size() == 0) {
            this.invalid = true;
            throw new ArithmeticException("Level Sets encountered numerical instability (i.e. the contour probably expanded to infinity or 0) - Aborted");
        }
        return !this.convergence;
    }

    private final void visualize(boolean set_output) {
        if (this.progress == null) {
            return;
        }
        if (!this.needInit) {
            IJ.log((String)("Iteration step: convergence = " + this.total_change / (double)this.num_updated + ", number of pixels changed = " + this.total_change / (double)this.layers[2].size()));
        }
        Object output = null;
        if (this.convergence) {
            this.progress.duplicateImages(this.source);
        } else if (set_output) {
            this.progress.duplicateImages(this.img);
        }
        this.drawLayers(2, 3);
        this.progress.showProgressStep();
    }

    private final void iterate() {
        int i;
        this.convergence = this.updateActiveLayer();
        this.processLayerChangeList(this.inside_list, -1, this.result_inside_list, 1);
        this.processLayerChangeList(this.outside_list, 1, this.result_outside_list, -1);
        for (i = 1; i < 2; ++i) {
            this.swapLists();
            this.processLayerChangeList(this.inside_list, i * 1 + -1, this.result_inside_list, i * 1 + 1);
            this.processLayerChangeList(this.outside_list, i * -1 + 1, this.result_outside_list, i * -1 + -1);
        }
        this.swapLists();
        this.processLayerChangeList(this.inside_list, 1, this.result_inside_list, Integer.MAX_VALUE);
        this.processLayerChangeList(this.outside_list, -1, this.result_outside_list, Integer.MIN_VALUE);
        this.swapLists();
        this.processLayerChangeList(this.inside_list, 2, this.result_inside_list, 0x7FFFFFFE);
        this.processLayerChangeList(this.outside_list, -2, this.result_outside_list, 0x7FFFFFFE);
        for (i = 1; i <= 2; ++i) {
            this.updateInactiveLayer(2 - i);
            this.updateInactiveLayer(2 + i);
        }
    }

    private void swapLists() {
        ArrayList<BandElement> swap = null;
        swap = this.outside_list;
        this.outside_list = this.result_outside_list;
        this.result_outside_list = swap;
        swap = this.inside_list;
        this.inside_list = this.result_inside_list;
        this.result_inside_list = swap;
    }

    protected abstract double getDeltaPhi(int var1, int var2, int var3);

    private final boolean updateActiveLayer() {
        assert (this.update_list.size() == 0);
        this.total_change = 0.0;
        this.num_updated = 0;
        Iterator it = this.layers[2].iterator();
        while (it.hasNext()) {
            BandElement elem = (BandElement)it.next();
            int x = elem.getX();
            int y = elem.getY();
            int z = elem.getZ();
            double delta_phi = this.getDeltaPhi(x, y, z);
            this.total_change += Math.abs(delta_phi);
            ++this.num_updated;
            double temp_phi = this.phi.get(x, y, z) + delta_phi;
            if (temp_phi < -0.5) {
                if (this.zeroLayerNeighbourMovement(x, y, z, 1)) continue;
                this.updateZeroLayerNeighbours(x, y, z, 3, temp_phi, this.update_list);
                it.remove();
                this.inside_list.add(elem);
                this.action.set(x, y, z, -1);
                continue;
            }
            if (temp_phi > 0.5) {
                if (this.zeroLayerNeighbourMovement(x, y, z, -1)) continue;
                this.updateZeroLayerNeighbours(x, y, z, 1, temp_phi, this.update_list);
                it.remove();
                this.outside_list.add(elem);
                this.action.set(x, y, z, 1);
                continue;
            }
            elem.setValue(temp_phi);
            this.update_list.add(elem);
        }
        for (BandElement elem : this.update_list) {
            if (elem.getValue() == Double.MAX_VALUE) continue;
            this.phi.set(elem.getX(), elem.getY(), elem.getZ(), elem.getValue());
            elem.setValue(Double.MAX_VALUE);
        }
        return this.total_change / (double)this.num_updated < this.CONVERGENCE_WEIGHT;
    }

    private final void updateInactiveLayer(int layer) {
        int delta_phi = layer < 2 ? -1 : 1;
        Iterator it = this.layers[layer].iterator();
        while (it.hasNext()) {
            int z;
            int y;
            BandElement elem = (BandElement)it.next();
            int x = elem.getX();
            if (this.state[x][y = elem.getY()][z = elem.getZ()] != layer - 2) {
                this.elem_cache.recycleBandElement(elem);
                it.remove();
                continue;
            }
            double value = this.checkNeighboursForUpdate(x, y, z, layer);
            if (Math.abs(value) == Double.MAX_VALUE) {
                it.remove();
                if (layer == 0) {
                    this.state[x][y][z] = Integer.MIN_VALUE;
                    this.elementLUT.set(x, y, z, null);
                    this.elem_cache.recycleBandElement(elem);
                    continue;
                }
                if (layer == this.layers.length - 1) {
                    this.state[x][y][z] = Integer.MAX_VALUE;
                    this.elementLUT.set(x, y, z, null);
                    this.elem_cache.recycleBandElement(elem);
                    continue;
                }
                if (layer < 2) {
                    this.layers[layer + -1].add(elem);
                    this.state[x][y][z] = layer - 2 + -1;
                    continue;
                }
                this.layers[layer + 1].add(elem);
                this.state[x][y][z] = layer - 2 + 1;
                continue;
            }
            this.phi.set(x, y, z, value + (double)delta_phi);
        }
    }

    private final void processLayerChangeList(List<BandElement> swap_list, int swap_to, List<BandElement> drag_list, int drag_index) {
        Iterator<BandElement> it = swap_list.iterator();
        while (it.hasNext()) {
            BandElement elem = it.next();
            it.remove();
            int elem_x = elem.getX();
            int elem_y = elem.getY();
            int elem_z = elem.getZ();
            this.layers[swap_to + 2].add(elem);
            this.elementLUT.set(elem_x, elem_y, elem_z, elem);
            this.state[elem_x][elem_y][elem_z] = swap_to;
            this.action.set(elem_x, elem_y, elem_z, 0);
            if (drag_index == 0x7FFFFFFE) continue;
            Iterator<BandElement> neighbours = this.neighbourhood(elem_x, elem_y, elem_z);
            while (neighbours.hasNext()) {
                int neighbour_z;
                int neighbour_y;
                BandElement neighbour = neighbours.next();
                int neighbour_x = neighbour.getX();
                if (this.state[neighbour_x][neighbour_y = neighbour.getY()][neighbour_z = neighbour.getZ()] != drag_index || this.action.get(neighbour_x, neighbour_y, neighbour_z) == 2) continue;
                this.action.set(neighbour_x, neighbour_y, neighbour_z, 2);
                BandElement dragged = this.elem_cache.getRecycledBandElement(neighbour_x, neighbour_y, neighbour_z, Double.MAX_VALUE);
                drag_list.add(dragged);
            }
        }
    }

    private final void updateZeroLayerNeighbours(int x, int y, int z, int layer, double temp_phi, List update_list) {
        Iterator<BandElement> neighbours = this.neighbourhood(x, y, z);
        while (neighbours.hasNext()) {
            double value;
            BandElement aNeighbour = neighbours.next();
            if (this.state[aNeighbour.getX()][aNeighbour.getY()][aNeighbour.getZ()] != layer - 2) continue;
            BandElement elem = this.elementLUT.get(aNeighbour.getX(), aNeighbour.getY(), aNeighbour.getZ());
            int neighbour_x = elem.getX();
            int neighbour_y = elem.getY();
            int neighbour_z = elem.getZ();
            int side = layer < 2 ? -1 : 1;
            double d = value = elem.getValue() == Double.MAX_VALUE ? Double.MAX_VALUE * (double)side : elem.getValue();
            if (layer < 2) {
                if (!(temp_phi + -1.0 > value)) continue;
                elem.setValue(temp_phi + -1.0);
                update_list.add(elem);
                continue;
            }
            if (!(temp_phi + 1.0 < value)) continue;
            elem.setValue(temp_phi + 1.0);
            update_list.add(elem);
        }
    }

    private final double checkNeighboursForUpdate(int x, int y, int z, int layer) {
        double value;
        int from_layer;
        assert (this.state[x][y][z] == layer - 2);
        if (layer < 2) {
            from_layer = layer + 1;
            value = -1.7976931348623157E308;
        } else {
            from_layer = layer + -1;
            value = Double.MAX_VALUE;
        }
        Iterator<BandElement> it = this.neighbourhood(x, y, z);
        while (it.hasNext()) {
            int elem_z;
            int elem_y;
            BandElement elem = it.next();
            int elem_x = elem.getX();
            if (this.state[elem_x][elem_y = elem.getY()][elem_z = elem.getZ()] != from_layer - 2) continue;
            double trial_value = this.phi.get(elem_x, elem_y, elem_z);
            if (layer < 2) {
                if (!(trial_value > value)) continue;
                value = trial_value;
                continue;
            }
            if (!(trial_value < value)) continue;
            value = trial_value;
        }
        return value;
    }

    private final boolean zeroLayerNeighbourMovement(int x, int y, int z, int direction) {
        Iterator<BandElement> it = this.neighbourhood(x, y, z);
        while (it.hasNext()) {
            int elem_z;
            int elem_y;
            BandElement elem = it.next();
            int elem_x = elem.getX();
            if (this.state[elem_x][elem_y = elem.getY()][elem_z = elem.getZ()] != 2 || this.action.get(elem_x, elem_y, elem_z) != direction) continue;
            return true;
        }
        return false;
    }

    private final void createInactiveLayers() {
        for (int i = 0; i <= 1; ++i) {
            for (BandElement elem : this.layers[2 + i * -1]) {
                Iterator<BandElement> neighbours = this.neighbourhood(elem.getX(), elem.getY(), elem.getZ());
                while (neighbours.hasNext()) {
                    this.addToLayerIfFar(neighbours.next(), 2 + i * -1);
                }
            }
            if (i == 0) continue;
            for (BandElement elem : this.layers[2 + i * 1]) {
                Iterator<BandElement> neighbours = this.neighbourhood(elem.getX(), elem.getY(), elem.getZ());
                while (neighbours.hasNext()) {
                    this.addToLayerIfFar(neighbours.next(), 2 + i * 1);
                }
            }
        }
    }

    private final void addToLayerIfFar(BandElement element, int from_layer) {
        int z;
        int y;
        int x = element.getX();
        if (this.state[x][y = element.getY()][z = element.getZ()] == Integer.MIN_VALUE) {
            BandElement elem = new BandElement(x, y, z, Double.MAX_VALUE);
            this.layers[from_layer + -1].add(elem);
            this.elementLUT.set(x, y, z, elem);
            this.state[x][y][z] = from_layer - 2 + -1;
        } else if (this.state[x][y][z] == Integer.MAX_VALUE) {
            BandElement elem = new BandElement(x, y, z, Double.MAX_VALUE);
            this.layers[from_layer + 1].add(elem);
            this.elementLUT.set(x, y, z, elem);
            this.state[x][y][z] = from_layer - 2 + 1;
        } else {
            return;
        }
        this.phi.set(x, y, z, this.state[x][y][z]);
    }

    private final void drawLayers(int from, int to) {
        for (int i = from; i <= to; ++i) {
            if (i == 2) {
                this.pixel[0] = 255;
                this.pixel[1] = 0;
                this.pixel[2] = 0;
            } else {
                this.pixel[0] = 255;
                this.pixel[1] = 255 / Math.abs(i - 2);
                this.pixel[2] = 0;
            }
            for (BandElement elem : this.layers[i]) {
                this.progress.setPixel(elem.getX(), elem.getY(), elem.getZ(), this.pixel);
            }
        }
    }

    private final void createActiveLayer() {
        int px_zero = 0;
        int px_inside = 0;
        int px_outside = 0;
        int grey_zero = 0;
        int grey_inside = 0;
        DeferredObjectArray3D<StateContainer.States> statemap = this.init_state.getForSparseField();
        for (int x = 0; x < statemap.getXLength(); ++x) {
            for (int y = 0; y < statemap.getYLength(); ++y) {
                for (int z = 0; z < statemap.getZLength(); ++z) {
                    if (statemap.get(x, y, z) == StateContainer.States.ZERO) {
                        this.state[x][y][z] = 0;
                        this.phi.set(x, y, z, 0.0);
                        BandElement element = new BandElement(x, y, z, 0.0);
                        this.layers[2].add(element);
                        this.elementLUT.set(x, y, z, element);
                        ++px_zero;
                        grey_zero += this.source.getPixel(x, y, z);
                        continue;
                    }
                    if (statemap.get(x, y, z) == StateContainer.States.INSIDE) {
                        this.state[x][y][z] = Integer.MIN_VALUE;
                        ++px_inside;
                        grey_inside += this.source.getPixel(x, y, z);
                        continue;
                    }
                    this.state[x][y][z] = Integer.MAX_VALUE;
                    ++px_outside;
                }
            }
        }
        IJ.log((String)("Initiated boundary pixels: " + px_zero + " ZERO, " + px_inside + " INSIDE, " + px_outside + " OUTSIDE"));
        if (px_inside == 0 && px_zero == 0) {
            this.invalid = true;
            throw new IllegalArgumentException("Level Sets didn't get any starting shape - Aborting");
        }
        if (this.seed_greyvalue < 0) {
            this.seed_greyvalue = this.seed_grey_zero ? grey_zero / px_zero : grey_inside / px_zero;
            IJ.log((String)("Grey seed not set - setting to mean of ROI boundary = " + this.seed_greyvalue));
        }
    }

    private final boolean outOfRange(int x, int y, int z) {
        if (x < 0 || x > this.state.length - 1) {
            return true;
        }
        if (y < 0 || y > this.state[0].length - 1) {
            return true;
        }
        return z < 0 || z > this.state[0][0].length - 1;
    }

    private final Iterator<BandElement> neighbourhood(int x, int y, int z) {
        ArrayList<BandElement> neighbourList = new ArrayList<BandElement>(6);
        if (!this.outOfRange(x - 1, y, z)) {
            neighbourList.add(this.elem_cache.getRecycledBandElement(x - 1, y, z, Double.MAX_VALUE));
        }
        if (!this.outOfRange(x + 1, y, z)) {
            neighbourList.add(this.elem_cache.getRecycledBandElement(x + 1, y, z, Double.MAX_VALUE));
        }
        if (!this.outOfRange(x, y - 1, z)) {
            neighbourList.add(this.elem_cache.getRecycledBandElement(x, y - 1, z, Double.MAX_VALUE));
        }
        if (!this.outOfRange(x, y + 1, z)) {
            neighbourList.add(this.elem_cache.getRecycledBandElement(x, y + 1, z, Double.MAX_VALUE));
        }
        if (!this.outOfRange(x, y, z - 1)) {
            neighbourList.add(this.elem_cache.getRecycledBandElement(x, y, z - 1, Double.MAX_VALUE));
        }
        if (!this.outOfRange(x, y, z + 1)) {
            neighbourList.add(this.elem_cache.getRecycledBandElement(x, y, z + 1, Double.MAX_VALUE));
        }
        return neighbourList.iterator();
    }

    private final void checkConsistency() {
        for (int i = 0; i < 5; ++i) {
            for (BandElement elem : this.layers[i]) {
                double val;
                if (this.state[elem.getX()][elem.getY()][elem.getZ()] != i - 2) {
                    IJ.log((String)"*** Layer index mismatch!!! ***");
                    IJ.log((String)("Layer = " + i));
                }
                if ((val = this.phi.get(elem.getX(), elem.getY(), elem.getZ())) > 0.0 && i < 2 || val < 0.0 && i > 2) {
                    IJ.log((String)"*** Illegal PHI value !!! ***");
                    IJ.log((String)("Layer = " + i));
                }
                if (!(val > 0.55 && i == 2) && (!(val < -0.55) || i != 2)) continue;
                IJ.log((String)"*** Illegal PHI value in ZERO Layer !!! ***");
                IJ.log((String)("Value = " + val));
            }
        }
    }

    protected void cleanup() {
        this.elem_cache = null;
        this.phi = null;
        this.action = null;
        this.source = null;
        this.img = null;
    }

    public void dumpStateMap(String path) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(new File(path)));
            out.write(this.state.length + " " + this.state[0].length + " " + this.state[0][0].length);
            out.newLine();
            out.newLine();
            int val = 0;
            for (int z = 0; z < this.state[0][0].length; ++z) {
                for (int y = 0; y < this.state[0].length; ++y) {
                    for (int x = 0; x < this.state.length; ++x) {
                        val = this.state[x][y][z];
                        if (val == Integer.MAX_VALUE) {
                            val = 9;
                        } else if (val == Integer.MIN_VALUE) {
                            val = -9;
                        }
                        out.write(val + " ");
                    }
                    out.newLine();
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

