/*
 * Decompiled with CFR 0.152.
 */
package levelsets.filter;

import ij.process.ShortProcessor;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferUShort;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import levelsets.filter.BufferedImageBuilder;
import levelsets.filter.Filter;

public class Canny
implements Filter {
    final float ORIENT_SCALE = 40.0f;
    private int height;
    private int width;
    private int picsize;
    private int[] data;
    private int[] derivative_mag;
    private int[] magnitude;
    private int[] orientation;
    private Image sourceImage;
    private Image edgeImage;
    private int threshold1;
    private int threshold2;
    private int threshold;
    private int widGaussianKernel;

    public Canny(int lowerThreshold, int upperTreshold, int kernelWidth) {
        this.threshold1 = lowerThreshold;
        this.threshold2 = upperTreshold;
        this.setThreshold(128);
        this.setWidthGaussianKernel(kernelWidth);
    }

    @Override
    public void filter(int width, int height, short[] source, short[] target) {
        ShortProcessor sp = new ShortProcessor(width, height, source, null);
        BufferedImage bi = this.filter(sp.get16BitBufferedImage());
        DataBufferUShort db = (DataBufferUShort)bi.getData().getDataBuffer();
        System.arraycopy(target, 0, db.getData(), 0, target.length);
    }

    @Override
    public BufferedImage filter(BufferedImage sourceImage) {
        if (this.threshold < 0 || this.threshold > 255) {
            throw new RuntimeException("The value of the threshold is out of its valid range.");
        }
        if (this.widGaussianKernel < 3 || this.widGaussianKernel > 40) {
            throw new RuntimeException("The value of the widGaussianKernel is out of its valid range.");
        }
        this.width = sourceImage.getWidth();
        this.height = sourceImage.getHeight();
        this.sourceImage = sourceImage;
        this.picsize = this.width * this.height;
        this.data = new int[this.picsize];
        this.magnitude = new int[this.picsize];
        this.orientation = new int[this.picsize];
        float f = 1.0f;
        this.canny_core(f, this.widGaussianKernel);
        this.thresholding_tracker(this.threshold1, this.threshold2);
        for (int i = 0; i < this.picsize; ++i) {
            this.data[i] = this.data[i] > this.threshold ? -1 : -16777216;
        }
        this.edgeImage = this.pixels2image(this.data);
        this.data = null;
        this.magnitude = null;
        this.orientation = null;
        return (BufferedImage)this.edgeImage;
    }

    private void canny_core(float f, int i) {
        float f1;
        int k4;
        boolean flag = false;
        boolean flag1 = false;
        this.derivative_mag = new int[this.picsize];
        float[] af4 = new float[i];
        float[] af5 = new float[i];
        float[] af6 = new float[i];
        this.data = this.image2pixels(this.sourceImage);
        for (k4 = 0; !(k4 >= i || (f1 = this.gaussian(k4, f)) <= 0.005f && k4 >= 2); ++k4) {
            float f2 = this.gaussian((float)k4 - 0.5f, f);
            float f3 = this.gaussian((float)k4 + 0.5f, f);
            float f4 = this.gaussian(k4, f * 0.5f);
            af4[k4] = (f1 + f2 + f3) / 3.0f / (6.283185f * f * f);
            af5[k4] = f3 - f2;
            af6[k4] = 1.6f * f4 - f1;
        }
        int j = k4;
        float[] af = new float[this.picsize];
        float[] af1 = new float[this.picsize];
        int j1 = this.width - (j - 1);
        int l = this.width * (j - 1);
        int i1 = this.width * (this.height - (j - 1));
        for (int l4 = j - 1; l4 < j1; ++l4) {
            for (int l5 = l; l5 < i1; l5 += this.width) {
                float f8;
                int k1 = l4 + l5;
                float f10 = f8 = (float)this.data[k1] * af4[0];
                int l6 = 1;
                int k7 = k1 - this.width;
                int i8 = k1 + this.width;
                while (l6 < j) {
                    f8 += af4[l6] * (float)(this.data[k7] + this.data[i8]);
                    f10 += af4[l6] * (float)(this.data[k1 - l6] + this.data[k1 + l6]);
                    ++l6;
                    k7 -= this.width;
                    i8 += this.width;
                }
                af[k1] = f8;
                af1[k1] = f10;
            }
        }
        float[] af2 = new float[this.picsize];
        for (int i5 = j - 1; i5 < j1; ++i5) {
            for (int i6 = l; i6 < i1; i6 += this.width) {
                float f9 = 0.0f;
                int l1 = i5 + i6;
                for (int i7 = 1; i7 < j; ++i7) {
                    f9 += af5[i7] * (af[l1 - i7] - af[l1 + i7]);
                }
                af2[l1] = f9;
            }
        }
        af = null;
        float[] af3 = new float[this.picsize];
        for (int j5 = k4; j5 < this.width - k4; ++j5) {
            for (int j6 = l; j6 < i1; j6 += this.width) {
                float f11 = 0.0f;
                int i2 = j5 + j6;
                int j7 = 1;
                int l7 = this.width;
                while (j7 < j) {
                    f11 += af5[j7] * (af1[i2 - l7] - af1[i2 + l7]);
                    ++j7;
                    l7 += this.width;
                }
                af3[i2] = f11;
            }
        }
        af1 = null;
        j1 = this.width - j;
        l = this.width * j;
        i1 = this.width * (this.height - j);
        for (int k5 = j; k5 < j1; ++k5) {
            for (int k6 = l; k6 < i1; k6 += this.width) {
                float f5;
                int j2 = k5 + k6;
                int k2 = j2 - this.width;
                int l2 = j2 + this.width;
                int i3 = j2 - 1;
                int j3 = j2 + 1;
                int k3 = k2 - 1;
                int l3 = k2 + 1;
                int i4 = l2 - 1;
                int j4 = l2 + 1;
                float f6 = af2[j2];
                float f7 = af3[j2];
                float f12 = this.hypotenuse(f6, f7);
                int k = (int)((double)f12 * 20.0);
                this.derivative_mag[j2] = k >= 256 ? 255 : k;
                float f13 = this.hypotenuse(af2[k2], af3[k2]);
                float f14 = this.hypotenuse(af2[l2], af3[l2]);
                float f15 = this.hypotenuse(af2[i3], af3[i3]);
                float f16 = this.hypotenuse(af2[j3], af3[j3]);
                float f18 = this.hypotenuse(af2[l3], af3[l3]);
                float f20 = this.hypotenuse(af2[j4], af3[j4]);
                float f19 = this.hypotenuse(af2[i4], af3[i4]);
                float f17 = this.hypotenuse(af2[k3], af3[k3]);
                if (f6 * f7 <= 0.0f) {
                    if (Math.abs(f6) >= Math.abs(f7)) {
                        float f2;
                        f5 = Math.abs(f6 * f12);
                        if (!(f2 >= Math.abs(f7 * f18 - (f6 + f7) * f16)) || !(f5 > Math.abs(f7 * f19 - (f6 + f7) * f15))) continue;
                    } else {
                        float f3;
                        f5 = Math.abs(f7 * f12);
                        if (!(f3 >= Math.abs(f6 * f18 - (f7 + f6) * f13)) || !(f5 > Math.abs(f6 * f19 - (f7 + f6) * f14))) continue;
                    }
                } else if (Math.abs(f6) >= Math.abs(f7)) {
                    float f4;
                    f5 = Math.abs(f6 * f12);
                    if (!(f4 >= Math.abs(f7 * f20 + (f6 - f7) * f16)) || !(f5 > Math.abs(f7 * f17 + (f6 - f7) * f15))) continue;
                } else {
                    float f8;
                    f5 = Math.abs(f7 * f12);
                    if (!(f8 >= Math.abs(f6 * f20 + (f7 - f6) * f14)) || !(f5 > Math.abs(f6 * f17 + (f7 - f6) * f13))) continue;
                }
                this.magnitude[j2] = this.derivative_mag[j2];
                this.orientation[j2] = (int)(Math.atan2(f7, f6) * 40.0);
            }
        }
        this.derivative_mag = null;
        af2 = null;
        af3 = null;
    }

    private float hypotenuse(float f, float f1) {
        if (f == 0.0f && f1 == 0.0f) {
            return 0.0f;
        }
        return (float)Math.sqrt(f * f + f1 * f1);
    }

    private float gaussian(float f, float f1) {
        return (float)Math.exp(-f * f / (2.0f * f1 * f1));
    }

    private void thresholding_tracker(int i, int j) {
        for (int k = 0; k < this.picsize; ++k) {
            this.data[k] = 0;
        }
        for (int l = 0; l < this.width; ++l) {
            for (int i1 = 0; i1 < this.height; ++i1) {
                if (this.magnitude[l + this.width * i1] < i) continue;
                this.follow(l, i1, j);
            }
        }
    }

    private boolean follow(int i, int j, int k) {
        int j1 = i + 1;
        int k1 = i - 1;
        int l1 = j + 1;
        int i2 = j - 1;
        int j2 = i + j * this.width;
        if (l1 >= this.height) {
            l1 = this.height - 1;
        }
        if (i2 < 0) {
            i2 = 0;
        }
        if (j1 >= this.width) {
            j1 = this.width - 1;
        }
        if (k1 < 0) {
            k1 = 0;
        }
        if (this.data[j2] == 0) {
            this.data[j2] = this.magnitude[j2];
            boolean flag = false;
            for (int l = k1; l <= j1; ++l) {
                for (int i1 = i2; i1 <= l1; ++i1) {
                    int k2 = l + i1 * this.width;
                    if (i1 == j && l == i || this.magnitude[k2] < k || !this.follow(l, i1, k)) continue;
                    flag = true;
                    break;
                }
                if (!flag) break;
            }
            return true;
        }
        return false;
    }

    private Image pixels2image(int[] ai) {
        MemoryImageSource memoryimagesource = new MemoryImageSource(this.width, this.height, ColorModel.getRGBdefault(), ai, 0, this.width);
        BufferedImageBuilder bb = new BufferedImageBuilder();
        memoryimagesource.startProduction(bb);
        this.edgeImage = bb.getBufferedImage();
        return this.edgeImage;
    }

    private int[] image2pixels(Image image) {
        int[] ai = new int[this.picsize];
        PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.width, this.height, ai, 0, this.width);
        try {
            pixelgrabber.grabPixels();
        }
        catch (InterruptedException interruptedexception) {
            interruptedexception.printStackTrace();
        }
        boolean flag = false;
        for (int k1 = 0; k1 < 16; ++k1) {
            int i = (ai[k1] & 0xFF0000) >> 16;
            int k = (ai[k1] & 0xFF00) >> 8;
            int i1 = ai[k1] & 0xFF;
            if (i == k && k == i1) continue;
            flag = true;
            break;
        }
        if (flag) {
            for (int l1 = 0; l1 < this.picsize; ++l1) {
                int j = (ai[l1] & 0xFF0000) >> 16;
                int l = (ai[l1] & 0xFF00) >> 8;
                int j1 = ai[l1] & 0xFF;
                ai[l1] = (int)(0.298 * (double)j + 0.586 * (double)l + 0.113 * (double)j1);
            }
        } else {
            for (int i2 = 0; i2 < this.picsize; ++i2) {
                ai[i2] = ai[i2] & 0xFF;
            }
        }
        return ai;
    }

    public void setSourceImage(Image image) {
        this.sourceImage = image;
    }

    public Image getEdgeImage() {
        return this.edgeImage;
    }

    public void setThreshold(int i) {
        this.threshold = i;
    }

    public void setWidthGaussianKernel(int i) {
        this.widGaussianKernel = i;
    }
}

