/*
 * Decompiled with CFR 0.152.
 */
package levelsets.filter;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import levelsets.filter.Filter;

public abstract class MorphologicalOperator
implements Filter {
    protected final boolean[][] mask;
    protected final int[] pixel = new int[3];
    protected int center = 0;

    public MorphologicalOperator(boolean[][] mask) {
        this.mask = mask;
        this.center = mask.length / 2 + 1;
    }

    @Override
    public BufferedImage filter(BufferedImage input) {
        BufferedImage image = new BufferedImage(input.getWidth(), input.getHeight(), 11);
        WritableRaster in = input.getRaster();
        WritableRaster raster = image.getRaster();
        int width = image.getWidth();
        int height = image.getHeight();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                if (i < this.center || i > width - this.center - 1 || j < this.center || j > height - this.center - 1) continue;
                this.processPosition(i, j, raster, in);
            }
        }
        return image;
    }

    @Override
    public final void filter(int width, int height, short[] source, short[] target) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                if (i < this.center || i > width - this.center - 1 || j < this.center || j > height - this.center - 1) continue;
                this.processPosition(i, j, width, source, target);
            }
        }
    }

    public static final boolean[][] getTrueMask(int width, int height) {
        boolean[][] newMask = new boolean[width][height];
        for (int i = 0; i < newMask.length; ++i) {
            for (int j = 0; j < newMask[0].length; ++j) {
                newMask[i][j] = true;
            }
        }
        return newMask;
    }

    protected abstract void processPosition(int var1, int var2, WritableRaster var3, Raster var4);

    protected abstract void processPosition(int var1, int var2, int var3, short[] var4, short[] var5);
}

