/*
 * Decompiled with CFR 0.152.
 */
package ome.units.quantity;

import ome.units.quantity.Quantity;
import ome.units.unit.Unit;

public class ElectricPotential
extends Quantity
implements Comparable<ElectricPotential> {
    private static final int SEED1 = 23;
    private static final int SEED2 = 34;
    Number value;
    Unit<ElectricPotential> unit;
    private int hashCodeValue;

    public ElectricPotential(Number inValue, Unit<ElectricPotential> inUnit) {
        if (inValue == null) {
            throw new NullPointerException("ElectricPotential: ElectricPotential cannot be constructed with a null value.");
        }
        this.value = inValue;
        this.unit = inUnit;
        this.hashCodeValue = 23;
        this.hashCodeValue = 34 * this.hashCodeValue + Float.floatToIntBits(this.value.floatValue());
        this.hashCodeValue = 34 * this.hashCodeValue + this.unit.getSymbol().hashCode();
    }

    @Override
    public Number value() {
        return this.value;
    }

    public Number value(Unit<ElectricPotential> inUnit) {
        if (this.unit.equals(inUnit)) {
            return this.value;
        }
        if (this.unit.isConvertible(inUnit).booleanValue()) {
            return this.unit.convertValue(this.value, inUnit);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ElectricPotential otherElectricPotential = (ElectricPotential)other;
        if (this.unit.equals(otherElectricPotential.unit)) {
            return this.value.equals(otherElectricPotential.value);
        }
        if (this.unit.isConvertible(otherElectricPotential.unit).booleanValue()) {
            return this.unit.convertValue(this.value, otherElectricPotential.unit).equals(otherElectricPotential.value);
        }
        return false;
    }

    @Override
    public int compareTo(ElectricPotential other) {
        if (this == other) {
            return 0;
        }
        return Double.compare(this.value.doubleValue(), other.value(this.unit).doubleValue());
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        return this.getClass().getName() + ": value[" + this.value + "], unit[" + this.unit.getSymbol() + "] stored as " + this.value.getClass().getName();
    }

    public Unit<ElectricPotential> unit() {
        return this.unit;
    }
}

