/*
 * Decompiled with CFR 0.152.
 */
package fiji;

import fiji.drawing.Linear_Gradient;
import fiji.selection.Select_Bounding_Box;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.Line;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.Image3DUniverse;
import ij3d.ImageCanvas3D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;

public class Prettify_Wiki_Screenshot
implements PlugInFilter {
    public String label = "";

    public int setup(String arg, ImagePlus imp) {
        return 159;
    }

    public void run(ImageProcessor ip) {
        if (!(ip instanceof ColorProcessor)) {
            ImagePlus image = new ImagePlus("", ip);
            new ImageConverter(image).convertToRGB();
            ip = image.getProcessor();
        }
        int h = ip.getHeight();
        ImageProcessor mask = ip.duplicate();
        Line line = new Line(0, 0, 0, h);
        int from = 252;
        int to = 127;
        from = from | from << 8 | from << 16;
        to = to | to << 8 | to << 16;
        Linear_Gradient.makeLinearGradient((ImageProcessor)mask, (int)from, (int)to, (Line)line);
        mask.copyBits(ip, 0, 0, 13);
        mask.flipVertical();
        Image3DUniverse univ = new Image3DUniverse();
        univ.show();
        Content cImage = univ.addOrthoslice(new ImagePlus("screenshot", ip), null, "image", 0, new boolean[]{true, true, true}, 1);
        int dy = -h / 8;
        cImage.setTransform(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, dy, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0});
        Content cMirror = univ.addOrthoslice(new ImagePlus("mirror", mask), null, "mirror", 0, new boolean[]{true, true, true}, 1);
        double cos = 0.0;
        double sin = 1.0;
        cMirror.applyTransform(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, cos, sin, 0.0, 0.0, -sin, cos, 0.0, 0.0, 0.0, 0.0, 1.0});
        cMirror.applyTransform(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, h, 0.0, 0.0, 1.0, dy, 0.0, 0.0, 0.0, 1.0});
        Prettify_Wiki_Screenshot.sleep(1.0);
        univ.rotateY(0.2617993877991494);
        univ.fireTransformationUpdated();
        Prettify_Wiki_Screenshot.sleep(1.0);
        univ.adjustView();
        univ.fireTransformationUpdated();
        float background = 1.0f;
        ImageCanvas3D canvas = (ImageCanvas3D)univ.getCanvas();
        canvas.getBG().setColor(background, background, background);
        int snapshotWidth = 2047;
        ImagePlus snapshot = univ.takeSnapshot(snapshotWidth, snapshotWidth);
        univ.close();
        int w2 = 400;
        int h2 = 400;
        IJ.run((ImagePlus)snapshot, (String)"downsample ", (String)("width=" + w2 + " height=" + h2 + " source=0.50 target=0.50 keep"));
        ImagePlus smallImage = IJ.getImage();
        if (this.label != null && !this.label.equals("")) {
            Prettify_Wiki_Screenshot.drawOutlineText(smallImage.getProcessor(), this.label, 24, 30, smallImage.getHeight() - 30);
        }
        Rectangle rect = Select_Bounding_Box.getBoundingBox((ImageProcessor)smallImage.getProcessor(), null, (double)-1.0);
        Select_Bounding_Box.crop((ImagePlus)smallImage, (Rectangle)rect);
        smallImage.updateAndDraw();
    }

    public static void drawOutlineText(ImageProcessor ip, String string, int size, int x, int y) {
        Font font = new Font("Arial", 1, size);
        int[][] offsets = new int[][]{{-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}, {0, 1}, {-1, 1}};
        int shadowOffset = 3;
        ip.setFont(font);
        ip.setAntialiasedText(true);
        int shadowGray = 64;
        ip.setColor(new Color(shadowGray, shadowGray, shadowGray, 32));
        for (int[] dxy : offsets) {
            ip.drawString(string, x + shadowOffset + dxy[0], y + shadowOffset + dxy[1]);
        }
        ip.setColor(new Color(shadowGray, shadowGray, shadowGray, 64));
        ip.drawString(string, x + shadowOffset, y + shadowOffset);
        ip.setColor(new Color(0, 0, 0, 80));
        for (int[] dxy : offsets) {
            ip.drawString(string, x + dxy[0], y + dxy[1]);
        }
        ip.setColor(new Color(255, 255, 255, 255));
        ip.drawString(string, x, y);
    }

    public static void sleep(double seconds) {
        try {
            Thread.sleep((long)(seconds * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

