/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.python;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import org.scijava.app.AppService;
import org.scijava.command.CommandService;
import org.scijava.launcher.Config;
import org.scijava.log.LogService;
import org.scijava.options.OptionsPlugin;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugins.scripting.python.RebuildEnvironment;
import org.scijava.widget.Button;

@Plugin(type=OptionsPlugin.class, menu={@Menu(label="Edit", weight=1.0, mnemonic=101), @Menu(label="Options", mnemonic=111), @Menu(label="Python...", weight=10.0)})
public class OptionsPython
extends OptionsPlugin {
    @Parameter
    private AppService appService;
    @Parameter
    private CommandService commandService;
    @Parameter
    private LogService log;
    @Parameter(label="Python environment directory", persist=false)
    private File pythonDir;
    @Parameter(label="Rebuild Python environment", callback="rebuildEnv")
    private Button rebuildEnvironment;
    @Parameter(label="Launch in Python mode", callback="updatePythonConfig", persist=false)
    private boolean pythonMode;

    public File getPythonDir() {
        return this.pythonDir;
    }

    public boolean isPythonMode() {
        return this.pythonMode;
    }

    public void setPythonDir(File pythonDir) {
        this.pythonDir = pythonDir;
    }

    public void setPythonMode(boolean pythonMode) {
        this.pythonMode = pythonMode;
    }

    public void load() {
        File configFile;
        String configFileProp = System.getProperty("scijava.app.config-file");
        File file = configFile = configFileProp == null ? null : new File(configFileProp);
        if (configFile != null && configFile.canRead()) {
            try {
                String cfgLaunchMode;
                Map config = Config.load((File)configFile);
                String cfgPythonDir = (String)config.get("python-dir");
                if (cfgPythonDir != null) {
                    Path appPath = this.appService.getApp().getBaseDirectory().toPath();
                    this.pythonDir = OptionsPython.stringToFile(appPath, cfgPythonDir);
                }
                if ((cfgLaunchMode = (String)config.get("launch-mode")) != null) {
                    this.pythonMode = cfgLaunchMode.equals("PYTHON");
                }
            }
            catch (IOException e) {
                this.log.debug((Throwable)e);
            }
        }
        if (this.pythonDir == null) {
            String javaPlatform = System.getProperty("scijava.app.java-platform");
            String platform = javaPlatform != null ? javaPlatform : System.getProperty("os.name") + "-" + System.getProperty("os.arch");
            Path pythonPath = this.appService.getApp().getBaseDirectory().toPath().resolve("python").resolve(platform);
            this.pythonDir = pythonPath.toFile();
        }
    }

    public void rebuildEnv() {
        Path appPath = this.appService.getApp().getBaseDirectory().toPath();
        File environmentYaml = appPath.resolve("config").resolve("environment.yml").toFile();
        String pythonEnvFileProp = System.getProperty("scijava.app.python-env-file");
        if (pythonEnvFileProp != null) {
            environmentYaml = OptionsPython.stringToFile(appPath, pythonEnvFileProp);
        }
        this.commandService.run(RebuildEnvironment.class, true, new Object[]{"environmentYaml", environmentYaml, "targetDir", this.pythonDir});
    }

    public void save() {
        String configFileProp = System.getProperty("scijava.app.config-file");
        if (configFileProp == null) {
            return;
        }
        File configFile = new File(configFileProp);
        LinkedHashMap<String, String> config = null;
        if (configFile.isFile()) {
            try {
                config = Config.load((File)configFile);
            }
            catch (IOException exc) {
                this.log.debug((Throwable)exc);
            }
        }
        if (config == null) {
            config = new LinkedHashMap<String, String>();
        }
        Path appPath = this.appService.getApp().getBaseDirectory().toPath();
        config.put("python-dir", OptionsPython.fileToString(appPath, this.pythonDir));
        config.put("launch-mode", this.pythonMode ? "PYTHON" : "JVM");
        try {
            Config.save((File)configFile, config);
        }
        catch (IOException exc) {
            this.log.debug((Throwable)exc);
        }
    }

    static File stringToFile(Path baseDir, String value) {
        Path path = Paths.get(value, new String[0]);
        Path absPath = path.isAbsolute() ? path : baseDir.resolve(path);
        return absPath.toFile();
    }

    static String fileToString(Path baseDir, File file) {
        Path filePath = file.toPath();
        Path relPath = filePath.startsWith(baseDir) ? baseDir.relativize(filePath) : filePath.toAbsolutePath();
        return relPath.toString();
    }
}

