/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.python;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;
import org.apposed.appose.Appose;
import org.apposed.appose.Builder;
import org.scijava.app.AppService;
import org.scijava.command.Command;
import org.scijava.launcher.Splash;
import org.scijava.log.Logger;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, label="Rebuild Python environment")
public class RebuildEnvironment
implements Command {
    @Parameter
    private AppService appService;
    @Parameter
    private Logger log;
    @Parameter(label="environment definition file")
    private File environmentYaml;
    @Parameter(label="Target directory")
    private File targetDir;

    public void run() {
        File backupDir = new File(this.targetDir.getPath() + ".old");
        if (backupDir.exists()) {
            try (Stream<Path> x = Files.walk(backupDir.toPath(), new FileVisitOption[0]);){
                x.sorted(Comparator.reverseOrder()).forEach(p -> {
                    try {
                        Files.delete(p);
                    }
                    catch (IOException exc) {
                        this.log.error((Throwable)exc);
                    }
                });
            }
            catch (IOException exc) {
                this.log.error((Throwable)exc);
            }
        }
        if (this.targetDir.exists()) {
            this.targetDir.renameTo(backupDir);
        }
        try {
            Builder builder = Appose.file((File)this.environmentYaml, (String)"environment.yml").subscribeOutput(this::report).subscribeError(this::report).subscribeProgress((msg, cur, max) -> Splash.update((String)msg, (double)((double)cur / (double)max)));
            System.err.println("Building Python environment");
            Splash.show();
            builder.build(this.targetDir);
        }
        catch (IOException exc) {
            this.log.error((Object)"Failed to build Python environment", (Throwable)exc);
        }
    }

    private void report(String s) {
        if (s.isEmpty()) {
            System.err.print(".");
        } else {
            System.err.print(s);
        }
    }
}

