/*
 * Decompiled with CFR 0.152.
 */
package fiji.scripting;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Compiler {
    public static String getClasspath() {
        String classPath = System.getProperty("java.class.path");
        if (null == classPath) {
            return "";
        }
        String pluginsPath = System.getProperty("ij.dir") + "/plugins";
        String jarsPath = System.getProperty("ij.dir") + "/jars";
        try {
            if (new File(pluginsPath).exists()) {
                classPath = Compiler.appendToPath(classPath, Compiler.discoverJars(pluginsPath));
            }
            if (new File(jarsPath).exists()) {
                classPath = Compiler.appendToPath(classPath, Compiler.discoverJars(jarsPath));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classPath;
    }

    public static String appendToPath(String path, String append) {
        if (append != null && !path.equals("")) {
            if (!path.equals("")) {
                path = path + File.pathSeparator;
            }
            return path + append;
        }
        return path;
    }

    public static String discoverJars(String path) throws IOException {
        File file;
        if (path.equals(".rsrc") || path.endsWith("/.rsrc")) {
            return "";
        }
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        if ((file = new File(path)).isDirectory()) {
            String result = "";
            String[] paths = file.list();
            for (int i = 0; i < paths.length; ++i) {
                String add = Compiler.discoverJars(path + File.separator + paths[i]);
                if (add == null || add.equals("")) continue;
                if (!result.equals("")) {
                    result = result + File.pathSeparator;
                }
                result = result + add;
            }
            return result;
        }
        if (path.endsWith(".jar")) {
            return path;
        }
        return null;
    }

    public static File getSourceRootDirectory(String path) throws IOException {
        String packageName = Compiler.getPackageName(path);
        File directory = new File(path).getCanonicalFile().getParentFile();
        if (packageName != null) {
            int dot = -1;
            do {
                directory = directory.getParentFile();
            } while ((dot = packageName.indexOf(46, dot + 1)) > 0);
        }
        return directory;
    }

    public static String getPackageName(String path) throws IOException {
        String line;
        FileInputStream in = new FileInputStream(path);
        InputStreamReader streamReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(streamReader);
        boolean multiLineComment = false;
        while ((line = reader.readLine()) != null) {
            int endOfComment;
            if (multiLineComment) {
                endOfComment = line.indexOf("*/");
                if (endOfComment < 0) continue;
                line = line.substring(endOfComment + 2);
                multiLineComment = false;
            }
            line = line.trim();
            while (line.startsWith("/*")) {
                endOfComment = line.indexOf("*/", 2);
                if (endOfComment < 0) {
                    multiLineComment = true;
                    break;
                }
                line = line.substring(endOfComment + 2).trim();
            }
            if (multiLineComment) continue;
            if (line.startsWith("package ")) {
                int endOfPackage = line.indexOf(59);
                if (endOfPackage < 0) break;
                ((InputStream)in).close();
                reader.close();
                return line.substring(8, endOfPackage);
            }
            if (line.equals("") || line.startsWith("//")) continue;
        }
        ((InputStream)in).close();
        return null;
    }

    public static Result compile(String path, String classPath, String rootDir, String outPath, String[] extraArgs) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ByteArrayOutputStream buffer;
        Method javac;
        Object result;
        String[] arguments = new String[]{"-deprecation", "-Xlint:unchecked", "-g", path};
        File root = null;
        try {
            root = Compiler.getSourceRootDirectory(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != root) {
            classPath = root.getPath() + (classPath.equals("") ? "" : File.pathSeparator + classPath);
        }
        if (!classPath.equals("")) {
            arguments = Compiler.unshift(arguments, new String[]{"-classpath", classPath});
        }
        if (outPath != null) {
            arguments = Compiler.unshift(arguments, new String[]{"-d", outPath});
        }
        if ((result = (javac = Compiler.class.getClassLoader().loadClass("com.sun.tools.javac.Main").getMethod("compile", arguments.getClass(), PrintWriter.class)).invoke(null, arguments, new PrintWriter(buffer = new ByteArrayOutputStream()))).equals(new Integer(0))) {
            return new Result(true, "");
        }
        return new Result(false, "Could not compile " + path + ":\n" + buffer.toString());
    }

    protected static String[] unshift(String[] list, String[] add) {
        String[] result = new String[list.length + add.length];
        System.arraycopy(add, 0, result, 0, add.length);
        System.arraycopy(list, 0, result, add.length, list.length);
        return result;
    }

    public static class Result {
        final boolean success;
        final String errorMessage;

        public Result(boolean success, String msg) {
            this.success = success;
            this.errorMessage = msg;
        }
    }
}

