/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;
import fiji.plugin.volumeviewer.Volume;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class TFalpha3
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -1L;
    private int height = 128;
    private int width = 256;
    private int[] pixels;
    private int sampleMean = -1;
    private int sampleDiff = -1;
    private Control control;
    private Volume vol;
    private int[][] lut;
    private final int[][] alpha3back = new int[256][128];
    private final int[][] alpha3 = new int[256][128];
    final int[][] a3 = new int[256][128];
    private int scaleAlpha = 0;
    private int[][][] lut2D_3;
    int count = 0;

    public TFalpha3(Control control, Volume vol, int[][] lut, int[][][] lut2D_3) {
        this.control = control;
        this.vol = vol;
        this.lut = lut;
        this.lut2D_3 = lut2D_3;
        for (int i = 0; i < this.alpha3.length; ++i) {
            for (int j = 0; j < this.alpha3[0].length; ++j) {
                this.alpha3[i][j] = -1000;
            }
        }
        this.setPreferredSize(new Dimension(256, this.height));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.pixels = new int[this.width * this.height];
        this.setAlphaAuto();
    }

    public void setValues(int[] vals) {
        this.sampleMean = vals[2];
        this.sampleDiff = vals[3];
    }

    public void clearAlpha() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < 256; ++x) {
                this.alpha3[x][y] = -1000;
                this.a3[x][y] = 0;
            }
        }
        this.control.alphaWasChanged = true;
    }

    public void scaleAlpha() {
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 128; ++y) {
                int alpha = this.alpha3[x][y];
                alpha = alpha != -1000 ? (alpha += this.scaleAlpha) : 0;
                if (alpha > 255) {
                    alpha = 255;
                } else if (alpha < 0) {
                    alpha = 0;
                }
                this.a3[x][y] = alpha;
            }
        }
        this.control.alphaWasChanged = true;
    }

    void updateLutGradVal() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.lut2D_3[x][y][0] = this.lut[x][0];
                this.lut2D_3[x][y][1] = this.lut[x][1];
                this.lut2D_3[x][y][2] = this.lut[x][2];
            }
        }
    }

    public void setAlphaAuto() {
        float max1 = 0.0f;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < 256; ++x) {
                int val = this.vol.histMeanDiff[x][y];
                if (!((float)val > max1)) continue;
                max1 = val;
            }
        }
        double norm = 1.0 / (double)max1;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < 256; ++x) {
                int val = (int)(510.0 * Math.pow((double)this.vol.histMeanDiff[x][y] * norm, 0.22));
                this.alpha3[x][y] = y > 5 ? 128 - val : -1000;
                if (val > 255) {
                    val = 255;
                }
                this.alpha3back[x][y] = 255 - val;
            }
        }
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 128; ++y) {
                this.a3[x][y] = this.alpha3[x][y] != -1000 ? Math.min(Math.max(0, this.alpha3[x][y] + this.scaleAlpha), 255) : 0;
                this.lut2D_3[x][y][0] = this.lut[x][0];
                this.lut2D_3[x][y][1] = this.lut[x][1];
                this.lut2D_3[x][y][2] = this.lut[x][2];
            }
        }
        this.control.alphaWasChanged = true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handleMouseDragged(e);
        this.control.drag = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.control.drag = false;
        this.control.newDisplayMode();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.handleMouseDragged(e);
        if (this.count++ % 10 == 0) {
            this.control.newDisplayMode();
        }
    }

    public void handleMouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x > 255) {
            x = 255;
        }
        if (y > this.height) {
            y = this.height - 1;
        }
        y = this.height - 1 - y;
        int v = this.control.alphaPaint3;
        if (e.isAltDown()) {
            v = 0;
        }
        for (int y_ = Math.max(0, y - 6); y_ <= Math.min(y + 6, this.height - 1); ++y_) {
            for (int x_ = Math.max(0, x - 6); x_ <= Math.min(x + 6, 255); ++x_) {
                this.a3[x_][y_] = v;
                this.alpha3[x_][y_] = v > 0 ? v - this.scaleAlpha : -1000;
                if (this.control.pickColor) {
                    this.lut2D_3[x_][y_][0] = this.control.rPaint;
                    this.lut2D_3[x_][y_][1] = this.control.gPaint;
                    this.lut2D_3[x_][y_][2] = this.control.bPaint;
                    continue;
                }
                this.lut2D_3[x_][y_][0] = this.lut[x_][0];
                this.lut2D_3[x_][y_][1] = this.lut[x_][1];
                this.lut2D_3[x_][y_][2] = this.lut[x_][2];
            }
        }
        this.control.alphaWasChanged = true;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        int x;
        Graphics2D g2 = (Graphics2D)g;
        int width = 256;
        for (x = 0; x < width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int pos = (this.height - 1 - y) * width + x;
                int valBack = this.alpha3back[x][y];
                int valA = (int)Math.min(255.0, (double)this.a3[x][y] * 1.6);
                int val_A = 255 - valA;
                int valTR = this.lut2D_3[x][y][0];
                int valTG = this.lut2D_3[x][y][1];
                int valTB = this.lut2D_3[x][y][2];
                if (this.control.lutNr == 1 || this.control.lutNr == 0) {
                    valTR = 255;
                    valTG = 128;
                    valTB = 0;
                }
                int valR = valBack;
                int valG = valBack;
                int valB = valBack;
                if (valBack < 255) {
                    valR = val_A * valBack + valA * valTR >> 8;
                    valG = val_A * valBack + valA * valTG >> 8;
                    valB = val_A * valBack + valA * valTB >> 8;
                }
                this.pixels[pos] = 0xFF000000 | valR << 16 | valG << 8 | valB;
            }
        }
        if (this.sampleMean >= 0 && this.sampleDiff >= 0) {
            int pos;
            for (int y = 0; y < this.height; ++y) {
                pos = y * width + this.sampleMean;
                this.pixels[pos] = -14769409;
            }
            for (x = 0; x < width; ++x) {
                pos = (this.height - 1 - this.sampleDiff) * width + x;
                this.pixels[pos] = -14769409;
            }
        }
        BufferedImage image = new BufferedImage(width, this.height, 2);
        image.setRGB(0, 0, width, this.height, this.pixels, 0, width);
        g2.drawImage((Image)image, 0, 0, null);
    }

    public void setAlphaOffset(int scaleAlpha3) {
        this.scaleAlpha = scaleAlpha3;
    }
}

