/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;
import fiji.plugin.volumeviewer.Volume_Viewer;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ImageProcessor;

public class Volume {
    int widthV;
    int heightV;
    int depthV;
    float xOffa;
    float yOffa;
    float zOffa;
    byte[][][][] data3D = null;
    byte[][][] grad3D = null;
    byte[][][] mean3D = null;
    byte[][][] diff3D = null;
    byte[][][] col_3D = null;
    byte[][][] aPaint_3D = null;
    byte[][][] aPaint_3D2 = null;
    byte[][][] nx_3D = null;
    byte[][][] ny_3D = null;
    byte[][][] nz_3D = null;
    private double a = 0.0;
    private double b = 1.0;
    private double min;
    private double max;
    boolean firstTime = true;
    int[][] histValGrad = new int[256][128];
    int[][] histMeanDiff = new int[256][128];
    int[] histVal = new int[256];
    private ImageProcessor ip;
    private Control control;
    private ImagePlus imp;
    private Volume_Viewer vv;
    private static final byte YES = 1;

    public Volume(Control control, Volume_Viewer vv) {
        this.control = control;
        this.vv = vv;
        this.imp = vv.imp;
        this.ip = this.imp.getProcessor();
        this.widthV = this.imp.getWidth();
        this.heightV = this.imp.getHeight();
        this.depthV = this.imp.getStackSize();
        this.data3D = control.isRGB ? new byte[4][this.depthV + 4][this.heightV + 4][this.widthV + 4] : new byte[1][this.depthV + 4][this.heightV + 4][this.widthV + 4];
        this.grad3D = new byte[this.depthV + 4][this.heightV + 4][this.widthV + 4];
        this.mean3D = new byte[this.depthV + 4][this.heightV + 4][this.widthV + 4];
        this.diff3D = new byte[this.depthV + 4][this.heightV + 4][this.widthV + 4];
        this.aPaint_3D2 = new byte[this.depthV + 4][this.heightV + 4][this.widthV + 4];
        this.aPaint_3D = new byte[this.depthV + 4][this.heightV + 4][this.widthV + 4];
        this.col_3D = new byte[this.depthV + 4][this.heightV + 4][this.widthV + 4];
        this.nx_3D = new byte[this.depthV + 4][this.heightV + 4][this.widthV + 4];
        this.ny_3D = new byte[this.depthV + 4][this.heightV + 4][this.widthV + 4];
        this.nz_3D = new byte[this.depthV + 4][this.heightV + 4][this.widthV + 4];
        this.xOffa = (float)this.widthV / 2.0f;
        this.yOffa = (float)this.heightV / 2.0f;
        this.zOffa = (float)this.depthV / 2.0f;
        this.getMinMax();
        this.readVolumeData();
    }

    void getMinMax() {
        this.min = this.ip.getMin();
        this.max = this.ip.getMax();
        Calibration cal = this.imp.getCalibration();
        if (cal != null) {
            if (cal.calibrated()) {
                this.min = cal.getCValue((int)this.min);
                this.max = cal.getCValue((int)this.max);
                double[] coef = cal.getCoefficients();
                if (coef != null) {
                    this.a = coef[0];
                    this.b = coef[1];
                }
            }
            if (this.control.zAspect == 1.0f) {
                this.control.zAspect = (float)(cal.pixelDepth / cal.pixelWidth);
            }
        }
        if (this.control.zAspect == 0.0f) {
            this.control.zAspect = 1.0f;
        }
    }

    private void readVolumeData() {
        int val;
        if (this.control.LOG) {
            System.out.println("Read data");
        }
        ImageStack stack = this.imp.getStack();
        int bitDepth = this.imp.getBitDepth();
        if (bitDepth == 8 || bitDepth == 16 || bitDepth == 32) {
            float scale = (float)(255.0 / (this.max - this.min));
            for (int z = 1; z <= this.depthV; ++z) {
                IJ.showStatus((String)("Reading stack, slice: " + z + "/" + this.depthV));
                IJ.showProgress((double)(0.6 * (double)z / (double)this.depthV));
                byte[] bytePixels = null;
                short[] shortPixels = null;
                float[] floatPixels = null;
                if (bitDepth == 8) {
                    bytePixels = (byte[])stack.getPixels(z);
                } else if (bitDepth == 16) {
                    shortPixels = (short[])stack.getPixels(z);
                } else if (bitDepth == 32) {
                    floatPixels = (float[])stack.getPixels(z);
                }
                int pos = 0;
                for (int y = 2; y < this.heightV + 2; ++y) {
                    for (int x = 2; x < this.widthV + 2; ++x) {
                        int val2;
                        if (bitDepth == 32) {
                            float value = (float)((double)floatPixels[pos++] - this.min);
                            val2 = (int)(value * scale);
                        } else if (bitDepth == 16) {
                            val2 = (int)((double)(0xFFFF & shortPixels[pos++]) * this.b + this.a - this.min);
                            val2 = (int)((float)val2 * scale);
                        } else {
                            val2 = 0xFF & bytePixels[pos++];
                            val2 = (int)(((double)val2 - this.min) * (double)scale);
                        }
                        if ((float)val2 < 0.0f) {
                            val2 = 0;
                        }
                        if (val2 > 255) {
                            val2 = 255;
                        }
                        this.data3D[0][z + 1][y][x] = (byte)val2;
                    }
                    byte by = this.data3D[0][z + 1][y][2];
                    this.data3D[0][z + 1][y][1] = by;
                    this.data3D[0][z + 1][y][0] = by;
                    byte by2 = this.data3D[0][z + 1][y][this.widthV + 1];
                    this.data3D[0][z + 1][y][this.widthV + 2] = by2;
                    this.data3D[0][z + 1][y][this.widthV + 3] = by2;
                }
                for (int x = 0; x < this.widthV + 4; ++x) {
                    byte by = this.data3D[0][z + 1][2][x];
                    this.data3D[0][z + 1][1][x] = by;
                    this.data3D[0][z + 1][0][x] = by;
                    byte by3 = this.data3D[0][z + 1][this.heightV + 1][x];
                    this.data3D[0][z + 1][this.heightV + 2][x] = by3;
                    this.data3D[0][z + 1][this.heightV + 3][x] = by3;
                }
            }
            for (int y = 0; y < this.heightV + 4; ++y) {
                for (int x = 0; x < this.widthV + 4; ++x) {
                    byte by = this.data3D[0][this.depthV + 1][y][x];
                    this.data3D[0][this.depthV + 2][y][x] = by;
                    this.data3D[0][this.depthV + 3][y][x] = by;
                    byte by4 = this.data3D[0][2][y][x];
                    this.data3D[0][1][y][x] = by4;
                    this.data3D[0][0][y][x] = by4;
                }
            }
        } else if (bitDepth == 24) {
            for (int z = 1; z <= this.depthV; ++z) {
                IJ.showStatus((String)("Reading stack, slice: " + z + "/" + this.depthV));
                IJ.showProgress((double)(0.6 * (double)z / (double)this.depthV));
                int[] pixels = (int[])stack.getPixels(z);
                int pos = 0;
                for (int y = 2; y < this.heightV + 2; ++y) {
                    for (int x = 2; x < this.widthV + 2; ++x) {
                        val = pixels[pos++];
                        int r = val >> 16 & 0xFF;
                        int g = val >> 8 & 0xFF;
                        int b = val & 0xFF;
                        this.data3D[1][z + 1][y][x] = (byte)r;
                        this.data3D[2][z + 1][y][x] = (byte)g;
                        this.data3D[3][z + 1][y][x] = (byte)b;
                        this.data3D[0][z + 1][y][x] = (byte)(r + 2 * g + b >> 2);
                    }
                    byte by = this.data3D[0][z + 1][y][2];
                    this.data3D[0][z + 1][y][1] = by;
                    this.data3D[0][z + 1][y][0] = by;
                    byte by5 = this.data3D[1][z + 1][y][2];
                    this.data3D[1][z + 1][y][1] = by5;
                    this.data3D[1][z + 1][y][0] = by5;
                    byte by6 = this.data3D[2][z + 1][y][2];
                    this.data3D[2][z + 1][y][1] = by6;
                    this.data3D[2][z + 1][y][0] = by6;
                    byte by7 = this.data3D[3][z + 1][y][2];
                    this.data3D[3][z + 1][y][1] = by7;
                    this.data3D[3][z + 1][y][0] = by7;
                    byte by8 = this.data3D[0][z + 1][y][this.widthV + 1];
                    this.data3D[0][z + 1][y][this.widthV + 2] = by8;
                    this.data3D[0][z + 1][y][this.widthV + 3] = by8;
                    byte by9 = this.data3D[1][z + 1][y][this.widthV + 1];
                    this.data3D[1][z + 1][y][this.widthV + 2] = by9;
                    this.data3D[1][z + 1][y][this.widthV + 3] = by9;
                    byte by10 = this.data3D[2][z + 1][y][this.widthV + 1];
                    this.data3D[2][z + 1][y][this.widthV + 2] = by10;
                    this.data3D[2][z + 1][y][this.widthV + 3] = by10;
                    byte by11 = this.data3D[3][z + 1][y][this.widthV + 1];
                    this.data3D[3][z + 1][y][this.widthV + 2] = by11;
                    this.data3D[3][z + 1][y][this.widthV + 3] = by11;
                }
                for (int x = 0; x < this.widthV + 4; ++x) {
                    byte by = this.data3D[0][z + 1][2][x];
                    this.data3D[0][z + 1][1][x] = by;
                    this.data3D[0][z + 1][0][x] = by;
                    byte by12 = this.data3D[1][z + 1][2][x];
                    this.data3D[1][z + 1][1][x] = by12;
                    this.data3D[1][z + 1][0][x] = by12;
                    byte by13 = this.data3D[2][z + 1][2][x];
                    this.data3D[2][z + 1][1][x] = by13;
                    this.data3D[2][z + 1][0][x] = by13;
                    byte by14 = this.data3D[3][z + 1][2][x];
                    this.data3D[3][z + 1][1][x] = by14;
                    this.data3D[3][z + 1][0][x] = by14;
                    byte by15 = this.data3D[0][z + 1][this.heightV + 1][x];
                    this.data3D[0][z + 1][this.heightV + 2][x] = by15;
                    this.data3D[0][z + 1][this.heightV + 3][x] = by15;
                    byte by16 = this.data3D[1][z + 1][this.heightV + 1][x];
                    this.data3D[1][z + 1][this.heightV + 2][x] = by16;
                    this.data3D[1][z + 1][this.heightV + 3][x] = by16;
                    byte by17 = this.data3D[2][z + 1][this.heightV + 1][x];
                    this.data3D[2][z + 1][this.heightV + 2][x] = by17;
                    this.data3D[2][z + 1][this.heightV + 3][x] = by17;
                    byte by18 = this.data3D[3][z + 1][this.heightV + 1][x];
                    this.data3D[3][z + 1][this.heightV + 2][x] = by18;
                    this.data3D[3][z + 1][this.heightV + 3][x] = by18;
                }
            }
            for (int y = 0; y < this.heightV + 4; ++y) {
                for (int x = 0; x < this.widthV + 4; ++x) {
                    byte by = this.data3D[0][this.depthV + 1][y][x];
                    this.data3D[0][this.depthV + 2][y][x] = by;
                    this.data3D[0][this.depthV + 3][y][x] = by;
                    byte by19 = this.data3D[1][this.depthV + 1][y][x];
                    this.data3D[1][this.depthV + 2][y][x] = by19;
                    this.data3D[1][this.depthV + 3][y][x] = by19;
                    byte by20 = this.data3D[2][this.depthV + 1][y][x];
                    this.data3D[2][this.depthV + 2][y][x] = by20;
                    this.data3D[2][this.depthV + 3][y][x] = by20;
                    byte by21 = this.data3D[3][this.depthV + 1][y][x];
                    this.data3D[3][this.depthV + 2][y][x] = by21;
                    this.data3D[3][this.depthV + 3][y][x] = by21;
                    byte by22 = this.data3D[0][2][y][x];
                    this.data3D[0][1][y][x] = by22;
                    this.data3D[0][0][y][x] = by22;
                    byte by23 = this.data3D[1][2][y][x];
                    this.data3D[1][1][y][x] = by23;
                    this.data3D[1][0][y][x] = by23;
                    byte by24 = this.data3D[2][2][y][x];
                    this.data3D[2][1][y][x] = by24;
                    this.data3D[2][0][y][x] = by24;
                    byte by25 = this.data3D[3][2][y][x];
                    this.data3D[3][1][y][x] = by25;
                    this.data3D[3][0][y][x] = by25;
                }
            }
        }
        int[] va = new int[7];
        int[] vb = new int[7];
        for (int z = 2; z < this.depthV + 2; ++z) {
            IJ.showStatus((String)("Analyzing stack, slice: " + (z - 1) + "/" + this.depthV));
            IJ.showProgress((double)(0.6 + 0.4 * (double)z / (double)this.depthV));
            for (int y = 2; y < this.heightV + 2; ++y) {
                for (int x = 2; x < this.widthV + 2; ++x) {
                    int high;
                    int low;
                    val = 0xFF & this.data3D[0][z][y][x];
                    va[0] = 0xFF & this.data3D[0][z - 1][y][x];
                    vb[0] = 0xFF & this.data3D[0][z + 1][y][x];
                    va[1] = 0xFF & this.data3D[0][z][y - 1][x];
                    vb[1] = 0xFF & this.data3D[0][z][y + 1][x];
                    va[2] = 0xFF & this.data3D[0][z][y][x - 1];
                    vb[2] = 0xFF & this.data3D[0][z][y][x + 1];
                    va[3] = 0xFF & this.data3D[0][z - 1][y - 1][x - 1];
                    vb[3] = 0xFF & this.data3D[0][z + 1][y + 1][x + 1];
                    va[4] = 0xFF & this.data3D[0][z - 1][y + 1][x - 1];
                    vb[4] = 0xFF & this.data3D[0][z + 1][y - 1][x + 1];
                    va[5] = 0xFF & this.data3D[0][z - 1][y - 1][x + 1];
                    vb[5] = 0xFF & this.data3D[0][z + 1][y + 1][x - 1];
                    va[6] = 0xFF & this.data3D[0][z - 1][y + 1][x + 1];
                    vb[6] = 0xFF & this.data3D[0][z + 1][y - 1][x - 1];
                    int grad = 0;
                    int dMax = 0;
                    int iMax = 0;
                    for (int i = 0; i < vb.length; ++i) {
                        int d = Math.abs(va[i] - vb[i]);
                        grad += d;
                        if (d <= dMax) continue;
                        dMax = d;
                        iMax = i;
                    }
                    if (va[iMax] < vb[iMax]) {
                        low = va[iMax];
                        high = vb[iMax];
                    } else {
                        low = vb[iMax];
                        high = va[iMax];
                    }
                    if ((grad /= 7) > 127) {
                        grad = 127;
                    }
                    this.grad3D[z][y][x] = (byte)grad;
                    int[] nArray = this.histValGrad[val];
                    int n = grad;
                    nArray[n] = nArray[n] + 1;
                    int n2 = val;
                    this.histVal[n2] = this.histVal[n2] + 1;
                    int mean = (int)Math.max(0.0, Math.min(255.0, (double)(low + high) * 0.5));
                    int diff = (int)Math.max(0.0, Math.min(127.0, (double)(high - low) * 0.5));
                    this.mean3D[z][y][x] = (byte)mean;
                    this.diff3D[z][y][x] = (byte)diff;
                    int[] nArray2 = this.histMeanDiff[mean];
                    int n3 = diff;
                    nArray2[n3] = nArray2[n3] + 1;
                }
            }
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"");
    }

    void calculateGradients() {
        int a220;
        int a210;
        int a200;
        int a120;
        int a110;
        int a100;
        int a020;
        int a010;
        int a000;
        int x;
        int a222;
        int a212;
        int a202;
        int a221;
        int a211;
        int a201;
        int a122;
        int a112;
        int a102;
        int a121;
        int a111;
        int a101;
        int a022;
        int a012;
        int a002;
        int a021;
        int a011;
        int a001;
        int val;
        int x2;
        int y;
        int z;
        this.control.alphaWasChanged = false;
        byte[][][] alpha_3D = new byte[this.depthV + 4][this.heightV + 4][this.widthV + 4];
        byte[][][] alpha_3D_smooth = new byte[this.depthV + 4][this.heightV + 4][this.widthV + 4];
        long start = 0L;
        if (this.control.LOG) {
            IJ.log((String)"Calculate Gradients ");
            start = System.currentTimeMillis();
        }
        if (this.control.alphaMode == 0) {
            for (z = 2; z < this.depthV + 2; ++z) {
                for (y = 2; y < this.heightV + 2; ++y) {
                    for (x2 = 2; x2 < this.widthV + 2; ++x2) {
                        val = this.data3D[0][z][y][x2] & 0xFF;
                        alpha_3D[z][y][x2] = (byte)(this.vv.a1_R[val] * 255.0f);
                    }
                }
            }
        } else if (this.control.alphaMode == 1) {
            for (z = 2; z < this.depthV + 2; ++z) {
                for (y = 2; y < this.heightV + 2; ++y) {
                    for (x2 = 2; x2 < this.widthV + 2; ++x2) {
                        val = this.data3D[0][z][y][x2] & 0xFF;
                        int grad = this.grad3D[z][y][x2] & 0xFF;
                        alpha_3D[z][y][x2] = (byte)(this.vv.a2_R[val][grad] * 255.0f);
                    }
                }
            }
        } else if (this.control.alphaMode == 2) {
            for (z = 2; z < this.depthV + 2; ++z) {
                for (y = 2; y < this.heightV + 2; ++y) {
                    for (x2 = 2; x2 < this.widthV + 2; ++x2) {
                        val = this.mean3D[z][y][x2] & 0xFF;
                        int diff = this.diff3D[z][y][x2] & 0xFF;
                        alpha_3D[z][y][x2] = (byte)(this.vv.a3_R[val][diff] * 255.0f);
                    }
                }
            }
        } else if (this.control.alphaMode == 3) {
            for (z = 2; z < this.depthV + 2; ++z) {
                for (y = 2; y < this.heightV + 2; ++y) {
                    for (x2 = 2; x2 < this.widthV + 2; ++x2) {
                        alpha_3D[z][y][x2] = this.aPaint_3D[z][y][x2];
                    }
                }
            }
        }
        for (z = 1; z < this.depthV + 3; ++z) {
            for (y = 1; y < this.heightV + 3; ++y) {
                a001 = 0xFF & alpha_3D[z - 1][y - 1][0];
                a011 = 0xFF & alpha_3D[z - 1][y][0];
                a021 = 0xFF & alpha_3D[z - 1][y + 1][0];
                a002 = 0xFF & alpha_3D[z - 1][y - 1][1];
                a012 = 0xFF & alpha_3D[z - 1][y][1];
                a022 = 0xFF & alpha_3D[z - 1][y + 1][1];
                a101 = 0xFF & alpha_3D[z][y - 1][0];
                a111 = 0xFF & alpha_3D[z][y][0];
                a121 = 0xFF & alpha_3D[z][y + 1][0];
                a102 = 0xFF & alpha_3D[z][y - 1][1];
                a112 = 0xFF & alpha_3D[z][y][1];
                a122 = 0xFF & alpha_3D[z][y + 1][1];
                a201 = 0xFF & alpha_3D[z + 1][y - 1][0];
                a211 = 0xFF & alpha_3D[z + 1][y][0];
                a221 = 0xFF & alpha_3D[z + 1][y + 1][0];
                a202 = 0xFF & alpha_3D[z + 1][y - 1][1];
                a212 = 0xFF & alpha_3D[z + 1][y][1];
                a222 = 0xFF & alpha_3D[z + 1][y + 1][1];
                for (x = 1; x < this.widthV + 3; ++x) {
                    a000 = a001;
                    a010 = a011;
                    a020 = a021;
                    a001 = a002;
                    a011 = a012;
                    a021 = a022;
                    a002 = 0xFF & alpha_3D[z - 1][y - 1][x + 1];
                    a012 = 0xFF & alpha_3D[z - 1][y][x + 1];
                    a022 = 0xFF & alpha_3D[z - 1][y + 1][x + 1];
                    a100 = a101;
                    a110 = a111;
                    a120 = a121;
                    a101 = a102;
                    a111 = a112;
                    a121 = a122;
                    a102 = 0xFF & alpha_3D[z][y - 1][x + 1];
                    a112 = 0xFF & alpha_3D[z][y][x + 1];
                    a122 = 0xFF & alpha_3D[z][y + 1][x + 1];
                    a200 = a201;
                    a210 = a211;
                    a220 = a221;
                    a201 = a202;
                    a211 = a212;
                    a221 = a222;
                    a202 = 0xFF & alpha_3D[z + 1][y - 1][x + 1];
                    a212 = 0xFF & alpha_3D[z + 1][y][x + 1];
                    a222 = 0xFF & alpha_3D[z + 1][y + 1][x + 1];
                    int a = a000 + a001 + a002 + a010 + a011 + a012 + a020 + a021 + a022 + a100 + a101 + a102 + a110 + a111 + a112 + a120 + a121 + a122 + a200 + a201 + a202 + a210 + a211 + a212 + a220 + a221 + a222 >> 5;
                    alpha_3D_smooth[z][y][x] = (byte)a;
                }
            }
        }
        for (z = 1; z < this.depthV + 3; ++z) {
            for (y = 1; y < this.heightV + 3; ++y) {
                a001 = 0xFF & alpha_3D_smooth[z - 1][y - 1][0];
                a011 = 0xFF & alpha_3D_smooth[z - 1][y][0];
                a021 = 0xFF & alpha_3D_smooth[z - 1][y + 1][0];
                a002 = 0xFF & alpha_3D_smooth[z - 1][y - 1][1];
                a012 = 0xFF & alpha_3D_smooth[z - 1][y][1];
                a022 = 0xFF & alpha_3D_smooth[z - 1][y + 1][1];
                a101 = 0xFF & alpha_3D_smooth[z][y - 1][0];
                a111 = 0xFF & alpha_3D_smooth[z][y][0];
                a121 = 0xFF & alpha_3D_smooth[z][y + 1][0];
                a102 = 0xFF & alpha_3D_smooth[z][y - 1][1];
                a112 = 0xFF & alpha_3D_smooth[z][y][1];
                a122 = 0xFF & alpha_3D_smooth[z][y + 1][1];
                a201 = 0xFF & alpha_3D_smooth[z + 1][y - 1][0];
                a211 = 0xFF & alpha_3D_smooth[z + 1][y][0];
                a221 = 0xFF & alpha_3D_smooth[z + 1][y + 1][0];
                a202 = 0xFF & alpha_3D_smooth[z + 1][y - 1][1];
                a212 = 0xFF & alpha_3D_smooth[z + 1][y][1];
                a222 = 0xFF & alpha_3D_smooth[z + 1][y + 1][1];
                for (x = 1; x < this.widthV + 3; ++x) {
                    a000 = a001;
                    a010 = a011;
                    a020 = a021;
                    a001 = a002;
                    a011 = a012;
                    a021 = a022;
                    a002 = 0xFF & alpha_3D_smooth[z - 1][y - 1][x + 1];
                    a012 = 0xFF & alpha_3D_smooth[z - 1][y][x + 1];
                    a022 = 0xFF & alpha_3D_smooth[z - 1][y + 1][x + 1];
                    a100 = a101;
                    a110 = a111;
                    a120 = a121;
                    a101 = a102;
                    a111 = a112;
                    a121 = a122;
                    a102 = 0xFF & alpha_3D_smooth[z][y - 1][x + 1];
                    a112 = 0xFF & alpha_3D_smooth[z][y][x + 1];
                    a122 = 0xFF & alpha_3D_smooth[z][y + 1][x + 1];
                    a200 = a201;
                    a210 = a211;
                    a220 = a221;
                    a201 = a202;
                    a211 = a212;
                    a221 = a222;
                    a202 = 0xFF & alpha_3D_smooth[z + 1][y - 1][x + 1];
                    a212 = 0xFF & alpha_3D_smooth[z + 1][y][x + 1];
                    a222 = 0xFF & alpha_3D_smooth[z + 1][y + 1][x + 1];
                    int dx = (a002 + a012 + a022 + a102 + a112 + a122 + a202 + a212 + a222 >> 2) - (a000 + a010 + a020 + a100 + a110 + a120 + a200 + a210 + a220 >> 2);
                    int dy = (a020 + a021 + a022 + a120 + a121 + a122 + a220 + a221 + a222 >> 2) - (a000 + a001 + a002 + a100 + a101 + a102 + a200 + a201 + a202 >> 2);
                    int dz = (a200 + a201 + a202 + a210 + a211 + a212 + a220 + a221 + a222 >> 2) - (a000 + a001 + a002 + a010 + a011 + a012 + a020 + a021 + a022 >> 2);
                    this.nx_3D[z][y][x] = (byte)(Math.max(-127, Math.min(127, dx)) + 128);
                    this.ny_3D[z][y][x] = (byte)(Math.max(-127, Math.min(127, dy)) + 128);
                    this.nz_3D[z][y][x] = (byte)(Math.max(-127, Math.min(127, dz)) + 128);
                }
            }
        }
        alpha_3D = null;
        alpha_3D_smooth = null;
        if (this.control.LOG) {
            long end = System.currentTimeMillis();
            System.out.println("  Execution time " + (end - start) + " ms.");
        }
    }

    void findAndSetSimilarInVolume(int lum, int alpha, int z0, int y0, int x0) {
        int width = this.vv.vol.widthV + 4;
        int height = this.vv.vol.heightV + 4;
        int depth = this.vv.vol.depthV + 4;
        byte[][][] data = this.vv.vol.data3D[0];
        this.control.alphaWasChanged = true;
        int regionSize = 1;
        int pointsInQueue = 0;
        int queueArrayLength = 40000;
        int[] queue = new int[queueArrayLength];
        byte[] hasBeenProcessed = new byte[depth * width * height];
        this.setAlphaAndColorInVolume(alpha, z0, y0, x0);
        int i = width * (z0 * height + y0) + x0;
        hasBeenProcessed[i] = 1;
        queue[pointsInQueue++] = i;
        while (pointsInQueue > 0) {
            int nextIndex = queue[--pointsInQueue];
            int pz = nextIndex / (width * height);
            int currentSliceIndex = nextIndex % (width * height);
            int py = currentSliceIndex / width;
            int px = currentSliceIndex % width;
            for (int k = 0; k < 6; ++k) {
                int grad;
                int neighbourValue;
                int diff;
                int x = px;
                int y = py;
                int z = pz;
                if (k == 0) {
                    x = Math.max(0, x - 1);
                } else if (k == 1) {
                    x = Math.min(width - 1, x + 1);
                } else if (k == 2) {
                    y = Math.max(0, y - 1);
                } else if (k == 3) {
                    y = Math.min(height - 1, y + 1);
                } else if (k == 4) {
                    z = Math.max(0, z - 1);
                } else if (k == 5) {
                    z = Math.min(depth - 1, z + 1);
                }
                this.col_3D[z][y][x] = (byte)this.control.indexPaint;
                int newPointStateIndex = width * (z * height + y) + x;
                if (hasBeenProcessed[newPointStateIndex] == 1 || (diff = Math.abs((neighbourValue = data[z][y][x] & 0xFF) - lum)) > this.control.lumTolerance || (grad = this.vv.vol.grad3D[z][y][x] & 0xFF) > this.control.gradTolerance) continue;
                ++regionSize;
                this.setAlphaAndColorInVolume(alpha, z, y, x);
                hasBeenProcessed[newPointStateIndex] = 1;
                if (pointsInQueue == queueArrayLength) {
                    int newArrayLength = queueArrayLength * 2;
                    int[] newArray = new int[newArrayLength];
                    System.arraycopy(queue, 0, newArray, 0, pointsInQueue);
                    queue = newArray;
                    queueArrayLength = newArrayLength;
                }
                queue[pointsInQueue++] = newPointStateIndex;
            }
        }
        if (regionSize < 100) {
            IJ.error((String)("Found only " + regionSize + " connected voxel(s).\n Try changing the tolerance values."));
        }
    }

    private void setAlphaAndColorInVolume(int alpha, int z, int y, int x) {
        this.vv.vol.aPaint_3D[z][y][x] = (byte)alpha;
        if (alpha > 0) {
            int a = alpha - this.vv.tf_a4.getAlphaOffset();
            a = Math.min(254, Math.max(-254, a));
            this.aPaint_3D2[z][y][x] = (byte)(a / 2);
        } else {
            this.aPaint_3D2[z][y][x] = 0;
        }
        this.col_3D[z][y][x] = (byte)this.control.indexPaint;
    }
}

