/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Iterator;

public class Align_Image
implements PlugIn {
    private boolean isSupported(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public void run(String arg) {
        int[] ids = WindowManager.getIDList();
        if (null == ids) {
            return;
        }
        ArrayList<Integer> validIDs = new ArrayList<Integer>();
        ArrayList<ImagePlus> validImages = new ArrayList<ImagePlus>();
        for (int i = 0; i < ids.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)ids[i]);
            Roi roi = imp.getRoi();
            if (!(roi instanceof Line) || !this.isSupported(imp.getType())) continue;
            validIDs.add(ids[i]);
            validImages.add(imp);
        }
        if (validImages.size() < 2) {
            IJ.showMessage((String)"Need 2 images with a line roi in each.\nImages must be 8, 16 or 32-bit.");
            return;
        }
        String[] titles = new String[validImages.size()];
        int k = 0;
        Iterator it = validImages.iterator();
        while (it.hasNext()) {
            titles[k++] = ((ImagePlus)it.next()).getTitle();
        }
        GenericDialog gd = new GenericDialog("Align Images");
        String current = WindowManager.getCurrentImage().getTitle();
        gd.addChoice("source", titles, current.equals(titles[0]) ? titles[1] : titles[0]);
        gd.addChoice("target", titles, current);
        gd.addCheckbox("scale", true);
        gd.addCheckbox("rotate", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int sourceIndex = gd.getNextChoiceIndex();
        ImagePlus source = WindowManager.getImage((int)((Integer)validIDs.get(sourceIndex)));
        Line line1 = (Line)source.getRoi();
        int targetIndex = gd.getNextChoiceIndex();
        ImagePlus target = WindowManager.getImage((int)((Integer)validIDs.get(targetIndex)));
        Line line2 = (Line)target.getRoi();
        boolean withScaling = gd.getNextBoolean();
        boolean withRotation = gd.getNextBoolean();
        ImageProcessor result = Align_Image.align(source.getProcessor(), line1, target.getProcessor(), line2, withScaling, withRotation);
        ImagePlus imp = new ImagePlus(source.getTitle() + " aligned to " + target.getTitle(), result);
        imp.setCalibration(source.getCalibration());
        imp.setRoi((Roi)line2);
        imp.show();
    }

    public static ImageProcessor align(ImageProcessor source, Line line1, ImageProcessor target, Line line2) {
        return Align_Image.align(source, line1, target, line2, true, true);
    }

    public static ImageProcessor align(ImageProcessor source, Line line1, ImageProcessor target, Line line2, boolean withScaling, boolean withRotation) {
        float a00;
        float a11;
        float a10;
        float a01;
        int w = target.getWidth();
        int h = target.getHeight();
        if (source instanceof ColorProcessor) {
            ColorProcessor cp = (ColorProcessor)source;
            int sourceWidth = source.getWidth();
            int sourceHeight = source.getHeight();
            byte[][] channels = new byte[3][sourceWidth * sourceHeight];
            cp.getRGB(channels[0], channels[1], channels[2]);
            for (int i = 0; i < 3; ++i) {
                ByteProcessor unaligned = new ByteProcessor(sourceWidth, sourceHeight, channels[i], null);
                ImageProcessor aligned = Align_Image.align((ImageProcessor)unaligned, line1, target, line2, withScaling, withRotation);
                aligned.setMinAndMax(0.0, 255.0);
                channels[i] = (byte[])aligned.convertToByte(true).getPixels();
            }
            cp = new ColorProcessor(w, h);
            cp.setRGB(channels[0], channels[1], channels[2]);
            return cp;
        }
        FloatProcessor result = new FloatProcessor(w, h);
        float[] pixels = (float[])result.getPixels();
        BilinearInterpolator inter = new BilinearInterpolator(source);
        float dx1 = line1.x2 - line1.x1;
        float dy1 = line1.y2 - line1.y1;
        float dx2 = line2.x2 - line2.x1;
        float dy2 = line2.y2 - line2.y1;
        if (!withRotation) {
            a01 = 0.0f;
            a10 = 0.0f;
            if (withScaling && (dx2 != 0.0f || dy2 != 0.0f)) {
                float length1 = dx1 * dx1 + dy1 * dy1;
                float length2 = dx2 * dx2 + dy2 * dy2;
                a00 = a11 = (float)Math.sqrt(length1 / length2);
            } else {
                a11 = 1.0f;
                a00 = 1.0f;
            }
        } else if (withScaling) {
            float det = dx2 * dx2 + dy2 * dy2;
            a00 = (dx2 * dx1 + dy2 * dy1) / det;
            a10 = (dx2 * dy1 - dy2 * dx1) / det;
            a01 = -a10;
            a11 = a00;
        } else {
            double aTan = Math.atan2(dy1, dx1) - Math.atan2(dy2, dx2);
            a00 = (float)Math.cos(aTan);
            a10 = (float)Math.sin(aTan);
            a01 = (float)(-Math.sin(aTan));
            a11 = (float)Math.cos(aTan);
        }
        float sourceX = (float)line1.x1 + dx1 / 2.0f;
        float sourceY = (float)line1.y1 + dy1 / 2.0f;
        float targetX = (float)line2.x1 + dx2 / 2.0f;
        float targetY = (float)line2.y1 + dy2 / 2.0f;
        float a02 = sourceX - a00 * targetX - a01 * targetY;
        float a12 = sourceY - a10 * targetX - a11 * targetY;
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                float x = (float)i * a00 + (float)j * a01 + a02;
                float y = (float)i * a10 + (float)j * a11 + a12;
                pixels[i + j * w] = ((Interpolator)inter).get(x, y);
            }
            IJ.showProgress((int)(j + 1), (int)h);
        }
        result.setMinAndMax(source.getMin(), source.getMax());
        return result;
    }

    protected static class BilinearInterpolator
    extends Interpolator {
        public BilinearInterpolator(ImageProcessor ip) {
            super(ip);
        }

        @Override
        public float get(float x, float y) {
            int i = (int)x;
            int j = (int)y;
            float fx = x - (float)i;
            float fy = y - (float)j;
            float v00 = this.ip.getPixelValue(i, j);
            float v01 = this.ip.getPixelValue(i + 1, j);
            float v10 = this.ip.getPixelValue(i, j + 1);
            float v11 = this.ip.getPixelValue(i + 1, j + 1);
            return (1.0f - fx) * (1.0f - fy) * v00 + fx * (1.0f - fy) * v01 + (1.0f - fx) * fy * v10 + fx * fy * v11;
        }
    }

    protected static abstract class Interpolator {
        ImageProcessor ip;
        int w;
        int h;

        public Interpolator(ImageProcessor ip) {
            this.ip = ip;
            this.w = ip.getWidth();
            this.h = ip.getHeight();
        }

        public abstract float get(float var1, float var2);
    }
}

