/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.io.DirectoryChooser;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import vib.app.Options;
import vib.app.gui.FileGroupDialog;
import vib.app.gui.ProgressIndicator;
import vib.app.module.EndModule;
import vib.app.module.Module;
import vib.app.module.ModuleListener;
import vib.app.module.State;

public class VIB_Protocol
implements PlugIn,
ActionListener {
    static final int WD = 0;
    static final int TEMPL = 1;
    static final int NO_CHANNEL = 0;
    static final int REF_CHANNEL = 1;
    static final int RES_F = 2;
    private Button fg;
    private Button load;
    private Button save;
    private Button templateButton;
    private Options options;
    private GenericDialog gd;
    private FileGroupDialog fgd;
    private File template;

    public void run(String arg) {
        String option;
        this.options = new Options();
        if (Macro.getOptions() != null && !(option = Macro.getValue((String)Macro.getOptions(), (String)"load", (String)"")).equals("")) {
            this.options.loadFrom(option);
            State state = new State(this.options);
            Module.addModuleListener((ModuleListener)new ProgressIndicator(this.options));
            new EndModule().runOnAllImages(state);
            return;
        }
        this.gd = new GenericDialog("VIB Protocol");
        this.gd.addMessage("Do you want to load a stored configuration? ");
        this.gd.addMessage("If not, leave blank and click 'OK'");
        this.gd.addMessage("  ");
        Panel panel = new Panel();
        Button button = new Button("Load");
        panel.add(button);
        this.gd.addPanel(panel);
        this.gd.addStringField("Configuration file", "", 25);
        final TextField confTF = (TextField)this.gd.getStringFields().get(0);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDialog d = new OpenDialog("Load", "");
                if (d.getFileName() == null) {
                    return;
                }
                String f = d.getDirectory() + d.getFileName();
                confTF.setText(f);
                VIB_Protocol.this.gd.repaint();
            }
        });
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return;
        }
        this.gd = new GenericDialog("VIB Protocol");
        this.fgd = new FileGroupDialog(this.options.fileGroup);
        this.templateButton = this.fgd.getTemplateButton();
        this.templateButton.addActionListener(this);
        this.gd.addPanel((Panel)this.fgd);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 1;
        c.gridx = 1;
        c.fill = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        this.load = new Button("Select working directory");
        this.load.addActionListener(this);
        panel = new Panel();
        this.gd.addPanel(panel);
        this.gd.remove((Component)panel);
        this.gd.add((Component)this.load, (Object)c);
        this.gd.addStringField("Working directory", "", 25);
        this.gd.addStringField("Template", "", 25);
        this.gd.addNumericField("No of channels", 2.0, 0);
        this.gd.addNumericField("No of the reference channel", 2.0, 0);
        this.gd.addNumericField("Resampling factor", 2.0, 0);
        TextField wdtf = (TextField)this.gd.getStringFields().get(0);
        if (!confTF.getText().trim().equals("")) {
            this.loadFrom(confTF.getText());
        }
        TextField templateField = (TextField)this.gd.getStringFields().get(1);
        templateField.setEditable(false);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return;
        }
        this.initOptions();
        String confFile = this.options.workingDirectory + File.separator + "options.config";
        this.options.saveTo(confFile);
        if (!Interpreter.isBatchMode() && Macro.getOptions() == null) {
            IJ.showMessage((String)("Stored configuration in \n" + confFile + "\nYou can load it the next time you start the protocol."));
        }
        State state = new State(this.options);
        Module.addModuleListener((ModuleListener)new ProgressIndicator(this.options));
        new EndModule().runOnAllImages(state);
    }

    public void loadFrom(String confFile) {
        if (new File(confFile).exists()) {
            this.options.loadFrom(confFile);
            this.initTextFields();
        }
    }

    public void initTextFields() {
        this.template = new File(this.options.templatePath);
        this.setString(0, this.options.workingDirectory);
        this.setString(1, this.options.templatePath);
        this.setNumber(0, this.options.numChannels);
        this.setNumber(1, this.options.refChannel);
        this.setNumber(2, this.options.resamplingFactor);
        this.fgd.update();
    }

    public void initOptions() {
        this.options.workingDirectory = this.getString(0);
        this.options.templatePath = this.getString(1);
        this.options.numChannels = this.getNumber(0);
        this.options.refChannel = this.getNumber(1);
        this.options.resamplingFactor = this.getNumber(2);
    }

    private String getChoice(int i) {
        Choice c = (Choice)this.gd.getChoices().get(i);
        return c.getSelectedItem();
    }

    private void setChoice(int i, String val) {
        ((Choice)this.gd.getChoices().get(i)).select(val);
    }

    private int getNumber(int i) {
        TextField tf = (TextField)this.gd.getNumericFields().get(i);
        double d = 0.0;
        try {
            d = Double.parseDouble(tf.getText());
        }
        catch (NumberFormatException e) {
            IJ.error((String)(tf.getText() + " is not a number"));
        }
        return (int)Math.round(d);
    }

    private String getString(int i) {
        TextField tf = (TextField)this.gd.getStringFields().get(i);
        return tf.getText();
    }

    private void setNumber(int i, int num) {
        ((TextField)this.gd.getNumericFields().get(i)).setText(Integer.toString(num));
    }

    private void setString(int i, String st) {
        ((TextField)this.gd.getStringFields().get(i)).setText(st);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DirectoryChooser dialog;
        String dir;
        if (e.getSource() == this.templateButton) {
            File selected = this.fgd.getSelected();
            if (selected != null) {
                this.template = selected;
                this.setString(1, selected.getAbsolutePath());
            }
        } else if (e.getSource() == this.load && (dir = (dialog = new DirectoryChooser("Working Directory")).getDirectory()) != null) {
            this.setString(0, dir);
        }
    }
}

