/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import math3d.Line;
import math3d.Plane;
import math3d.Point3d;
import oldsegmenters.LabelBinaryOps;
import oldsegmenters.SegmentatorModel;
import oldsegmenters.Utils;

public class LabelInterpolator_
implements PlugIn {
    public void run(String arg) {
        LabelInterpolator_.interpolate(new SegmentatorModel(IJ.getImage()));
    }

    public static void interpolate(SegmentatorModel model) {
        if (model.getCurrentMaterial() == null) {
            IJ.showMessage((String)"please select a label first");
            return;
        }
        StackData data = new StackData(model, model.getCurrentMaterial().id);
        System.out.println("stack data = " + data);
        IJ.showProgress((double)0.5);
        for (Interpolation interpolation : data.getInterpolations()) {
            interpolation.interpolate();
            for (int i = interpolation.firstIndex; i <= interpolation.secondIndex; ++i) {
                model.updateSliceNoRedraw(i);
            }
        }
        IJ.showProgress((double)1.0);
        model.data.updateAndDraw();
    }

    private static class Interpolation {
        byte[] labelledPixels1;
        byte[] labelledPixels2;
        int firstIndex;
        int secondIndex;
        int width;
        int color;
        Rectangle bounds;
        ArrayList<byte[]> interpolatedPixels = new ArrayList();

        private Interpolation() {
        }

        int getDistance() {
            return this.interpolatedPixels.size();
        }

        int getPixel(int x, int y, byte[] data) {
            return data[x + y * this.width];
        }

        void setPixel(int x, int y, int color, byte[] data) {
            data[x + y * this.width] = (byte)color;
        }

        void interpolate() {
            for (int x = this.bounds.x; x < this.bounds.x + this.bounds.width; ++x) {
                for (int y = this.bounds.y; y < this.bounds.y + this.bounds.height; ++y) {
                    Line fillLine;
                    Point oppPoint;
                    if (this.getPixel(x, y, this.labelledPixels1) != this.color && this.getPixel(x, y, this.labelledPixels2) != this.color) continue;
                    if (this.getPixel(x, y, this.labelledPixels1) == this.color && this.getPixel(x, y, this.labelledPixels2) == this.color) {
                        for (byte[] pixels : this.interpolatedPixels) {
                            this.setPixel(x, y, this.color, pixels);
                        }
                        continue;
                    }
                    if (this.getPixel(x, y, this.labelledPixels1) == this.color) {
                        oppPoint = this.getNearest(new Point(x, y), this.labelledPixels2, this.width, this.color);
                        if (oppPoint == null) continue;
                        fillLine = new Line(new Point3d((double)x, (double)y, (double)this.firstIndex), new Point3d((double)oppPoint.x, (double)oppPoint.y, (double)this.secondIndex));
                    } else {
                        oppPoint = this.getNearest(new Point(x, y), this.labelledPixels1, this.width, this.color);
                        if (oppPoint == null) continue;
                        fillLine = new Line(new Point3d((double)x, (double)y, (double)this.secondIndex), new Point3d((double)oppPoint.x, (double)oppPoint.y, (double)this.firstIndex));
                    }
                    int index = this.firstIndex;
                    for (byte[] pixels : this.interpolatedPixels) {
                        int sliceDepth = ++index;
                        Plane slice = new Plane(0.0, 0.0, 1.0, (double)(-sliceDepth));
                        Point3d intersect = slice.intersection(fillLine);
                        this.setPixel((int)Math.floor(intersect.x), (int)Math.ceil(intersect.y), this.color, pixels);
                        this.setPixel((int)Math.floor(intersect.x), (int)Math.floor(intersect.y), this.color, pixels);
                        this.setPixel((int)Math.ceil(intersect.x), (int)Math.floor(intersect.y), this.color, pixels);
                        this.setPixel((int)Math.ceil(intersect.x), (int)Math.ceil(intersect.y), this.color, pixels);
                    }
                }
            }
            for (byte[] pixels : this.interpolatedPixels) {
                LabelBinaryOps.clean((Roi)new Roi(this.bounds), (byte[])pixels, (int)this.width, (byte)((byte)this.color));
            }
            System.out.println("one interpolation done");
        }

        private Point getNearest(Point point, byte[] pixels, int width, int color) {
            Point tstPoint;
            Utils.Spiral spiral = new Utils.Spiral(point);
            boolean count = false;
            do {
                tstPoint = spiral.next();
            } while (tstPoint.x < 0 || tstPoint.x >= width || tstPoint.y < 0 || tstPoint.y >= pixels.length / width || pixels[tstPoint.x + tstPoint.y * width] != color);
            return tstPoint;
        }
    }

    private static class StackData {
        ImagePlus labelsData;
        ArrayList<Integer> labelledSlices = new ArrayList();
        SegmentatorModel model;
        int label;

        public StackData(SegmentatorModel model, int label) {
            this.model = model;
            this.labelsData = model.getLabelImagePlus();
            this.label = label;
            this.findLabelledSlices();
        }

        private void findLabelledSlices() {
            block0: for (int i = 1; i <= this.labelsData.getStackSize(); ++i) {
                byte[] pixels = (byte[])this.labelsData.getStack().getProcessor(i).getPixels();
                for (int j = 0; j < pixels.length; ++j) {
                    byte pixel = pixels[j];
                    if (pixel != this.label) continue;
                    this.labelledSlices.add(i);
                    continue block0;
                }
            }
        }

        public Iterable<Interpolation> getInterpolations() {
            LinkedList<Interpolation> results = new LinkedList<Interpolation>();
            for (int i = 0; i < this.labelledSlices.size() - 1; ++i) {
                Interpolation inter = new Interpolation();
                int firstIndex = this.labelledSlices.get(i);
                int secondIndex = this.labelledSlices.get(i + 1);
                inter.width = this.model.getLabelImagePlus().getWidth();
                inter.color = this.label;
                inter.firstIndex = firstIndex;
                inter.secondIndex = secondIndex;
                inter.labelledPixels1 = (byte[])this.labelsData.getStack().getProcessor(firstIndex).getPixels();
                inter.labelledPixels2 = (byte[])this.labelsData.getStack().getProcessor(secondIndex).getPixels();
                inter.bounds = this.model.getLabelCanvas().getOutline(firstIndex, this.label).getBounds();
                inter.bounds.add(this.model.getLabelCanvas().getOutline(secondIndex, this.label).getBounds());
                for (int j = firstIndex + 1; j < secondIndex; ++j) {
                    inter.interpolatedPixels.add((byte[])this.labelsData.getStack().getProcessor(j).getPixels());
                }
                results.add(inter);
            }
            return results;
        }

        public String toString() {
            return "labelledSlices: " + this.labelledSlices;
        }
    }
}

