/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import amira.AmiraMeshEncoder;
import amira.AmiraParameters;
import amira.AmiraTableEncoder;
import events.RoiEvent;
import events.RoiListener;
import events.SliceEvent;
import events.SliceListener;
import events.SliceWatcher;
import gui.GuiBuilder;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.io.SaveDialog;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oldsegmenters.AutoLabellerNaive;
import oldsegmenters.LabelBinaryOps;
import oldsegmenters.LabelThresholder_;
import oldsegmenters.SegmentatorModel;
import vib.SegmentationViewerCanvas;

public class Segmentator_
extends JFrame
implements PlugIn {
    private static final String LOAD_IMAGE = "load image";
    private static final String SAVE_IMAGE = "save image";
    private static final String LOAD_LABELS = "load labels";
    private static final String SAVE_LABELS = "save labels";
    private static final String LOAD_MATERIALS = "load materials";
    private static final String THRESHOLD = "threshold";
    private static final String THRESHOLD_UNDO = "undo";
    private static final String INTERPOLATOR = "interpolate";
    private static final String DILATE = "dilate";
    private static final String ERODE = "erode";
    private static final String OPEN = "open";
    private static final String CLOSE = "close";
    private static final String CLEAN = "clean";
    private static final String NAIVE_LABEL = "naive auto label (optic lobes)";
    JList labelList;
    DefaultListModel labelListModel;
    JSpinner minThreshold;
    JSpinner maxThreshold;
    JTextField autoLabelFileLoc;

    public Segmentator_() {
        super("segmentator");
        Controllor controllor = new Controllor();
        MacroInstaller installer = new MacroInstaller();
        installer.install("var brushWidth = 10;\nvar leftClick=16, altOrShift=9;\nvar pollDelay = 10;\nmacro \"Show Current Label [l]\" { label=call('LabelBrush_.getLabelMessage')\n showStatus(label);\n}\nmacro 'Label Brush Tool - C111O11ffC100T6c0aL' {\n while (true) {\n  getCursorLoc(x, y, z, flags);\n  if (flags&leftClick==0) exit();\n  if (flags&altOrShift==0){\n   call('LabelBrush_.label', x,y,z,flags,brushWidth);\n  }else{\n   call('LabelBrush_.unlabel', x,y,z,flags,brushWidth);\n  }\n  wait(pollDelay);\n }\n}\n\nmacro 'Label Brush Tool Options...' {\n brushWidth = getNumber('Label Brush Width (pixels):', brushWidth);\n}");
        ImagePlus.addImageListener((ImageListener)controllor);
        for (Frame frame : ImageWindow.getFrames()) {
            if (!(frame instanceof ImageWindow)) continue;
            controllor.imageOpened(((ImageWindow)frame).getImagePlus());
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.labelList = Segmentator_.addLabelList(this);
        this.labelListModel = (DefaultListModel)this.labelList.getModel();
        this.labelList.addListSelectionListener(controllor);
        GuiBuilder.add2Command((Container)this, (String)LOAD_IMAGE, (String)LOAD_IMAGE, (String)SAVE_IMAGE, (String)SAVE_IMAGE, (ActionListener)controllor);
        GuiBuilder.add2Command((Container)this, (String)LOAD_LABELS, (String)LOAD_LABELS, (String)SAVE_LABELS, (String)SAVE_LABELS, (ActionListener)controllor);
        GuiBuilder.addCommand((Container)this, (String)LOAD_MATERIALS, (String)LOAD_MATERIALS, (ActionListener)controllor);
        this.minThreshold = GuiBuilder.addLabeledNumericSpinner((Container)this, (String)"min", (int)45, (int)0, (int)255, (ChangeListener)controllor);
        this.maxThreshold = GuiBuilder.addLabeledNumericSpinner((Container)this, (String)"max", (int)255, (int)0, (int)255, (ChangeListener)controllor);
        GuiBuilder.add2Command((Container)this, (String)THRESHOLD, (String)THRESHOLD, (String)THRESHOLD_UNDO, (String)THRESHOLD_UNDO, (ActionListener)controllor);
        GuiBuilder.addCommand((Container)this, (String)INTERPOLATOR, (String)INTERPOLATOR, (ActionListener)controllor);
        GuiBuilder.add2Command((Container)this, (String)DILATE, (String)DILATE, (String)ERODE, (String)ERODE, (ActionListener)controllor);
        GuiBuilder.add2Command((Container)this, (String)OPEN, (String)OPEN, (String)CLOSE, (String)CLOSE, (ActionListener)controllor);
        GuiBuilder.addCommand((Container)this, (String)CLEAN, (String)CLEAN, (ActionListener)controllor);
        this.autoLabelFileLoc = GuiBuilder.addFileField((Container)this, (String)"auto label file loc (av intensity");
        GuiBuilder.addCommand((Container)this, (String)NAIVE_LABEL, (String)NAIVE_LABEL, (ActionListener)controllor);
        this.pack();
    }

    public void run(String arg0) {
        this.setVisible(!this.isVisible());
    }

    public void clearLabelsList() {
        this.labelListModel.clear();
    }

    public void populateLabelList(AmiraParameters params) {
        this.clearLabelsList();
        if (params == null) {
            return;
        }
        for (int id = 0; id < params.getMaterialCount(); ++id) {
            this.labelListModel.addElement(params.getMaterial(id));
        }
    }

    public AmiraParameters.Material getCurrentMaterial() {
        int selectedIndex = this.labelList.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        return (AmiraParameters.Material)this.labelListModel.get(selectedIndex);
    }

    private void threshold() {
        LabelThresholder_.min = ((SpinnerNumberModel)this.minThreshold.getModel()).getNumber().intValue();
        LabelThresholder_.max = ((SpinnerNumberModel)this.maxThreshold.getModel()).getNumber().intValue();
        IJ.runPlugIn((String)"LabelThresholder_", (String)"");
    }

    public static JList addLabelList(Container c) {
        DefaultListModel model = new DefaultListModel();
        JList list = new JList(model);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("labels..."), "North");
        JPanel controlPanel = new JPanel(new GridLayout(1, 2));
        panel.add(new JScrollPane(list));
        c.add(panel);
        return list;
    }

    private class Controllor
    implements ActionListener,
    ImageListener,
    WindowFocusListener,
    SliceListener,
    RoiListener,
    ListSelectionListener,
    ChangeListener {
        ImagePlus currentImage;

        private Controllor() {
        }

        public void writeImage(Object frame) {
            SaveDialog od = new SaveDialog("AmiraFile", null, ".am");
            String dir = od.getDirectory();
            String name = od.getFileName();
            if (name == null) {
                return;
            }
            if (frame instanceof TextWindow) {
                TextWindow t = (TextWindow)frame;
                AmiraTableEncoder e = new AmiraTableEncoder(t);
                if (!e.write(dir + name)) {
                    IJ.error((String)("Could not write to " + dir + name));
                }
                return;
            }
            AmiraMeshEncoder e = new AmiraMeshEncoder(dir + name);
            if (!e.open()) {
                IJ.error((String)("Could not write " + dir + name));
                return;
            }
            if (!e.write((ImagePlus)frame)) {
                IJ.error((String)("Error writing " + dir + name));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(Segmentator_.LOAD_IMAGE)) {
                IJ.runPlugIn((String)"AmiraMeshReader_", (String)"");
                if (AmiraParameters.isAmiraLabelfield((ImagePlus)IJ.getImage())) {
                    IJ.showMessage((String)"file was not an image file");
                } else {
                    this.updateCurrent(IJ.getImage());
                }
            } else if (e.getActionCommand().equals(Segmentator_.SAVE_IMAGE)) {
                IJ.runPlugIn((String)"AmiraMeshWriter_", (String)"");
            } else if (e.getActionCommand().equals(Segmentator_.LOAD_LABELS)) {
                IJ.runPlugIn((String)"AmiraMeshReader_", (String)"");
                if (AmiraParameters.isAmiraLabelfield((ImagePlus)IJ.getImage())) {
                    this.loadLabels(IJ.getImage());
                } else {
                    IJ.showMessage((String)"file was not a labels file");
                }
            } else if (e.getActionCommand().equals(Segmentator_.SAVE_LABELS)) {
                this.writeImage(new SegmentatorModel(this.currentImage).getLabelImagePlus());
            } else if (e.getActionCommand().equals(Segmentator_.LOAD_MATERIALS)) {
                IJ.runPlugIn((String)"AmiraMeshReader_", (String)"");
                if (AmiraParameters.isAmiraLabelfield((ImagePlus)IJ.getImage())) {
                    this.loadMaterials(IJ.getImage());
                } else {
                    IJ.showMessage((String)"file was not a labels file");
                }
            } else if (e.getActionCommand().equals(Segmentator_.THRESHOLD)) {
                Segmentator_.this.threshold();
            } else if (e.getActionCommand().equals(Segmentator_.THRESHOLD_UNDO)) {
                LabelThresholder_.rollback();
            } else if (e.getActionCommand().equals(Segmentator_.INTERPOLATOR)) {
                IJ.runPlugIn((String)"LabelInterpolator_", (String)"");
            } else if (e.getActionCommand().equals(Segmentator_.DILATE)) {
                SegmentatorModel model = new SegmentatorModel(this.currentImage);
                if (model.getCurrentMaterial() != null) {
                    LabelBinaryOps.dilate((ImageProcessor)model.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), (Roi)this.currentImage.getRoi(), (byte)((byte)model.getCurrentMaterial().id));
                    model.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (e.getActionCommand().equals(Segmentator_.ERODE)) {
                SegmentatorModel model = new SegmentatorModel(this.currentImage);
                System.out.println("eroding");
                if (model.getCurrentMaterial() != null) {
                    LabelBinaryOps.erode((ImageProcessor)model.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), (Roi)this.currentImage.getRoi(), (byte)((byte)model.getCurrentMaterial().id));
                    model.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (e.getActionCommand().equals(Segmentator_.CLOSE)) {
                SegmentatorModel model = new SegmentatorModel(this.currentImage);
                if (model.getCurrentMaterial() != null) {
                    LabelBinaryOps.close((ImageProcessor)model.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), (Roi)this.currentImage.getRoi(), (byte)((byte)model.getCurrentMaterial().id));
                    model.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (e.getActionCommand().equals(Segmentator_.OPEN)) {
                SegmentatorModel model = new SegmentatorModel(this.currentImage);
                if (model.getCurrentMaterial() != null) {
                    LabelBinaryOps.open((ImageProcessor)model.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), (Roi)this.currentImage.getRoi(), (byte)((byte)model.getCurrentMaterial().id));
                    model.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (e.getActionCommand().equals(Segmentator_.CLEAN)) {
                SegmentatorModel model = new SegmentatorModel(this.currentImage);
                if (model.getCurrentMaterial() != null) {
                    LabelBinaryOps.close((ImageProcessor)model.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), (Roi)this.currentImage.getRoi(), (byte)((byte)model.getCurrentMaterial().id));
                    LabelBinaryOps.open((ImageProcessor)model.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), (Roi)this.currentImage.getRoi(), (byte)((byte)model.getCurrentMaterial().id));
                    model.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (e.getActionCommand().equals(Segmentator_.NAIVE_LABEL)) {
                new RunAsyncronous(e.getActionCommand()).start();
            }
            if (this.currentImage != null) {
                this.currentImage.updateAndDraw();
            }
        }

        private void loadMaterials(ImagePlus materialImage) {
            AmiraParameters params = new AmiraParameters(materialImage);
            System.out.println("currentImage.getStackSize() = " + this.currentImage.getStackSize());
            IJ.newImage((String)"new", (String)"8-bit", (int)this.currentImage.getWidth(), (int)this.currentImage.getHeight(), (int)this.currentImage.getStackSize());
            ImagePlus newImage = IJ.getImage();
            newImage.setProperty("Info", materialImage.getProperty("Info"));
            AmiraParameters newParams = new AmiraParameters(newImage);
            materialImage.close();
            this.loadLabels(newImage);
        }

        private void loadLabels(ImagePlus labelImage) {
            labelImage.hide();
            new SegmentatorModel(this.currentImage).setLabelImagePlus(labelImage);
            AmiraParameters params = new AmiraParameters(labelImage);
            Segmentator_.this.populateLabelList(params);
            SegmentationViewerCanvas canvas = new SegmentationViewerCanvas(this.currentImage, labelImage);
            new SegmentatorModel(this.currentImage).setLabelCanvas(canvas);
            if (this.currentImage.getStackSize() > 1) {
                new StackWindow(this.currentImage, (ImageCanvas)canvas);
            } else {
                new ImageWindow(this.currentImage, (ImageCanvas)canvas);
            }
            new SliceWatcher(this.currentImage).addSliceListener((SliceListener)this);
            this.currentImage.getWindow().addWindowFocusListener((WindowFocusListener)this);
        }

        public void imageOpened(ImagePlus ip) {
            ip.getWindow().addWindowFocusListener((WindowFocusListener)this);
        }

        public void imageClosed(ImagePlus ip) {
            ip.getWindow().removeWindowFocusListener((WindowFocusListener)this);
        }

        public void imageUpdated(ImagePlus ip) {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            this.updateCurrent(IJ.getImage());
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
        }

        private void updateCurrent(ImagePlus newCurrent) {
            if (newCurrent == this.currentImage) {
                return;
            }
            if (this.currentImage != null) {
                new SliceWatcher(this.currentImage).removeSliceListener((SliceListener)this);
            }
            if (newCurrent != null) {
                System.out.println("newCurrent = " + newCurrent);
                new SliceWatcher(newCurrent).addSliceListener((SliceListener)this);
                Segmentator_.this.labelList.removeListSelectionListener(this);
                Segmentator_.this.populateLabelList(new SegmentatorModel(newCurrent).getMaterialParams());
                Segmentator_.this.labelList.addListSelectionListener(this);
            }
            this.currentImage = newCurrent;
        }

        public void sliceNumberChanged(SliceEvent e) {
            LabelThresholder_.commit();
        }

        public void roiChanged(RoiEvent e) {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            new SegmentatorModel(this.currentImage).setCurrentMaterial(Segmentator_.this.getCurrentMaterial());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if ((e.getSource().equals(Segmentator_.this.minThreshold) || e.getSource().equals(Segmentator_.this.maxThreshold)) && this.currentImage.getRoi() != null) {
                LabelThresholder_.rollback();
                Segmentator_.this.threshold();
            }
        }

        private class RunAsyncronous
        extends Thread {
            String cmd;

            public RunAsyncronous(String command) {
                this.cmd = command;
            }

            @Override
            public void run() {
                if (this.cmd.equals(Segmentator_.NAIVE_LABEL)) {
                    try {
                        AutoLabellerNaive naive = new AutoLabellerNaive(Segmentator_.this.autoLabelFileLoc.getText());
                        naive.segment(new SegmentatorModel(Controllor.this.currentImage));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

