/*
 * Decompiled with CFR 0.152.
 */
package util;

import pal.math.MultivariateFunction;
import util.IdealImager;

class FluorescenceOptimizer
implements MultivariateFunction {
    int n;
    IdealImager[] imagers;
    int minValue;
    int maxValue;
    double upperFluorescenceBound;
    double lowerFluorescenceBound;
    int[] valuesInImages;

    public FluorescenceOptimizer(IdealImager[] imagers) {
        this.imagers = imagers;
        this.n = imagers.length;
        if (this.n < 1) {
            throw new RuntimeException("There must be at least one IdealImager in the array");
        }
        this.minValue = imagers[0].minValue;
        this.maxValue = imagers[0].maxValue;
        for (int i = 1; i < this.n; ++i) {
            if (imagers[i].minValue == this.minValue && imagers[i].maxValue == this.maxValue) continue;
            throw new RuntimeException("All IdealImagers must have the same value range.");
        }
    }

    public void setRealResult(int[] valuesInImages) {
        this.valuesInImages = valuesInImages;
    }

    public double evaluate(double[] argument) {
        float total = 0.0f;
        for (int i = 0; i < this.n; ++i) {
            int value = this.imagers[i].map(argument[0]);
            int diff = this.valuesInImages[i] - value;
            total += (float)(diff * diff);
        }
        return total;
    }

    public double optimize(float startFluorescence) {
        return -1.0;
    }

    public int getNumArguments() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double getLowerBound(int n) {
        return this.lowerFluorescenceBound;
    }

    public double getUpperBound(int n) {
        return this.upperFluorescenceBound;
    }

    void setLowerBound(float min) {
        this.lowerFluorescenceBound = min;
    }

    void setUpperBound(float max) {
        this.upperFluorescenceBound = max;
    }
}

