/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.YesNoCancelDialog;
import ij.io.DirectoryChooser;
import ij.io.FileSaver;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ColorModel;
import java.io.File;
import java.util.HashMap;
import java.util.Random;
import util.BatchOpener;
import vib.app.FileGroup;
import vib.app.gui.FileGroupDialog;

public class Quantile_Based_Normalization
implements PlugIn,
ActionListener,
ItemListener {
    public static final String PLUGIN_VERSION = "1.2";
    TextField outputDirectoryInput;
    Button chooseOutputDirectory;
    Checkbox useMaskCheckbox;
    Checkbox useMaskPerImageCheckbox;
    TextField maskFileInput;
    Button chooseMaskButton;
    static final int POSSIBLE_8_BIT_VALUES = 256;
    static final int POSSIBLE_16_BIT_VALUES = 65536;

    public void divideIntoQuantiles(int numberOfQuantiles, long[] frequencies, long pointsInImage, long[] resultSumValuesInQuantile, long[] resultNumberOfValuesInQuantile) {
        if (numberOfQuantiles != resultNumberOfValuesInQuantile.length) {
            throw new RuntimeException("BUG: numberOfQuantiles didn't match resultNumberOfValuesInQuantile.length");
        }
        if (numberOfQuantiles != resultSumValuesInQuantile.length) {
            throw new RuntimeException("BUG: numberOfQuantiles didn't match resultSumValuesInQuantile.length");
        }
        for (int q = 0; q < numberOfQuantiles; ++q) {
            long indexStartThisQuantile = (int)((long)q * pointsInImage / (long)numberOfQuantiles);
            long indexStartNextQuantile = (int)((long)(q + 1) * pointsInImage / (long)numberOfQuantiles);
            long pointsInQuantile = indexStartNextQuantile - indexStartThisQuantile;
            if (q == numberOfQuantiles - 1) {
                indexStartNextQuantile = pointsInImage;
            }
            long cumulativeIncluding = 0L;
            long cumulativeBefore = 0L;
            resultSumValuesInQuantile[q] = 0L;
            resultNumberOfValuesInQuantile[q] = 0L;
            for (int value = 0; value < frequencies.length; ++value) {
                if ((cumulativeIncluding += frequencies[value]) >= indexStartThisQuantile && cumulativeBefore < indexStartNextQuantile) {
                    long startInValues = 0L;
                    if (indexStartThisQuantile > cumulativeBefore) {
                        startInValues = indexStartThisQuantile - cumulativeBefore;
                    }
                    long endInValues = frequencies[value] - 1L;
                    if (indexStartNextQuantile < cumulativeIncluding) {
                        endInValues = indexStartNextQuantile - cumulativeBefore - 1L;
                    }
                    long pointsInOverlap = endInValues - startInValues + 1L;
                    int n = q;
                    resultNumberOfValuesInQuantile[n] = resultNumberOfValuesInQuantile[n] + pointsInOverlap;
                    int n2 = q;
                    resultSumValuesInQuantile[n2] = resultSumValuesInQuantile[n2] + (long)value * pointsInOverlap;
                }
                cumulativeBefore += frequencies[value];
            }
        }
    }

    public void generateReplacements(ImagePlus imagePlus, int numberOfQuantiles, long pointsInImage, long[] frequencies, long[] sumValuesInQuantile, long[] numberOfValuesInQuantile, double[] quantileMeans, Replacements[] resultRankReplacements, Replacements[] resultMeanReplacements) {
        int possibleImageValues = frequencies.length;
        for (int q = 0; q < numberOfQuantiles; ++q) {
            long[] replacementsInThisQuantile = new long[possibleImageValues];
            long indexStartThisQuantile = (int)((long)q * pointsInImage / (long)numberOfQuantiles);
            long indexStartNextQuantile = (int)((long)(q + 1) * pointsInImage / (long)numberOfQuantiles);
            long pointsInQuantile = indexStartNextQuantile - indexStartThisQuantile;
            if (q == numberOfQuantiles - 1) {
                indexStartNextQuantile = pointsInImage;
            }
            long cumulativeIncluding = 0L;
            long cumulativeBefore = 0L;
            for (int value = 0; value < frequencies.length; ++value) {
                if ((cumulativeIncluding += frequencies[value]) >= indexStartThisQuantile && cumulativeBefore < indexStartNextQuantile) {
                    long startInValues = 0L;
                    if (indexStartThisQuantile > cumulativeBefore) {
                        startInValues = indexStartThisQuantile - cumulativeBefore;
                    }
                    long endInValues = frequencies[value] - 1L;
                    if (indexStartNextQuantile < cumulativeIncluding) {
                        endInValues = indexStartNextQuantile - cumulativeBefore - 1L;
                    }
                    long pointsInOverlap = endInValues - startInValues + 1L;
                    int n = q;
                    numberOfValuesInQuantile[n] = numberOfValuesInQuantile[n] + pointsInOverlap;
                    int n2 = q;
                    sumValuesInQuantile[n2] = sumValuesInQuantile[n2] + (long)value * pointsInOverlap;
                    replacementsInThisQuantile[value] = pointsInOverlap;
                }
                cumulativeBefore += frequencies[value];
            }
            double mean = quantileMeans[q];
            int byteLowerThanMean = (int)Math.floor(mean);
            int byteHigherThanMean = (int)Math.ceil(mean);
            double proportionLower = Math.ceil(mean) - mean;
            int lowerBytes = (int)Math.round(proportionLower * (double)(indexStartNextQuantile - indexStartThisQuantile));
            int higherBytes = (int)(numberOfValuesInQuantile[q] - (long)lowerBytes);
            long replacementsAddedAlready = 0L;
            for (int i = 0; i < possibleImageValues; ++i) {
                long r = replacementsInThisQuantile[i];
                if (r == 0L) continue;
                long howManyLowerToAdd = 0L;
                long howManyHigherToAdd = 0L;
                if (replacementsAddedAlready >= (long)lowerBytes) {
                    howManyHigherToAdd = r;
                } else if (replacementsAddedAlready + r >= (long)lowerBytes) {
                    howManyLowerToAdd = (long)lowerBytes - replacementsAddedAlready;
                    howManyHigherToAdd = r - howManyLowerToAdd;
                } else {
                    howManyLowerToAdd = r;
                }
                resultMeanReplacements[i].addSomeReplacements(howManyLowerToAdd, byteLowerThanMean);
                resultMeanReplacements[i].addSomeReplacements(howManyHigherToAdd, byteHigherThanMean);
                resultRankReplacements[i].addSomeReplacements(r, q);
                replacementsAddedAlready += r;
            }
        }
    }

    ImagePlus remapImage(ImagePlus imagePlus, int numberOfQuantiles, boolean replaceWithRankInstead, boolean rescaleRanks, Mask mask, Replacements[] rankReplacements, Replacements[] meanReplacements) {
        if (mask != null) {
            System.out.println("remapping with mask: " + mask);
        }
        int originalImageType = imagePlus.getType();
        int width = imagePlus.getWidth();
        int height = imagePlus.getHeight();
        ImageStack stack = imagePlus.getStack();
        int depth = stack.getSize();
        ImageStack newStack = new ImageStack(width, height);
        for (int z = 0; z < depth; ++z) {
            byte[] oldPixelsByte = null;
            byte[] newPixelsByte = null;
            short[] oldPixelsShort = null;
            short[] newPixelsShort = null;
            if (originalImageType == 1) {
                oldPixelsShort = (short[])stack.getPixels(z + 1);
                newPixelsShort = new short[width * height];
            } else {
                oldPixelsByte = (byte[])stack.getPixels(z + 1);
                newPixelsByte = new byte[width * height];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int replacement;
                    if (mask != null && !mask.inMask[z][y * width + x]) continue;
                    int oldValue = originalImageType == 1 ? oldPixelsShort[y * width + x] & 0xFFFF : oldPixelsByte[y * width + x] & 0xFF;
                    if (replaceWithRankInstead) {
                        replacement = rankReplacements[oldValue].getRandomReplacement();
                        if (rescaleRanks) {
                            replacement = 255 * replacement / (numberOfQuantiles - 1);
                        }
                    } else {
                        replacement = meanReplacements[oldValue].getRandomReplacement();
                    }
                    if (replacement < 0) {
                        System.out.println("BUG: ran out of replacements for " + oldValue);
                        replacement = oldValue;
                    }
                    if (originalImageType == 1) {
                        newPixelsShort[y * width + x] = (short)replacement;
                        continue;
                    }
                    newPixelsByte[y * width + x] = (byte)replacement;
                }
            }
            if (originalImageType == 1) {
                ShortProcessor sp = new ShortProcessor(width, height);
                sp.setPixels((Object)newPixelsShort);
                newStack.addSlice("", (ImageProcessor)sp);
            } else {
                ByteProcessor bp = new ByteProcessor(width, height);
                bp.setPixels((Object)newPixelsByte);
                newStack.addSlice("", (ImageProcessor)bp);
            }
            IJ.showProgress((double)((double)z / (double)depth));
        }
        IJ.showProgress((double)1.0);
        if (3 == imagePlus.getType()) {
            ColorModel cm = null;
            cm = stack.getColorModel();
            if (cm != null) {
                newStack.setColorModel(cm);
            }
        }
        ImagePlus newImage = new ImagePlus("normalized " + imagePlus.getTitle(), newStack);
        newImage.setCalibration(imagePlus.getCalibration());
        return newImage;
    }

    File getMaskFileFromImageFile(File imageFile) {
        String fileLeafName = imageFile.getName();
        int indexOfLastDot = fileLeafName.lastIndexOf(".");
        if (indexOfLastDot < 0) {
            throw new RuntimeException("Tried to find the corresponding mask file for an image file with an extension: " + imageFile.getAbsolutePath());
        }
        String fileWithoutExtension = fileLeafName.substring(0, indexOfLastDot);
        String extension = fileLeafName.substring(indexOfLastDot);
        return new File(imageFile.getParent(), fileWithoutExtension + ".mask.tif");
    }

    public void processToDirectory(FileGroup fg, String outputDirectory, boolean useMaskPerImage, String maskFileName, int channelToUse, int numberOfQuantiles, boolean replaceWithRankInstead, boolean rescaleRanks) {
        ImagePlus imagePlus;
        File o = new File(outputDirectory);
        if (!o.exists()) {
            IJ.error((String)("The output directory ('" + outputDirectory + "') doesn't exist."));
            return;
        }
        if (!o.isDirectory()) {
            IJ.error((String)("'" + outputDirectory + "' is not a directory"));
            return;
        }
        int n = fg.size();
        if (n < 1) {
            IJ.error((String)"No image files selected");
            return;
        }
        if (useMaskPerImage) {
            boolean missingMask = false;
            for (int b = 0; b < n; ++b) {
                File f = (File)fg.get(b);
                File maskFile = this.getMaskFileFromImageFile(f);
                if (maskFile.exists()) continue;
                IJ.log((String)("The following mask file was missing: " + maskFile.getAbsolutePath()));
                missingMask = true;
            }
            if (missingMask) {
                throw new RuntimeException("At least one mask file was missing - see the log window");
            }
        }
        long[][] frequencies = null;
        long[] pointsInImage = new long[n];
        long[][] sumValuesInQuantile = new long[n][numberOfQuantiles];
        long[][] numberOfValuesInQuantile = new long[n][numberOfQuantiles];
        int possibleImageValues = -1;
        for (int b = 0; b < n; ++b) {
            File f = (File)fg.get(b);
            String path = f.getAbsolutePath();
            Mask mask = null;
            if (maskFileName != null) {
                mask = new Mask(new File(maskFileName));
            } else if (useMaskPerImage) {
                mask = new Mask(this.getMaskFileFromImageFile(f));
            }
            ImagePlus[] channels = BatchOpener.open((String)path);
            if (channelToUse >= channels.length) {
                IJ.error((String)("There is no channel " + channelToUse + " in " + path));
                return;
            }
            imagePlus = channels[channelToUse];
            int type = imagePlus.getType();
            if (type == 0 || type == 3) {
                if (possibleImageValues > 0) {
                    if (possibleImageValues != 256) {
                        IJ.error((String)("The image '" + path + "' was 8 bit, but the previous images were all 16 bit"));
                    }
                } else {
                    possibleImageValues = 256;
                    frequencies = new long[n][possibleImageValues];
                }
            } else if (type == 1) {
                if (possibleImageValues > 0) {
                    if (possibleImageValues != 65536) {
                        IJ.error((String)("The image '" + path + "' was 16 bit, but the previous images were all 8 bit"));
                    }
                } else {
                    possibleImageValues = 65536;
                    frequencies = new long[n][possibleImageValues];
                }
            } else {
                IJ.error((String)("Error processing '" + path + "': This plugin only works on 8bit (GRAY8 or COLOR_256) images."));
                return;
            }
            String freeMemory = IJ.freeMemory();
            System.out.println("free memory is: " + freeMemory);
            int width = imagePlus.getWidth();
            int height = imagePlus.getHeight();
            int depth = imagePlus.getStackSize();
            if (mask != null && (width != mask.width || height != mask.height || depth != mask.depth)) {
                throw new RuntimeException("The image file " + path + " was not the same dimensions as the mask file " + mask.file.getAbsolutePath());
            }
            ImageStack stack = imagePlus.getStack();
            IJ.showStatus((String)("Calculating frequencies and quantiles for " + imagePlus.getShortTitle() + " ..."));
            for (int z = 0; z < depth; ++z) {
                int value;
                int x;
                int y;
                Object[] pixels;
                if (possibleImageValues == 256) {
                    pixels = (byte[])stack.getPixels(z + 1);
                    for (y = 0; y < height; ++y) {
                        for (x = 0; x < width; ++x) {
                            if (mask != null && !mask.inMask[z][y * width + x]) continue;
                            value = pixels[y * width + x] & 0xFF;
                            long[] lArray = frequencies[b];
                            int n2 = value;
                            lArray[n2] = lArray[n2] + 1L;
                        }
                    }
                    continue;
                }
                pixels = (short[])stack.getPixels(z + 1);
                for (y = 0; y < height; ++y) {
                    for (x = 0; x < width; ++x) {
                        if (mask != null && !mask.inMask[z][y * width + x]) continue;
                        value = pixels[y * width + x] & 0xFFFF;
                        long[] lArray = frequencies[b];
                        int n3 = value;
                        lArray[n3] = lArray[n3] + 1L;
                    }
                }
            }
            pointsInImage[b] = mask == null ? (long)(width * height * depth) : mask.pointsInMask;
            System.out.println("Proportion of points to consider: " + (double)pointsInImage[b] / (double)(width * height * depth));
            this.divideIntoQuantiles(numberOfQuantiles, frequencies[b], pointsInImage[b], sumValuesInQuantile[b], numberOfValuesInQuantile[b]);
            imagePlus.close();
        }
        System.out.println("Now going on to calculate the mean in each quantile.");
        double[] quantileMeans = new double[numberOfQuantiles];
        for (int q = 0; q < numberOfQuantiles; ++q) {
            long sum = 0L;
            long values = 0L;
            for (int b = 0; b < n; ++b) {
                sum += sumValuesInQuantile[b][q];
                values += numberOfValuesInQuantile[b][q];
            }
            quantileMeans[q] = (double)sum / (double)values;
        }
        for (int b = 0; b < n; ++b) {
            YesNoCancelDialog yncd;
            File f = (File)fg.get(b);
            String path = f.getAbsolutePath();
            ImagePlus[] channels = BatchOpener.open((String)path);
            imagePlus = channels[channelToUse];
            String leafName = f.getName();
            int dotIndex = leafName.lastIndexOf(".");
            String newLeafName = dotIndex >= 0 ? leafName.substring(0, dotIndex) + "-normalized.tif" : leafName + "-normalized";
            File outputFile = new File(outputDirectory, newLeafName);
            Mask mask = null;
            if (maskFileName != null) {
                mask = new Mask(new File(maskFileName));
            } else if (useMaskPerImage) {
                mask = new Mask(this.getMaskFileFromImageFile(f));
            }
            Replacements[] meanReplacements = new Replacements[possibleImageValues];
            for (int value = 0; value < possibleImageValues; ++value) {
                meanReplacements[value] = new Replacements(possibleImageValues);
            }
            Replacements[] rankReplacements = new Replacements[possibleImageValues];
            for (int value = 0; value < possibleImageValues; ++value) {
                rankReplacements[value] = new Replacements(numberOfQuantiles);
            }
            int width = imagePlus.getWidth();
            int height = imagePlus.getHeight();
            int depth = imagePlus.getStackSize();
            IJ.showStatus((String)("Replacing values in: " + imagePlus.getShortTitle() + " ..."));
            this.generateReplacements(imagePlus, numberOfQuantiles, pointsInImage[b], frequencies[b], sumValuesInQuantile[b], numberOfValuesInQuantile[b], quantileMeans, rankReplacements, meanReplacements);
            IJ.showProgress((double)0.0);
            ImagePlus newImage = this.remapImage(imagePlus, numberOfQuantiles, replaceWithRankInstead, rescaleRanks, mask, rankReplacements, meanReplacements);
            if (outputFile.exists() && !(yncd = new YesNoCancelDialog((Frame)IJ.getInstance(), "Confirm", "The file " + outputFile.getAbsolutePath() + " already exists.  Overwrite it?")).yesPressed()) {
                if (yncd.cancelPressed()) {
                    IJ.showStatus((String)"Quantile based normalization cancelled.");
                    newImage.close();
                    return;
                }
                newImage.close();
                continue;
            }
            boolean saved = newImage.getStackSize() == 1 ? new FileSaver(newImage).saveAsTiff(outputFile.getAbsolutePath()) : new FileSaver(newImage).saveAsTiffStack(outputFile.getAbsolutePath());
            if (!saved) {
                return;
            }
            newImage.close();
            imagePlus.close();
        }
        IJ.showStatus((String)("Normalization complete: files written to: " + outputDirectory));
    }

    public void run(String ignored) {
        String[] defaultFiles = new String[]{};
        String defaultOutputDirectory = "";
        String defaultMaskFileName = "";
        GenericDialog gd = new GenericDialog("Quantile Based Normalization (version: 1.2)");
        FileGroup fg = new FileGroup("foo");
        for (int i = 0; i < defaultFiles.length; ++i) {
            fg.add(defaultFiles[i]);
        }
        FileGroupDialog fgd = new FileGroupDialog(fg, false);
        gd.addPanel((Panel)fgd);
        Panel outputDirectoryPanel = new Panel();
        outputDirectoryPanel.add(new Label("Output directory: "));
        this.outputDirectoryInput = new TextField(defaultOutputDirectory, 18);
        outputDirectoryPanel.add(this.outputDirectoryInput);
        this.chooseOutputDirectory = new Button("Choose ...");
        outputDirectoryPanel.add(this.chooseOutputDirectory);
        this.chooseOutputDirectory.addActionListener(this);
        gd.addPanel(outputDirectoryPanel);
        Panel useMaskPanel = new Panel();
        useMaskPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.anchor = 21;
        this.useMaskPerImageCheckbox = new Checkbox("Use a mask per image?");
        this.useMaskPerImageCheckbox.addItemListener(this);
        useMaskPanel.add((Component)this.useMaskPerImageCheckbox, c);
        ++c.gridy;
        c.anchor = 21;
        this.useMaskCheckbox = new Checkbox("Use a single image mask?");
        this.useMaskCheckbox.addItemListener(this);
        useMaskPanel.add((Component)this.useMaskCheckbox, c);
        ++c.gridy;
        useMaskPanel.add((Component)new Label("(If you use a single image mask, all images must be the same dimensions."), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        useMaskPanel.add((Component)new Label("Mask file: "), c);
        c.gridx = 1;
        this.maskFileInput = new TextField(defaultMaskFileName, 18);
        this.maskFileInput.setEnabled(false);
        useMaskPanel.add((Component)this.maskFileInput, c);
        c.gridx = 2;
        this.chooseMaskButton = new Button("Choose...");
        this.chooseMaskButton.setEnabled(false);
        useMaskPanel.add((Component)this.chooseMaskButton, c);
        gd.addPanel(useMaskPanel);
        gd.addNumericField("Number of channel to use (starting at 1): ", 1.0, 0);
        gd.addNumericField("Quantiles", 256.0, 0);
        String[] choices = new String[]{"mean", "rank"};
        gd.addChoice("Replace each quantile with", choices, "mean");
        gd.addCheckbox("Rescale (if replacing with ranks)", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String outputDirectory = this.outputDirectoryInput.getText();
        boolean useMask = this.useMaskCheckbox.getState();
        boolean useMaskPerImage = this.useMaskPerImageCheckbox.getState();
        if (useMask && useMaskPerImage) {
            IJ.error((String)"You can only choose one of the mask options.");
            return;
        }
        String maskFileName = null;
        if (useMask) {
            maskFileName = this.maskFileInput.getText();
        }
        int channelToUse = (int)gd.getNextNumber();
        --channelToUse;
        int numberOfQuantiles = (int)gd.getNextNumber();
        if (numberOfQuantiles < 1 || numberOfQuantiles > 65536) {
            IJ.error((String)"Number of quantiles must be between 1 and 65536 inclusive.");
            return;
        }
        boolean replaceWithRankInstead = false;
        String choice = gd.getNextChoice();
        replaceWithRankInstead = choice.equals("rank");
        boolean rescaleRanks = gd.getNextBoolean();
        this.processToDirectory(fg, outputDirectory, this.useMaskPerImageCheckbox.getState(), maskFileName, channelToUse, numberOfQuantiles, replaceWithRankInstead, rescaleRanks);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.chooseOutputDirectory) {
            DirectoryChooser dc = new DirectoryChooser("Choose output directory...");
            String directory = dc.getDirectory();
            if (directory != null) {
                this.outputDirectoryInput.setText(directory);
            }
        } else if (source == this.chooseMaskButton) {
            OpenDialog od = new OpenDialog("Select mask image file...", null, null);
            String fileName = od.getFileName();
            String directory = od.getDirectory();
            if (fileName == null) {
                return;
            }
            String fullFileName = directory + fileName;
            File maskFile = new File(fullFileName);
            if (maskFile.exists()) {
                this.maskFileInput.setText(fullFileName);
            } else {
                IJ.error((String)("The chosen mask file (" + fullFileName + ") doesn't exist."));
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.useMaskCheckbox) {
            boolean useMask = this.useMaskCheckbox.getState();
            this.maskFileInput.setEnabled(useMask);
            this.chooseMaskButton.setEnabled(useMask);
            this.useMaskPerImageCheckbox.setEnabled(!useMask);
        } else if (source == this.useMaskPerImageCheckbox) {
            boolean useMaskPerImage = this.useMaskPerImageCheckbox.getState();
            this.maskFileInput.setEnabled(!useMaskPerImage);
            this.chooseMaskButton.setEnabled(!useMaskPerImage);
            this.useMaskCheckbox.setEnabled(!useMaskPerImage);
        }
    }

    public static class Mask {
        File file;
        public boolean[][] inMask;
        int width;
        int height;
        int depth;
        long pointsInMask;

        public Mask(File maskFile) {
            this.file = maskFile;
            String path = maskFile.getAbsolutePath();
            IJ.showStatus((String)("Loading mask file: " + path));
            ImagePlus[] channels = BatchOpener.open((String)path);
            if (channels == null) {
                throw new RuntimeException("Couldn't open the mask file: " + path);
            }
            if (channels.length != 1) {
                throw new RuntimeException("The mask file must have one channel - " + path + " has " + channels.length);
            }
            ImagePlus maskImagePlus = channels[0];
            ImageStack maskStack = maskImagePlus.getStack();
            this.width = maskImagePlus.getWidth();
            this.height = maskImagePlus.getHeight();
            this.depth = maskImagePlus.getStackSize();
            this.inMask = new boolean[this.depth][this.width * this.height];
            this.pointsInMask = 0L;
            for (int z = 0; z < this.depth; ++z) {
                byte[] pixels = (byte[])maskStack.getPixels(z + 1);
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        if ((pixels[y * this.width + x] & 0xFF) <= 127) continue;
                        this.inMask[z][y * this.width + x] = true;
                        ++this.pointsInMask;
                    }
                }
            }
            maskImagePlus.close();
        }
    }

    class Replacements {
        HashMap<Integer, Long> replacements;
        long totalReplacements;
        int minReplacement = Integer.MAX_VALUE;
        int maxReplacement = Integer.MIN_VALUE;
        Random rng;
        int quantile;

        public Replacements(int possibleValues) {
            this.replacements = new HashMap();
            this.rng = new Random();
        }

        public void addSomeReplacements(long howManyToReplace, int replacement) {
            if (replacement < this.minReplacement) {
                this.minReplacement = replacement;
            }
            if (replacement > this.maxReplacement) {
                this.maxReplacement = replacement;
            }
            if (!this.replacements.containsKey(replacement)) {
                this.replacements.put(replacement, 0L);
            }
            long previousValue = this.replacements.get(replacement);
            this.replacements.put(replacement, previousValue + howManyToReplace);
            this.totalReplacements += howManyToReplace;
        }

        public int getRandomReplacement() {
            if (this.totalReplacements == 0L) {
                return -1;
            }
            long index = Math.abs(this.rng.nextLong()) % this.totalReplacements;
            long replacementsSkipped = 0L;
            for (int r = this.minReplacement; r <= this.maxReplacement; ++r) {
                if (!this.replacements.containsKey(r)) continue;
                long indexInThisSlot = index - replacementsSkipped;
                long numberOfReplacements = this.replacements.get(r);
                if (indexInThisSlot < numberOfReplacements) {
                    this.replacements.put(r, numberOfReplacements - 1L);
                    --this.totalReplacements;
                    return r;
                }
                replacementsSkipped += numberOfReplacements;
            }
            return -1;
        }

        public String toString() {
            if (this.totalReplacements == 0L) {
                return "No replacements left.";
            }
            String result = "" + this.totalReplacements + " replacements left (in";
            for (int i = this.minReplacement; i <= this.maxReplacement; ++i) {
                long numberOfReplacements = this.replacements.get(i);
                if (numberOfReplacements <= 0L) continue;
                result = result + " " + i + " (" + numberOfReplacements + ")";
            }
            return result;
        }
    }
}

