/*
 * Decompiled with CFR 0.152.
 */
package vib;

import distance.Euclidean;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.util.Vector;
import math3d.Point3d;
import process3d.Gradient_;
import process3d.Rebin_;
import process3d.Smooth_;
import vib.AugmentedLandmarkWarp_;
import vib.FastMatrix;
import vib.InterpolatedImage;
import vib.NaiveResampler;
import vib.RigidRegistration;
import vib.TransformedImage;

public class Raster_Rigid
implements PlugIn {
    ImagePlus templ;
    ImagePlus model;
    ImagePlus warped;
    private static final int INIT_WIDTH = 512;
    private static final double TOLERANCE = 1.0;
    private static final float SMOOTH = 4.0f;
    private static final int GRID_W = 3;
    private static final int GRID_H = 3;
    private static final int GRID_D = 2;
    private static final int STARTL = 3;
    private static final int STOPL = 1;
    private boolean verbose = false;
    private Vector transformations;
    private Vector centers;
    private FastMatrix globalRigid;

    public void run(String arg) {
        GenericDialog gd = new GenericDialog("Raster Rigid Registration");
        int[] wIDs = WindowManager.getIDList();
        if (wIDs == null) {
            IJ.error((String)"No images open");
            return;
        }
        String[] titles = new String[wIDs.length];
        for (int i = 0; i < wIDs.length; ++i) {
            titles[i] = WindowManager.getImage((int)wIDs[i]).getTitle();
        }
        gd.addChoice("Template", titles, titles[0]);
        gd.addChoice("Model", titles, titles[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.templ = WindowManager.getImage((String)gd.getNextChoice());
        this.model = WindowManager.getImage((String)gd.getNextChoice());
        this.register();
        this.warp(this.model);
        this.warped.show();
    }

    public void register() {
        ImagePlus t = this.preprocess(this.templ);
        ImagePlus m = this.preprocess(this.model);
        TransformedImage trans = new TransformedImage(t, m);
        trans.measure = new Euclidean();
        this.globalRigid = new RigidRegistration().rigidRegistration(trans, "", "", -1, -1, false, 4, 2, 1.0, 1, false, false, false, null);
        this.transformations = new Vector();
        this.centers = new Vector();
        int w = this.templ.getWidth();
        int h = this.templ.getHeight();
        int d = this.templ.getStackSize();
        int tw = w / 3;
        int th = h / 3;
        int td = d / 2;
        for (int iz = 0; iz < 3; ++iz) {
            int z = iz * (td / 2);
            if (z + 2 > d) {
                z = d - 2;
            }
            for (int iy = 0; iy < 5; ++iy) {
                int y = iy * (th / 2);
                if (y + 3 > h) {
                    y = h - 3;
                }
                for (int ix = 0; ix < 5; ++ix) {
                    int x = ix * (tw / 2);
                    if (x + 3 > w) {
                        x = w - 3;
                    }
                    trans.narrowBBox(x, x + tw, y, y + th, z, z + td);
                    float meanV = this.getMeanValue(trans.orig.image, x, y, z, tw, th, td);
                    if ((double)meanV <= 10.0) continue;
                    FastMatrix fm = new RigidRegistration().rigidRegistration(trans, "", this.globalRigid.toString(), -1, -1, false, 3, 3, 1.0, 1, false, false, false, null);
                    fm = fm.times(this.globalRigid);
                    this.transformations.add(fm);
                    this.centers.add(new Point3d((double)(x + tw / 2), (double)(y + th / 2), (double)(z + td / 2)));
                    if (!this.verbose) continue;
                    trans.setTransformation(fm);
                    ImagePlus tmp = trans.getTransformed();
                    tmp.setTitle("transformed_" + ix + "_" + iy + "_" + iz);
                    tmp.show();
                }
            }
        }
    }

    private ImagePlus preprocess(ImagePlus img) {
        int rx = Math.round(img.getWidth() / 512);
        int ry = Math.round(img.getHeight() / 512);
        int rz = Math.round(2 * img.getStackSize() / 512);
        if (rx == 0) {
            rx = 1;
        }
        if (ry == 0) {
            ry = 1;
        }
        if (rz == 0) {
            rz = 1;
        }
        if (rx != 1 || ry != 1 || rz != 1) {
            img = NaiveResampler.resample((ImagePlus)img, (int)rx, (int)ry, (int)rz);
        }
        img = Smooth_.smooth((ImagePlus)img, (boolean)true, (float)4.0f, (boolean)true);
        img = Gradient_.calculateGrad((ImagePlus)img, (boolean)true);
        img = Rebin_.rebin((ImagePlus)img, (int)256);
        return img;
    }

    private void warp(ImagePlus model) {
        AugmentedLandmarkWarp_ aw = new AugmentedLandmarkWarp_();
        aw.ii = new InterpolatedImage(this.templ).cloneDimensionsOnly();
        aw.model = new InterpolatedImage(model);
        FastMatrix[] fm = new FastMatrix[this.transformations.size()];
        this.transformations.toArray(fm);
        aw.matrix = fm;
        Point3d[] cen = new Point3d[this.centers.size()];
        this.centers.toArray(cen);
        aw.setCenter(cen);
        aw.run();
        aw.ii.image.setTitle(model + "_warped");
        this.warped = aw.ii.image;
    }

    private float getMeanValue(ImagePlus image, int x, int y, int z, int w, int h, int d) {
        float sum = 0.0f;
        float count = 0.0f;
        int width = image.getWidth();
        for (int zi = z; zi < z + d; ++zi) {
            byte[] p = (byte[])image.getStack().getPixels(zi + 1);
            for (int yi = y; yi < y + h; ++yi) {
                for (int xi = x; xi < x + h; ++xi) {
                    sum += (float)(p[yi * width + xi] & 0xFF);
                    count += 1.0f;
                }
            }
        }
        return sum / count;
    }
}

