/*
 * Decompiled with CFR 0.152.
 */
package vib.edge;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import inference.LogFuncs;
import vib.InterpolatedImage;
import vib.MaxEntHistogram;
import vib.VIB;
import vib.edge.CircleIterators;
import vib.edge.Harmonic;
import vib.edge.SphereIterators;

public class Dirichlet_Edge
implements PlugInFilter {
    ImagePlus image;
    ImageStack angleStack;
    static final String[] types = new String[]{"MutualInformation", "DirichletMutualInformation", "Dirichlet", "Jensen", "Endres", "Euclidean", "DirichletVarianceMutualInformation", "Dirichlet2"};
    private int maxBin = 255;
    static final Harmonic _harmonic = new Harmonic();

    public void run(ImageProcessor ip) {
        ImageStack stack = this.image.getStack();
        GenericDialog gd = new GenericDialog("Parameters");
        gd.addChoice("measure", types, "DirichletMutualInformation");
        gd.addNumericField("radius", 7.0, 2);
        gd.addCheckbox("useSelection", false);
        gd.addCheckbox("showSelection", false);
        gd.addCheckbox("3d", stack.getSize() > 1);
        String[] histoPost = new String[]{"none", "constant", "binom", "maxEnt"};
        gd.addChoice("histogramPostProcessing", histoPost, "none");
        gd.addCheckbox("showAngles", false);
        gd.addCheckbox("showEdgelets", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String measureString = gd.getNextChoice();
        Measure measure = measureString.equals("DirichletMutualInformation") ? new DirichletMutualInformation() : (measureString.equals("Endres") ? new Endres() : (measureString.equals("MutualInformation") ? new MutualInformation() : (measureString.equals("Jensen") ? new Jensen() : (measureString.equals("Euclidean") ? new Euclidean() : (measureString.equals("DirichletVarianceMutualInformation") ? new DirichletVarianceMutualInformation() : (measureString.equals("Dirichlet2") ? new Dirichlet2() : new Dirichlet()))))));
        double radius = gd.getNextNumber();
        boolean useSelection = gd.getNextBoolean();
        boolean showSelection = gd.getNextBoolean();
        boolean use3d = gd.getNextBoolean();
        int postProc = gd.getNextChoiceIndex();
        boolean showAngles = gd.getNextBoolean();
        boolean showEdgelets = gd.getNextBoolean();
        ImageStack res = new ImageStack(stack.getWidth(), stack.getHeight());
        if (this.angleStack == null) {
            this.angleStack = new ImageStack(stack.getWidth(), stack.getHeight());
        }
        InterpolatedImage ii = new InterpolatedImage(this.image);
        if (use3d) {
            this.do3d(this.image, res, measure, radius);
        } else {
            for (int s = 1; s <= stack.getSize(); ++s) {
                if (useSelection) {
                    res.addSlice("", (ImageProcessor)this.doitWithSelection(stack.getProcessor(s), measure, radius, showSelection));
                    continue;
                }
                res.addSlice("", (ImageProcessor)this.doit(ii, s - 1, measure, radius, postProc, showAngles, showEdgelets));
            }
        }
        if (showAngles) {
            new ImagePlus("Angles of " + measureString + radius, this.angleStack).show();
        }
        new ImagePlus(measureString + radius, res).show();
    }

    private FloatProcessor doit(InterpolatedImage ii, int slice, Measure measure, double radius, int postProcessHistogram, boolean showAngles, boolean showEdgelets) {
        int j;
        int i;
        int w = ii.getWidth();
        int h = ii.getHeight();
        double[] res2 = new double[w * h];
        int nbins = 0;
        boolean[] isfull = new boolean[256];
        for (i = 0; i < w; ++i) {
            for (j = 0; j < w; ++j) {
                isfull[ii.getNoInterpol((int)i, (int)j, (int)slice)] = true;
            }
        }
        this.maxBin = 0;
        for (i = 0; i < 256; ++i) {
            if (!isfull[i]) continue;
            ++nbins;
            this.maxBin = i;
        }
        VIB.println((String)("Number of values in image is " + nbins));
        EdgeInformation edgeInfo = new EdgeInformation(ii, measure, radius, this.maxBin, nbins);
        edgeInfo.slice = slice;
        edgeInfo.setPostProc(postProcessHistogram);
        if (measure instanceof DirichletVarianceMutualInformation) {
            edgeInfo.var = (DirichletVarianceMutualInformation)measure;
        }
        if (showAngles) {
            edgeInfo.angles = new double[w * h];
        }
        if (showEdgelets) {
            edgeInfo.initEdgelets();
        }
        for (j = 0; j < h; ++j) {
            for (int i2 = 0; i2 < w; ++i2) {
                res2[i2 + j * w] = edgeInfo.getEdgeInformation(i2, j);
            }
            IJ.showProgress((int)(j + 1), (int)h);
        }
        edgeInfo.postLudium();
        if (showAngles) {
            this.angleStack.addSlice("", (ImageProcessor)new FloatProcessor(w, h, edgeInfo.angles));
        }
        FloatProcessor ip2 = new FloatProcessor(w, h, res2);
        return ip2;
    }

    public void do3d(ImagePlus stack, ImageStack result, Measure measure, double radius) {
        InterpolatedImage input = new InterpolatedImage(stack);
        int[][] sphereIterator = SphereIterators.SphereIterator((double)radius);
        double[] normal = new double[]{1.0, 0.0, 0.0};
        GenericDialog gd = new GenericDialog("Normal Coordinates");
        gd.addNumericField("x", normal[0], 3);
        gd.addNumericField("y", normal[1], 3);
        gd.addNumericField("z", normal[2], 3);
        gd.showDialog();
        if (!gd.wasCanceled()) {
            normal[0] = gd.getNextNumber();
            normal[1] = gd.getNextNumber();
            normal[2] = gd.getNextNumber();
        }
        int w = input.getWidth();
        int h = input.getHeight();
        int d = input.getDepth();
        IJ.showProgress((double)0.0);
        for (int z = 0; z < d; ++z) {
            double[] slice = new double[w * h];
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    double value = 0.0;
                    int[][] histograms = new int[3][this.maxBin + 1];
                    for (int i = 0; i < sphereIterator.length; ++i) {
                        try {
                            int v = input.getNoInterpol(x + sphereIterator[i][0], y + sphereIterator[i][1], z + sphereIterator[i][2]);
                            int[] nArray = histograms[SphereIterators.isUpperHalf((int[])sphereIterator[i], (double[])normal) ? 0 : 1];
                            int n = v;
                            nArray[n] = nArray[n] + 1;
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    for (int k = 0; k < histograms[0].length; ++k) {
                        value += measure.doit(histograms[0][k], histograms[1][k]);
                    }
                    slice[x + w * y] = value;
                }
                IJ.showProgress((double)(((double)y + 1.0) / (double)h));
            }
            result.addSlice("", (ImageProcessor)new FloatProcessor(w, h, slice));
            IJ.showProgress((double)(((double)z + 1.0) / (double)d));
        }
        IJ.showProgress((double)1.0);
    }

    public void do3d_complete(ImagePlus stack, ImageStack result, Measure measure, double radius) {
        InterpolatedImage input = new InterpolatedImage(stack);
        int[][] sphereIterator = SphereIterators.SphereIterator((double)radius);
        double[][] normals = SphereIterators.SampleSphereSurface((double)radius, (double)10.0);
        int[][][] iterIterator = SphereIterators.HalfSphereIteratorsIterator((double)radius, (double[][])normals);
        int w = input.getWidth();
        int h = input.getHeight();
        int d = input.getDepth();
        IJ.showProgress((double)0.0);
        for (int z = d / 2; z < d / 2 + 1; ++z) {
            double[] slice = new double[w * h];
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    double value = 0.0;
                    int[][] histograms = new int[2][this.maxBin + 1];
                    for (int i = 0; i < sphereIterator.length; ++i) {
                        try {
                            int v = input.getNoInterpol(x + sphereIterator[i][0], y + sphereIterator[i][1], z + sphereIterator[i][2]);
                            int[] nArray = histograms[SphereIterators.isUpperHalf((int[])sphereIterator[i], (double[])normals[0]) ? 0 : 1];
                            int n = v;
                            nArray[n] = nArray[n] + 1;
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    for (int k = 0; k < histograms[0].length; ++k) {
                        value += measure.doit(histograms[0][k], histograms[1][k]);
                    }
                    double maxValue = value;
                    for (int i = 0; i < iterIterator.length; ++i) {
                        for (int k = 0; k < iterIterator[i].length; ++k) {
                            int value2;
                            int value1 = input.getNoInterpol(x + iterIterator[i][k][0], y + iterIterator[i][k][1], z + iterIterator[i][k][2]);
                            if (value1 == (value2 = input.getNoInterpol(x - iterIterator[i][k][0], y - iterIterator[i][k][1], z - iterIterator[i][k][2]))) continue;
                            double old = measure.doit(histograms[0][value1], histograms[1][value1]) + measure.doit(histograms[0][value2], histograms[1][value2]);
                            int[] nArray = histograms[0];
                            int n = value1;
                            nArray[n] = nArray[n] - 1;
                            int[] nArray2 = histograms[1];
                            int n2 = value1;
                            nArray2[n2] = nArray2[n2] + 1;
                            int[] nArray3 = histograms[0];
                            int n3 = value2;
                            nArray3[n3] = nArray3[n3] + 1;
                            int[] nArray4 = histograms[1];
                            int n4 = value2;
                            nArray4[n4] = nArray4[n4] - 1;
                            double diff = measure.doit(histograms[0][value1], histograms[1][value1]) + measure.doit(histograms[0][value2], histograms[1][value2]) - old;
                            value += diff;
                        }
                        if (!(value > maxValue)) continue;
                        maxValue = value;
                    }
                    slice[x + w * y] = maxValue;
                }
                IJ.showProgress((double)(((double)y + 1.0) / (double)h));
            }
            result.addSlice("", (ImageProcessor)new FloatProcessor(w, h, slice));
            IJ.showProgress((double)(((double)z + 1.0) / (double)d));
        }
        IJ.showProgress((double)1.0);
    }

    private void line(double[] floats, int w, int h, int x1, int y1, int x2, int y2, double value) {
        float dy;
        float dx = Math.abs(x2 - x1);
        double count = dx > (dy = (float)Math.abs(y2 - y1)) ? dx : dy;
        for (double i = 0.0; i < count; i += 1.0) {
            int x = (int)((double)x1 + (double)(x2 - x1) * i / count);
            int y = (int)((double)y1 + (double)(y2 - y1) * i / count);
            if (x < 0 || y < 0 || x >= w || y >= h || !(value > floats[x + y * w])) continue;
            floats[x + y * w] = value;
        }
    }

    private FloatProcessor doitWithSelection(ImageProcessor ip, Measure measure, double radius, boolean showSelection) {
        return null;
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 1;
    }

    static class EdgeInformation {
        InterpolatedImage ii;
        Measure measure;
        MeasureWithNullModel nullMeasure;
        double radius;
        int maxBin;
        int numberOfBins;
        private PostProcessHistogram postProc;
        int slice;
        int[][] fullCircle;
        int[][] halfCircle;
        int[][] histograms;
        private int angleIndex;
        double[] angles;
        DirichletVarianceMutualInformation var = null;
        double maxMutInf = 1.0E-300;
        double maxVarMutInf = 1.0E-300;
        double maxMutInfRatio = 1.0E-300;
        int[][][] edgelets = null;
        double[] res3 = null;

        public EdgeInformation(ImagePlus image, Measure measure, double radius, int maxBin, int numberOfBins) {
            this(new InterpolatedImage(image), measure, radius, maxBin, numberOfBins);
            this.slice = image.getCurrentSlice() - 1;
        }

        public EdgeInformation(InterpolatedImage image, Measure measure, double radius, int maxBin, int numberOfBins) {
            this.ii = image;
            this.measure = measure;
            if (measure instanceof MeasureWithNullModel) {
                this.nullMeasure = (MeasureWithNullModel)measure;
            }
            this.radius = radius;
            this.maxBin = maxBin;
            this.numberOfBins = numberOfBins;
            this.histograms = new int[2][maxBin + 1];
            this.fullCircle = CircleIterators.FullCircle((double)radius, (boolean)false);
            this.halfCircle = CircleIterators.SortedHalfCircle((double)radius);
            int[][] sickle = CircleIterators.RightSickle((double)radius);
        }

        void setPostProc(int index) {
            if (index != 0) {
                this.postProc = new PostProcessHistogram(index);
            }
        }

        void resetHistograms() {
            this.histograms = new int[2][this.maxBin + 1];
        }

        void calculateHistograms(int x, int y, int z) {
            this.resetHistograms();
            for (int k = 0; k < this.fullCircle.length; ++k) {
                int i = x + this.fullCircle[k][0];
                int j = y + this.fullCircle[k][1];
                int value = this.ii.getNoInterpol(i, j, z);
                if (this.fullCircle[k][1] > 0 || this.fullCircle[k][1] == 0 && this.fullCircle[k][0] > 0) {
                    int[] nArray = this.histograms[0];
                    int n = value;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                int[] nArray = this.histograms[1];
                int n = value;
                nArray[n] = nArray[n] + 1;
            }
            if (this.postProc != null) {
                this.histograms = this.postProc.postProcessHisto(this.histograms);
                System.err.println("quantized for " + x + ", " + y + ", " + z);
            }
        }

        void calculateHistograms(int x, int y, int z, double xperp, double yperp) {
            this.resetHistograms();
            for (int k = 0; k < this.fullCircle.length; ++k) {
                int i = x + this.fullCircle[k][0];
                int j = y + this.fullCircle[k][1];
                int value = this.ii.getNoInterpol(i, j, z);
                double scalarProduct = (double)this.fullCircle[k][0] * xperp + (double)this.fullCircle[k][1] * yperp;
                if (scalarProduct > 0.0) {
                    int[] nArray = this.histograms[0];
                    int n = value;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                if (!(scalarProduct < 0.0)) continue;
                int[] nArray = this.histograms[1];
                int n = value;
                nArray[n] = nArray[n] + 1;
            }
            if (this.postProc != null) {
                this.histograms = this.postProc.postProcessHisto(this.histograms);
            }
        }

        double getEdgeInformation(int i, int j, double xPerp, double yPerp) {
            return this.getEdgeInformation(i, j, this.slice, xPerp, yPerp);
        }

        double getEdgeInformation(int i, int j, int z, double xPerp, double yPerp) {
            this.calculateHistograms(i, j, z, xPerp, yPerp);
            double value = 0.0;
            for (int k = 0; k < this.histograms[0].length; ++k) {
                value += this.measure.doit(this.histograms[0][k], this.histograms[1][k]);
            }
            if (this.nullMeasure != null) {
                value += this.nullMeasure.getNormalize(this.fullCircle.length, this.numberOfBins);
                double nullEv = 0.0;
                double edgePrior = 0.001;
                for (int k = 0; k < this.histograms[0].length; ++k) {
                    nullEv += this.nullMeasure.doitNull(this.histograms[0][k], this.histograms[1][k]);
                }
                nullEv += this.nullMeasure.getNormalizeNull(this.fullCircle.length, this.numberOfBins);
                value += Math.log(edgePrior);
                value = Math.exp(value - (nullEv += Math.log(1.0 - edgePrior)));
            }
            return value;
        }

        double getEdgeInformation(int i, int j) {
            return this.getEdgeInformation(i, j, this.slice);
        }

        double getEdgeInformation(int i, int j, int z) {
            this.calculateHistograms(i, j, z);
            double value = 0.0;
            for (int k = 0; k < this.histograms[0].length; ++k) {
                value += this.measure.doit(this.histograms[0][k], this.histograms[1][k]);
            }
            if (this.nullMeasure != null) {
                value += this.nullMeasure.getNormalize(this.fullCircle.length, this.numberOfBins);
            }
            double maxValue = value;
            double tempValue = value;
            double edgeEvidenceSum = -1.0E300;
            this.angleIndex = 0;
            for (int k = 0; k < this.halfCircle.length; ++k) {
                int value2;
                int value1 = this.ii.getNoInterpol(i + this.halfCircle[k][0], j + this.halfCircle[k][1], z);
                if (value1 != (value2 = this.ii.getNoInterpol(i - this.halfCircle[k][0], j - this.halfCircle[k][1], z))) {
                    if (this.postProc != null && this.postProc.mapping != null) {
                        if ((value1 = this.postProc.mapping[value1]) < 0) {
                            value1 += 256;
                        }
                        if ((value2 = this.postProc.mapping[value2]) < 0) {
                            value2 += 256;
                        }
                    }
                    double old = this.measure.doit(this.histograms[0][value1], this.histograms[1][value1]) + this.measure.doit(this.histograms[0][value2], this.histograms[1][value2]);
                    int[] nArray = this.histograms[0];
                    int n = value1;
                    nArray[n] = nArray[n] - 1;
                    int[] nArray2 = this.histograms[1];
                    int n2 = value1;
                    nArray2[n2] = nArray2[n2] + 1;
                    int[] nArray3 = this.histograms[0];
                    int n3 = value2;
                    nArray3[n3] = nArray3[n3] + 1;
                    int[] nArray4 = this.histograms[1];
                    int n4 = value2;
                    nArray4[n4] = nArray4[n4] - 1;
                    double diff = this.measure.doit(this.histograms[0][value1], this.histograms[1][value1]) + this.measure.doit(this.histograms[0][value2], this.histograms[1][value2]) - old;
                    if ((tempValue += diff) > maxValue) {
                        maxValue = tempValue;
                        this.angleIndex = k;
                    }
                }
                edgeEvidenceSum = LogFuncs.LogAddLogLog((double)edgeEvidenceSum, (double)tempValue);
            }
            if (this.nullMeasure != null) {
                double nullEv = 0.0;
                double edgePrior = 0.001;
                for (int k = 0; k < this.histograms[0].length; ++k) {
                    nullEv += this.nullMeasure.doitNull(this.histograms[0][k], this.histograms[1][k]);
                }
                nullEv += this.nullMeasure.getNormalizeNull(this.fullCircle.length, this.numberOfBins);
                maxValue += Math.log(edgePrior);
                maxValue = Math.exp(maxValue - LogFuncs.LogAddLogLog((double)(edgeEvidenceSum += Math.log(edgePrior)), (double)(nullEv += Math.log(1.0 - edgePrior))));
            }
            if (this.var != null) {
                this.calculateVariance(maxValue, i, j);
            }
            if (this.edgelets != null) {
                this.drawEdgelet(maxValue, i, j);
            }
            if (this.angles != null) {
                this.setAngle(i, j);
            }
            return maxValue;
        }

        void setAngle(int i, int j) {
            this.angles[i + j * this.ii.getWidth()] = Math.atan2(this.halfCircle[this.angleIndex][0], this.halfCircle[this.angleIndex][1]);
        }

        void calculateVariance(double maxValue, int i, int j) {
            double v;
            double maxValueBup = maxValue;
            if (this.maxMutInf < maxValue) {
                this.maxMutInf = maxValue;
            }
            this.calculateHistograms(i, j, this.slice);
            maxValue = this.var.variance(this, i, j, this.angleIndex);
            if (this.maxVarMutInf < maxValue) {
                this.maxVarMutInf = maxValue;
            }
            if (maxValueBup != 0.0 && (v = Math.sqrt(maxValue) / maxValueBup) > this.maxMutInfRatio) {
                this.maxMutInfRatio = v;
            }
        }

        double getMaxVariance() {
            return _harmonic.get(4 * this.halfCircle.length) - _harmonic.get(2 * this.halfCircle.length) + 1.0 / (4.0 * (double)this.halfCircle.length) * this.maxMutInf;
        }

        void initEdgelets() {
            this.edgelets = CircleIterators.Edgelets((int[][])this.halfCircle, (double)this.radius);
            this.res3 = new double[this.ii.getWidth() * this.ii.getHeight()];
        }

        void drawEdgelet(double maxValue, int i, int j) {
            for (int l = 0; l < this.edgelets[this.angleIndex].length; ++l) {
                int x = i + this.edgelets[this.angleIndex][l][0];
                int y = j + this.edgelets[this.angleIndex][l][1];
                if (x < 0 || x >= this.ii.getWidth() || y < 0 || y >= this.ii.getHeight() || !(this.res3[x + y * this.ii.getWidth()] < maxValue)) continue;
                this.res3[x + y * this.ii.getWidth()] = maxValue;
            }
        }

        void postLudium() {
            if (this.var != null) {
                double realMaxMutInf = this.getMaxVariance();
                IJ.log((String)("maximal MutInf: " + realMaxMutInf + ", maximal variance: " + this.maxVarMutInf + " (std. dev.: " + Math.sqrt(this.maxVarMutInf) + "), ratio: " + this.maxMutInfRatio));
            }
            if (this.res3 != null) {
                new ImagePlus("Edgelets", (ImageProcessor)new FloatProcessor(this.ii.getWidth(), this.ii.getHeight(), this.res3)).show();
            }
        }
    }

    static class EdgeInformation3d {
        InterpolatedImage image;
        Measure measure;
        MeasureWithNullModel nullMeasure;
        double radius;
        int[][] sphere;
        int[][] histograms;

        public EdgeInformation3d(ImagePlus ip, Measure m, double r) {
            this(new InterpolatedImage(ip), m, r);
        }

        public EdgeInformation3d(InterpolatedImage i, Measure m, double r) {
            this.image = i;
            this.measure = m;
            if (this.measure instanceof MeasureWithNullModel) {
                this.nullMeasure = (MeasureWithNullModel)this.measure;
            }
            this.radius = r;
            Calibration c = i.image.getCalibration();
            this.sphere = SphereIterators.SphereIterator((double)r, (double)c.pixelWidth, (double)c.pixelHeight, (double)c.pixelDepth);
            this.histograms = new int[2][256];
        }

        void calculateHistograms(int x, int y, int z, double nx, double ny, double nz) {
            for (int i = 0; i < this.sphere.length; ++i) {
                int[] p = this.sphere[i];
                double dist = (double)p[0] * nx + (double)p[1] * ny + (double)p[2] * nz;
                if (dist == 0.0) continue;
                int value = this.image.getNoInterpol(x + p[0], y + p[1], z + p[2]);
                int[] nArray = this.histograms[dist > 0.0 ? 1 : 0];
                int n = value;
                nArray[n] = nArray[n] + 1;
            }
        }

        void resetHistograms() {
            for (int i = 0; i < this.histograms[0].length; ++i) {
                this.histograms[1][i] = 0;
                this.histograms[0][i] = 0;
            }
        }

        double get(int x, int y, int z, double nx, double ny, double nz) {
            this.resetHistograms();
            this.calculateHistograms(x, y, z, nx, ny, nz);
            double result = 0.0;
            for (int i = 0; i < this.histograms[0].length; ++i) {
                result += this.measure.doit(this.histograms[0][i], this.histograms[1][i]);
            }
            if (this.nullMeasure != null) {
                result += this.nullMeasure.getNormalize(this.sphere.length, 256);
                double nullEv = 0.0;
                double edgePrior = 0.001;
                for (int k = 0; k < this.histograms[0].length; ++k) {
                    nullEv += this.nullMeasure.doitNull(this.histograms[0][k], this.histograms[1][k]);
                }
                nullEv += this.nullMeasure.getNormalizeNull(this.sphere.length, 256);
                result += Math.log(edgePrior);
                result = Math.exp(result - (nullEv += Math.log(1.0 - edgePrior)));
            }
            return result;
        }
    }

    public static class PostProcessHistogram {
        int postProcessIndex;
        byte[] mapping;
        static final int postProcessWidth = 20;
        double[] pp2;

        public PostProcessHistogram(int index) {
            this.postProcessIndex = index;
            System.err.println("index: " + index);
        }

        public int[][] postProcessHisto(int[][] histograms) {
            if (this.postProcessIndex == 3) {
                MaxEntHistogram h = new MaxEntHistogram(histograms);
                h.quantize(4);
                this.mapping = h.getMapping(true);
                return h.get(histograms);
            }
            int[] h1 = this.postProcessHisto(histograms[0]);
            int[] h2 = this.postProcessHisto(histograms[1]);
            histograms[0] = h1;
            histograms[1] = h2;
            return histograms;
        }

        int[] postProcessHisto(int[] histogram) {
            int i;
            int length = histogram.length;
            int[] result = new int[length];
            if (this.postProcessIndex == 2 && this.pp2 == null) {
                this.pp2 = new double[41];
                this.pp2[0] = 1.0;
                for (i = -19; i <= 20; ++i) {
                    this.pp2[i + 20] = this.pp2[i + 20 - 1] * (double)(41 - (i + 20)) / (double)(i + 20);
                }
            }
            for (i = 0; i < length; ++i) {
                int max;
                int min = i > 20 ? i - 20 : 0;
                int n = max = i < length - 1 - 20 ? i + 1 + 20 : length + 1 - 1;
                if (this.postProcessIndex == 1) {
                    for (int j = min; j < max; ++j) {
                        int n2 = i;
                        result[n2] = result[n2] + histogram[j];
                    }
                    int n3 = i;
                    result[n3] = result[n3] / (max - min);
                    continue;
                }
                if (this.postProcessIndex != 2) continue;
                double total = 0.0;
                double r = 0.0;
                for (int j = min; j < max; ++j) {
                    double value = this.pp2[20 + j - i];
                    total += value;
                    r += (double)histogram[j] * value;
                }
                if (r < 0.0) {
                    throw new RuntimeException("result[" + i + "]=" + result[i]);
                }
                result[i] = (int)(r / total);
            }
            return result;
        }
    }

    static class Dummy
    implements Measure {
        Dummy() {
        }

        @Override
        public double doit(int count1, int count2) {
            return count1 + count2;
        }
    }

    static class Euclidean
    implements Measure {
        Euclidean() {
        }

        @Override
        public double doit(int count1, int count2) {
            int diff = count1 - count2;
            return diff * diff;
        }
    }

    static class Jensen
    implements Measure {
        Jensen() {
        }

        @Override
        public double doit(int count1, int count2) {
            return count1 * count2;
        }
    }

    static class MutualInformation
    implements Measure {
        MutualInformation() {
        }

        @Override
        public double doit(int count1, int count2) {
            int sum = count1 + count2;
            if (sum == 0) {
                return 0.0;
            }
            double result = (double)(-sum) * Math.log(sum);
            if (count1 != 0) {
                result += (double)count1 * Math.log(count1);
            }
            if (count2 != 0) {
                result += (double)count2 * Math.log(count2);
            }
            return result;
        }
    }

    static class DirichletVarianceMutualInformation
    extends DirichletMutualInformation {
        DirichletVarianceMutualInformation() {
        }

        public double variance(EdgeInformation edgeInfo, int i, int j, int halfCircleEndIndex) {
            int k;
            int[][] privHisto = new int[2][edgeInfo.histograms[0].length];
            for (k = 0; k < edgeInfo.histograms[0].length; ++k) {
                privHisto[0][k] = edgeInfo.histograms[0][k];
                privHisto[1][k] = edgeInfo.histograms[1][k];
            }
            for (k = 0; k <= halfCircleEndIndex; ++k) {
                int value2;
                int value1 = edgeInfo.ii.getNoInterpol(i + edgeInfo.halfCircle[k][0], j + edgeInfo.halfCircle[k][1], edgeInfo.slice);
                if (value1 == (value2 = edgeInfo.ii.getNoInterpol(i - edgeInfo.halfCircle[k][0], j - edgeInfo.halfCircle[k][1], edgeInfo.slice))) continue;
                int[] nArray = privHisto[0];
                int n = value1;
                nArray[n] = nArray[n] - 1;
                int[] nArray2 = privHisto[1];
                int n2 = value1;
                nArray2[n2] = nArray2[n2] + 1;
                int[] nArray3 = privHisto[0];
                int n3 = value2;
                nArray3[n3] = nArray3[n3] + 1;
                int[] nArray4 = privHisto[1];
                int n4 = value2;
                nArray4[n4] = nArray4[n4] - 1;
            }
            double n = edgeInfo.halfCircle.length * 2;
            double nIDot = 0.5;
            double sum1 = 0.0;
            double sum2 = 0.0;
            for (int k2 = 0; k2 < privHisto[0].length; ++k2) {
                double lg;
                double nDotJ = privHisto[0][k2] + privHisto[1][k2];
                if (nDotJ == 0.0) continue;
                double nij = privHisto[0][k2];
                if (nij != 0.0) {
                    lg = Math.log(nij * n / nIDot / nDotJ);
                    sum1 += nij / n * lg * lg;
                    sum2 += nij / n * lg;
                }
                if ((nij = (double)privHisto[1][k2]) == 0.0) continue;
                lg = Math.log(nij * n / nIDot / nDotJ);
                sum1 += nij / n * lg * lg;
                sum2 += nij / n * lg;
            }
            return (sum1 - sum2 * sum2) / n;
        }
    }

    static class DirichletMutualInformation
    implements Measure {
        DirichletMutualInformation() {
        }

        @Override
        public double doit(int count1, int count2) {
            return (double)(-(count1 + 1)) * _harmonic.get(count1 + 1, count1 + count2 + 2) - (double)(count2 + 1) * _harmonic.get(count2 + 1, count1 + count2 + 2);
        }
    }

    static class Dirichlet
    implements Measure {
        Dirichlet() {
        }

        @Override
        public double doit(int count1, int count2) {
            return LogFuncs.LogFactorial((int)count1) + LogFuncs.LogFactorial((int)count2) - LogFuncs.LogFactorial((int)(count1 + count2 + 1));
        }
    }

    static class Endres
    implements Measure {
        Endres() {
        }

        @Override
        public double doit(int count1, int count2) {
            int denom = count1 + count2;
            if (denom == 0) {
                return 0.0;
            }
            double result = 0.0;
            if (count1 != 0) {
                result += (double)count1 * Math.log((double)count1 * 2.0 / (double)denom);
            }
            if (count2 != 0) {
                result += (double)count2 * Math.log((double)count2 * 2.0 / (double)denom);
            }
            return result;
        }
    }

    static class Dirichlet2
    implements MeasureWithNullModel {
        Dirichlet2() {
        }

        @Override
        public double doit(int count1, int count2) {
            return LogFuncs.LogFactorial((int)count1) + LogFuncs.LogFactorial((int)count2);
        }

        @Override
        public double doitNull(int count1, int count2) {
            return LogFuncs.LogFactorial((int)(count1 + count2));
        }

        @Override
        public double getNormalize(int totcount, int numbins) {
            return 2.0 * (LogFuncs.LogFactorial((int)numbins) - LogFuncs.LogFactorial((int)(totcount / 2 + numbins)));
        }

        @Override
        public double getNormalizeNull(int totcount, int numbins) {
            return LogFuncs.LogFactorial((int)numbins) - LogFuncs.LogFactorial((int)(totcount + numbins));
        }
    }

    static interface MeasureWithNullModel
    extends Measure {
        public double doitNull(int var1, int var2);

        public double getNormalize(int var1, int var2);

        public double getNormalizeNull(int var1, int var2);
    }

    static interface Measure {
        public double doit(int var1, int var2);
    }
}

