/*
 * Decompiled with CFR 0.152.
 */
package video;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.BoxLayout;
import video.VideoStack;

public class Edit_Video
implements PlugIn,
ActionListener {
    private VideoStack stack;
    private ImagePlus preview;
    private int speed = 10;
    private int color = 0xFF0000;
    private int alpha = 128;
    private int linewidth = 2;

    public void setColor(int c) {
        this.color = c;
    }

    public int getColor() {
        return this.color;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setLinewidth(int l) {
        this.linewidth = l;
    }

    public int getLinewidth() {
        return this.linewidth;
    }

    public VideoStack getStack() {
        return this.stack;
    }

    public void run(String arg) {
        GenericDialog gd = new GenericDialog("Video editing");
        Panel all = new Panel();
        BoxLayout bl = new BoxLayout(all, 1);
        all.setLayout(bl);
        BorderPanel p = new BorderPanel();
        p.setLayout(new GridLayout(1, 2, 5, 5));
        p.add(new Label("Open video"));
        Button b = new Button("Open");
        b.addActionListener(this);
        p.add(b);
        all.add(p);
        p = new BorderPanel();
        p.setLayout(new GridLayout(3, 2));
        p.add(new Label("Add empty frame"));
        b = new Button("Add Frame");
        b.addActionListener(this);
        p.add(b);
        p.add(new Label("Copy frame"));
        b = new Button("Copy Frame");
        b.addActionListener(this);
        p.add(b);
        p.add(new Label("Delete Frame"));
        b = new Button("Delete Frame");
        b.addActionListener(this);
        p.add(b);
        all.add(p);
        p = new BorderPanel();
        p.setLayout(new GridLayout(2, 2));
        p.add(new Label("Open Frame"));
        b = new Button("Open Frame");
        b.addActionListener(this);
        p.add(b);
        p.add(new Label("Set Frame"));
        b = new Button("Set Frame");
        b.addActionListener(this);
        p.add(b);
        all.add(p);
        p = new BorderPanel();
        p.setLayout(new GridLayout(6, 2));
        p.add(new Label("Fade over"));
        b = new Button("Fade over");
        b.addActionListener(this);
        p.add(b);
        p.add(new Label("Draw Line"));
        b = new Button("Draw Line");
        b.addActionListener(this);
        p.add(b);
        p.add(new Label("Draw Oval"));
        b = new Button("Draw Oval");
        b.addActionListener(this);
        p.add(b);
        p.add(new Label("Draw Roi"));
        b = new Button("Draw Roi");
        b.addActionListener(this);
        p.add(b);
        p.add(new Label("Fill Roi transparent"));
        b = new Button("Fill Roi transparent");
        b.addActionListener(this);
        p.add(b);
        p.add(new Label("Move Selection"));
        b = new Button("Move Selection");
        b.addActionListener(this);
        p.add(b);
        all.add(p);
        p = new BorderPanel();
        p.setLayout(new GridLayout(2, 2));
        p.add(new Label("Create AVI"));
        b = new Button("Create AVI");
        b.addActionListener(this);
        p.add(b);
        p.add(new Label("Play AVI"));
        b = new Button("Play AVI");
        b.addActionListener(this);
        p.add(b);
        all.add(p);
        gd.addPanel(all);
        gd.setModal(false);
        gd.showDialog();
        bl.layoutContainer(all);
        all.repaint();
        if (gd.wasCanceled()) {
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Open")) {
            this.open();
        } else if (e.getActionCommand().equals("Add Frame")) {
            this.addFrame();
        } else if (e.getActionCommand().equals("Copy Frame")) {
            this.copyFrame();
        } else if (e.getActionCommand().equals("Open Frame")) {
            this.openFrame();
        } else if (e.getActionCommand().equals("Set Frame")) {
            this.setFrame();
        } else if (e.getActionCommand().equals("Delete Frame")) {
            this.deleteFrame();
        } else if (e.getActionCommand().equals("Fade over")) {
            this.fadeOver();
        } else if (e.getActionCommand().equals("Draw Line")) {
            this.drawLine();
        } else if (e.getActionCommand().equals("Draw Roi")) {
            this.drawRoi();
        } else if (e.getActionCommand().equals("Fill Roi transparent")) {
            this.fillRoiTransparent();
        } else if (e.getActionCommand().equals("Draw Oval")) {
            this.drawOval();
        } else if (e.getActionCommand().equals("Move Selection")) {
            this.moveSelection();
        } else if (e.getActionCommand().equals("Create AVI")) {
            this.createAVI();
        } else if (e.getActionCommand().equals("Play AVI")) {
            this.playAVI();
        }
        System.out.println("done");
    }

    public void open() {
        this.stack = new VideoStack();
        String dir = "/home/bene/Desktop/video";
        String basename = "template";
        String ending = "png";
        this.stack.open(dir, basename, ending);
        this.preview = new ImagePlus("Preview", this.stack.getPreview());
        this.preview.show();
    }

    public void addFrame() {
        int index = this.preview.getCurrentSlice();
        this.stack.addSlice(index, null);
        this.preview.setSlice(index + 1);
        this.preview.updateAndDraw();
    }

    public void copyFrame() {
        int index = this.preview.getCurrentSlice();
        ImageProcessor ip = this.stack.getProcessor(index);
        this.stack.addSlice(index, ip);
        this.preview.setSlice(index + 1);
        this.preview.updateAndDraw();
    }

    public void openFrame() {
        int index = this.preview.getCurrentSlice();
        ImageProcessor ip = this.stack.getProcessor(index);
        new ImagePlus(this.stack.getPreview().getSliceLabel(index), ip).show();
    }

    public void setFrame() {
        int index = this.preview.getCurrentSlice();
        if (!IJ.getImage().getTitle().equals(this.stack.getPreview().getSliceLabel(index))) {
            return;
        }
        ImageProcessor ip = IJ.getImage().getProcessor();
        this.stack.setSlice(index, ip);
        IJ.getImage().changes = false;
        IJ.getImage().close();
        this.preview.setStack(null, this.stack.getPreview());
        this.preview.setSlice(index);
    }

    public void deleteFrame() {
        int index = this.preview.getCurrentSlice();
        this.stack.deleteSlice(index);
        this.preview.setStack(null, this.stack.getPreview());
        this.preview.setSlice(index);
    }

    public void fadeOver() {
        this.fade(20);
    }

    public void drawLine() {
        int index = this.preview.getCurrentSlice();
        ImagePlus frame = IJ.getImage();
        if (!frame.getTitle().equals(this.stack.getPreview().getSliceLabel(index))) {
            return;
        }
        Roi roi = frame.getRoi();
        if (roi == null || roi.getType() != 5) {
            return;
        }
        Line line = (Line)roi;
        int i = this.drawLine(line.x1, line.y1, line.x2, line.y2, this.speed);
        this.preview.setSlice(index + i);
        frame.changes = false;
        frame.close();
    }

    public void drawRoi() {
        int index = this.preview.getCurrentSlice();
        ImagePlus frame = IJ.getImage();
        if (!frame.getTitle().equals(this.stack.getPreview().getSliceLabel(index))) {
            IJ.error((String)"frame name and preview slice are not the same");
            return;
        }
        Roi roi = frame.getRoi();
        if (roi == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Roi[] rois = null;
        if (roi.getType() == 9) {
            rois = ((ShapeRoi)roi).getRois();
        } else if (roi instanceof PolygonRoi) {
            rois = new Roi[]{roi};
        } else {
            IJ.error((String)"Composite or polygon roi required");
            return;
        }
        int c = 0;
        for (int i = 0; i < rois.length; ++i) {
            if (!(rois[i] instanceof PolygonRoi)) continue;
            this.preview.setSlice(index + (c += this.drawRoi(rois[i], this.speed)));
        }
        frame.changes = false;
        frame.close();
    }

    public void fillRoiTransparent() {
        int index = this.preview.getCurrentSlice();
        ImagePlus frame = IJ.getImage();
        if (!frame.getTitle().equals(this.stack.getPreview().getSliceLabel(index))) {
            return;
        }
        Roi roi = frame.getRoi();
        if (roi == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Roi[] rois = null;
        if (roi.getType() == 9) {
            rois = ((ShapeRoi)roi).getRois();
        } else if (roi instanceof PolygonRoi) {
            rois = new Roi[]{roi};
        } else {
            IJ.error((String)"Composite or polygon roi required");
            return;
        }
        for (int i = 0; i < rois.length; ++i) {
            if (!(rois[i] instanceof PolygonRoi)) continue;
            this.fillRoiTransparent(rois[i]);
        }
        frame.changes = false;
        frame.close();
    }

    public void drawOval() {
        int index = this.preview.getCurrentSlice();
        ImagePlus frame = IJ.getImage();
        if (!frame.getTitle().equals(this.stack.getPreview().getSliceLabel(index))) {
            return;
        }
        Roi roi = frame.getRoi();
        if (roi == null || roi.getType() != 1) {
            return;
        }
        Rectangle r = roi.getBounds();
        this.drawCircle(r.x, r.y, r.width, r.height);
        frame.changes = false;
        frame.close();
    }

    public void moveSelection() {
        int index = this.preview.getCurrentSlice();
        ImagePlus frame = IJ.getImage();
        if (!frame.getTitle().equals(this.stack.getPreview().getSliceLabel(index))) {
            return;
        }
        Roi roi = frame.getRoi();
        if (roi == null) {
            return;
        }
        GenericDialog gd = new GenericDialog("Move selection");
        gd.addNumericField("dx", 0.0, 0);
        gd.addNumericField("dy", 0.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.moveSelection(roi, (int)gd.getNextNumber(), (int)gd.getNextNumber());
        frame.changes = false;
        frame.close();
    }

    public void moveSelection(Roi roi, int dx, int dy) {
        int x = roi.getBounds().x;
        int y = roi.getBounds().y;
        int index = this.preview.getCurrentSlice();
        int dt = dx > dy ? dx : dy;
        ImageProcessor ip = this.stack.getProcessor(index);
        ip.setRoi(roi);
        ImageProcessor copy = ip.crop();
        for (int i = 0; i < dt; ++i) {
            int xt = x + Math.round((float)i * (float)dx / (float)dt);
            int yt = y + Math.round((float)i * (float)dy / (float)dt);
            ImageProcessor ip2 = ip.duplicate();
            ip2.snapshot();
            roi.setLocation(xt, yt);
            ip2.setRoi(roi);
            ip2.copyBits(copy, xt, yt, 14);
            ip2.reset(ip2.getMask());
            if (!this.stack.addSlice(index + i, ip2)) break;
        }
    }

    public void drawCircle(int x, int y, int w, int h) {
        int index = this.preview.getCurrentSlice();
        Ellipse2D.Float e = new Ellipse2D.Float(x, y, w, h);
        float[] v = new float[6];
        boolean finished = false;
        ImageProcessor ip = this.stack.getProcessor(index);
        int z = 0;
        while (!finished) {
            ip = ip.convertToRGB();
            ip.setValue((double)this.color);
            ip.setLineWidth(this.linewidth);
            FlatteningPathIterator it = new FlatteningPathIterator(e.getPathIterator(null), 1.0);
            it.currentSegment(v);
            ip.moveTo((int)v[0], (int)v[1]);
            it.next();
            for (int i = 0; i < z; ++i) {
                it.currentSegment(v);
                ip.lineTo((int)v[0], (int)v[1]);
                it.next();
                finished = it.isDone();
            }
            if (!this.stack.addSlice(index + z, ip)) break;
            ++z;
        }
    }

    public int drawRoi(Roi roi, int speed) {
        int index = this.preview.getCurrentSlice();
        Polygon poly = ((PolygonRoi)roi).getPolygon();
        int n = poly.npoints;
        int[] x = poly.xpoints;
        int[] y = poly.ypoints;
        int x_last = x[0];
        int y_last = y[0];
        ImageProcessor ip = this.stack.getProcessor(index);
        ip = ip.convertToRGB();
        LineIterator li = new LineIterator();
        int c = -1;
        int slicesInserted = 0;
        block0: for (int z = 0; z < n; ++z) {
            li.init(x[z], y[z], x[(z + 1) % n], y[(z + 1) % n]);
            while (li.next() != null) {
                ++c;
                ip.setValue((double)this.color);
                ip.setLineWidth(this.linewidth);
                ip.moveTo(x_last, y_last);
                x_last = (int)li.x;
                y_last = (int)li.y;
                ip.lineTo(x_last, y_last);
                if (speed == -1 || c % speed != 0) continue;
                if (!this.stack.addSlice(index + slicesInserted, ip)) continue block0;
                ++slicesInserted;
                ip = ip.duplicate();
            }
        }
        if (speed == -1) {
            this.stack.setSlice(index, ip);
            return 0;
        }
        if (c % speed != 0 && this.stack.addSlice(index + slicesInserted, ip)) {
            ++slicesInserted;
        }
        return slicesInserted;
    }

    public int drawLine(int x1, int y1, int x2, int y2, int speed) {
        int index = this.preview.getCurrentSlice();
        int slicesInserted = 0;
        ImageProcessor ip = this.stack.getProcessor(index);
        ip = ip.convertToRGB();
        ip.setValue((double)this.color);
        ip.setLineWidth(this.linewidth);
        LineIterator li = new LineIterator(x1, y1, x2, y2);
        int z = -1;
        int x_last = x1;
        int y_last = y1;
        while (li.next() != null) {
            ++z;
            ip.setValue((double)this.color);
            ip.setLineWidth(this.linewidth);
            ip.moveTo(x_last, y_last);
            x_last = (int)li.x;
            y_last = (int)li.y;
            ip.lineTo(x_last, y_last);
            if (speed == -1 || z % speed != 0) continue;
            if (!this.stack.addSlice(index + slicesInserted, ip)) break;
            ++slicesInserted;
            ip = ip.duplicate();
        }
        if (speed == -1) {
            this.stack.setSlice(index, ip);
            return 0;
        }
        if (z % speed != 0 && this.stack.addSlice(index + slicesInserted, ip)) {
            ++slicesInserted;
        }
        return slicesInserted;
    }

    public void fillRoiTransparent(Roi roi) {
        int index = this.preview.getCurrentSlice();
        Polygon poly = ((PolygonRoi)roi).getPolygon();
        ImageProcessor ip = this.stack.getProcessor(index);
        ip = ip.convertToRGB();
        BufferedImage bi = (BufferedImage)ip.createImage();
        Graphics2D g = bi.createGraphics();
        Color col = new Color(this.color);
        col = new Color(col.getRed(), col.getGreen(), col.getBlue(), this.alpha);
        g.setColor(col);
        g.fill(poly);
        g.dispose();
        this.stack.setSlice(index, ip);
    }

    public void fade(int numSlices) {
        int index = this.preview.getCurrentSlice();
        int[] before = (int[])this.stack.getProcessor(index).convertToRGB().getPixels();
        int[] after = (int[])this.stack.getProcessor(index + 1).convertToRGB().getPixels();
        for (int z = 1; z < numSlices; ++z) {
            ColorProcessor bp = new ColorProcessor(this.stack.getWidth(), this.stack.getHeight());
            int[] pixels = (int[])bp.getPixels();
            double dp = z;
            double dn = numSlices - z;
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = this.interpolate(before[i], dp, after[i], dn);
            }
            if (!this.stack.addSlice(index + z - 1, (ImageProcessor)bp)) break;
        }
        this.preview.setSlice(this.preview.getCurrentSlice() + numSlices);
    }

    public void createAVI() {
        int w = this.stack.getWidth();
        int h = this.stack.getHeight();
        int obr = 1250 * w * h / 256;
        String opt = "vbitrate=" + obr + ":mbd=2:keyint=132:vqblur=1.0:cmp=2:subcmp=2:dia=2:mv0:last_pred=3";
        String codec = "msmpeg4v2";
        File cwd = new File(this.stack.getDir());
        new File(cwd, "divx2pass.log").delete();
        new File(cwd, "frameno.avi").delete();
        try {
            String cmd = "mencoder -ovc lavc -lavcopts vcodec=" + codec + ":vpass=1:" + opt + " -mf type=png:w=" + w + ":h=" + h + ":fps=25 -nosound -o /dev/null mf://*.png";
            Process pro = Runtime.getRuntime().exec(cmd, null, cwd);
            pro.waitFor();
            cmd = "mencoder -ovc lavc -lavcopts vcodec=" + codec + ":vpass=2:" + opt + " -mf type=png:w=" + w + ":h=" + h + ":fps=25 -nosound -o output.avi mf://*.png";
            pro = Runtime.getRuntime().exec(cmd, null, cwd);
            pro.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void playAVI() {
        String cmd = "mplayer -loop 0 output.avi";
        File cwd = new File(this.stack.getDir());
        try {
            Process pro = Runtime.getRuntime().exec(cmd, null, cwd);
            pro.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int interpolate(int p, double dp, int n, double dn) {
        int rp = (p & 0xFF0000) >> 16;
        int rn = (n & 0xFF0000) >> 16;
        int gp = (p & 0xFF00) >> 8;
        int gn = (n & 0xFF00) >> 8;
        int bp = p & 0xFF;
        int bn = n & 0xFF;
        byte r_int = (byte)(((double)rn * dp + (double)rp * dn) / (dn + dp));
        byte g_int = (byte)(((double)gn * dp + (double)gp * dn) / (dn + dp));
        byte b_int = (byte)(((double)bn * dp + (double)bp * dn) / (dn + dp));
        return ((r_int & 0xFF) << 16) + ((g_int & 0xFF) << 8) + (b_int & 0xFF);
    }

    private static final Shape roiToShape(Roi roi) {
        Shape shape = null;
        Rectangle r = roi.getBounds();
        int[] xCoords = null;
        int[] yCoords = null;
        int nCoords = 0;
        switch (roi.getType()) {
            case 5: {
                Line line = (Line)roi;
                shape = new Line2D.Double(line.x1 - r.x, line.y1 - r.y, line.x2 - r.x, line.y2 - r.y);
                break;
            }
            case 0: {
                shape = new Rectangle2D.Double(0.0, 0.0, r.width, r.height);
                break;
            }
            case 1: {
                Polygon p = roi.getPolygon();
                int i = 0;
                while (i < p.npoints) {
                    int n = i;
                    p.xpoints[n] = p.xpoints[n] - r.x;
                    int n2 = i++;
                    p.ypoints[n2] = p.ypoints[n2] - r.y;
                }
                break;
            }
            case 2: {
                nCoords = ((PolygonRoi)roi).getNCoordinates();
                xCoords = ((PolygonRoi)roi).getXCoordinates();
                yCoords = ((PolygonRoi)roi).getYCoordinates();
                shape = new Polygon(xCoords, yCoords, nCoords);
                break;
            }
            case 3: 
            case 4: {
                nCoords = ((PolygonRoi)roi).getNCoordinates();
                xCoords = ((PolygonRoi)roi).getXCoordinates();
                yCoords = ((PolygonRoi)roi).getYCoordinates();
                shape = new GeneralPath(0, nCoords);
                ((GeneralPath)shape).moveTo(xCoords[0], yCoords[0]);
                for (int i = 1; i < nCoords; ++i) {
                    ((GeneralPath)shape).lineTo(xCoords[i], yCoords[i]);
                }
                ((GeneralPath)shape).closePath();
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                nCoords = ((PolygonRoi)roi).getNCoordinates();
                xCoords = ((PolygonRoi)roi).getXCoordinates();
                yCoords = ((PolygonRoi)roi).getYCoordinates();
                shape = new GeneralPath(1, nCoords);
                ((GeneralPath)shape).moveTo(xCoords[0], yCoords[0]);
                for (int i = 1; i < nCoords; ++i) {
                    ((GeneralPath)shape).lineTo(xCoords[i], yCoords[i]);
                }
                break;
            }
            case 10: {
                ImageProcessor mask = roi.getMask();
                byte[] maskPixels = (byte[])mask.getPixels();
                Rectangle maskBounds = roi.getBounds();
                int maskWidth = mask.getWidth();
                Area area = new Area();
                for (int y = 0; y < mask.getHeight(); ++y) {
                    int yOffset = y * maskWidth;
                    for (int x = 0; x < maskWidth; ++x) {
                        if (maskPixels[x + yOffset] == 0) continue;
                        area.add(new Area(new Rectangle(x + maskBounds.x, y + maskBounds.y, 1, 1)));
                    }
                }
                shape = area;
                break;
            }
            default: {
                throw new IllegalArgumentException("Roi type not supported");
            }
        }
        return shape;
    }

    private class BorderPanel
    extends Panel {
        final Color BC = new Color(139, 142, 255);

        private BorderPanel() {
        }

        @Override
        public Insets getInsets() {
            return new Insets(10, 10, 10, 10);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.getWidth() == 0 || this.getHeight() == 0) {
                return;
            }
            g.setColor(this.BC);
            g.drawRect(5, 5, this.getWidth() - 10, this.getHeight() - 10);
        }
    }

    private class LineIterator {
        int x1;
        int y1;
        int x2;
        int y2;
        int dx;
        int dy;
        boolean finished;
        double x;
        double y;
        double dx_dt;
        double dy_dt;

        public LineIterator() {
        }

        public LineIterator(int x1, int y1, int x2, int y2) {
            this.init(x1, y1, x2, y2);
        }

        public void init(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
            this.x = x1;
            this.y = y1;
            this.dx = x2 - x1;
            this.dy = y2 - y1;
            int dt = Math.abs(this.dx) > Math.abs(this.dy) ? this.dx : this.dy;
            if ((dt = Math.abs(dt)) == 0) {
                dt = 1;
            }
            this.dx_dt = (double)this.dx / (double)dt;
            this.dy_dt = (double)this.dy / (double)dt;
            this.dx = Math.abs(this.dx);
            this.dy = Math.abs(this.dy);
            this.finished = false;
        }

        public LineIterator next() {
            if (this.finished) {
                return null;
            }
            this.x += this.dx_dt;
            this.y += this.dy_dt;
            boolean bl = this.finished = Math.abs((int)this.x - this.x1) >= this.dx && Math.abs((int)this.y - this.y1) >= this.dy;
            if (this.finished) {
                this.x = this.x2;
                this.y = this.y2;
            }
            return this;
        }
    }
}

