/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.macro.ExtensionDescriptor;
import ij.macro.Functions;
import ij.macro.MacroExtension;
import ij.plugin.PlugIn;
import javax.swing.JFrame;
import org.imagearchive.lsm.toolbox.BatchConverter;
import org.imagearchive.lsm.toolbox.DomXmlExporter;
import org.imagearchive.lsm.toolbox.MasterModel;
import org.imagearchive.lsm.toolbox.Reader;
import org.imagearchive.lsm.toolbox.ServiceMediator;
import org.imagearchive.lsm.toolbox.StampUtils;
import org.imagearchive.lsm.toolbox.gui.AboutDialog;
import org.imagearchive.lsm.toolbox.gui.ControlPanelFrame;

public class LSM_Toolbox
implements PlugIn,
MacroExtension {
    public MasterModel masterModel = MasterModel.getMasterModel();
    public final String infoMessage = "LSM_Toolbox" + MasterModel.VERSION + " Copyright (C) 2002-2010 P. Pirrotte, J. Mutterer\n\nThis software is subject to the GNU General Public License\nPlease read LICENSE or read source code information headers\nWorks on images generated by LSM 510 version 2.8 to 4.0\nContacts :\npatrick@image-archive.org and jerome.mutterer@ibmp-ulp.u-strasbg.fr\n";
    private final ExtensionDescriptor[] extensions = new ExtensionDescriptor[]{ExtensionDescriptor.newDescriptor((String)"lsmXML", (MacroExtension)this, (int)17), ExtensionDescriptor.newDescriptor((String)"getTStamps", (MacroExtension)this, (int)17), ExtensionDescriptor.newDescriptor((String)"getZStamps", (MacroExtension)this, (int)17), ExtensionDescriptor.newDescriptor((String)"getLStamps", (MacroExtension)this, (int)17), ExtensionDescriptor.newDescriptor((String)"getEvents", (MacroExtension)this, (int)17), ExtensionDescriptor.newDescriptor((String)"lsmOpen", (MacroExtension)this, (int)1)};
    public ControlPanelFrame controlPanel;

    public void run(String args) {
        IJ.register(LSM_Toolbox.class);
        MasterModel.debugMode = IJ.debugMode;
        if (args.equals("about")) {
            new AboutDialog(new JFrame(), this.masterModel).setVisible(true);
            return;
        }
        if (IJ.versionLessThan((String)"1.41a")) {
            return;
        }
        String fileName = "";
        String macroOptions = Macro.getOptions();
        if (IJ.macroRunning() && macroOptions.trim().equalsIgnoreCase("ext")) {
            Functions.registerExtensions((MacroExtension)this);
            return;
        }
        if (!args.equals("")) {
            fileName = this.getMacroOption("file=", args);
        }
        if (macroOptions != null && !macroOptions.equals("")) {
            fileName = this.getMacroOption("file=", macroOptions).trim();
        }
        if (!fileName.equals("") && fileName.endsWith(".lsm")) {
            String fn = fileName;
            Reader reader = ServiceMediator.getReader();
            try {
                IJ.showStatus((String)"Loading image");
                ImagePlus imp = reader.open(fn, true);
                IJ.showStatus((String)"Image loaded");
                if (imp == null) {
                    return;
                }
                imp.setPosition(1, 1, 1);
                imp.show();
            }
            catch (OutOfMemoryError e) {
                IJ.outOfMemory((String)"Could not load lsm image.");
            }
        } else if (fileName.endsWith(".csv")) {
            BatchConverter converter = new BatchConverter(this.masterModel);
            converter.convertBatchFile(args);
        } else if (args.equals("")) {
            this.controlPanel = new ControlPanelFrame(this.masterModel);
            this.controlPanel.initializeGUI();
        }
    }

    public String getMacroOption(String tag, String options) {
        int index = options.indexOf(tag);
        if (index == -1) {
            return null;
        }
        return options.substring(index + 5, options.length());
    }

    public static void open(String args) {
        new LSM_Toolbox().run(args);
    }

    public static String getXML(String filename, boolean filter) {
        return new DomXmlExporter().getXML(filename, filter);
    }

    public ExtensionDescriptor[] getExtensionFunctions() {
        return this.extensions;
    }

    public String handleExtension(String name, Object[] args) {
        Object o = args[0];
        if (name.equals("lsmXML")) {
            if (o == null) {
                return null;
            }
            String[] a = (String[])o;
            return new DomXmlExporter().getXML(a[0], false);
        }
        if (name.equals("lsmOpen")) {
            if (o == null) {
                return null;
            }
            ImagePlus imp = ServiceMediator.getReader().open((String)o, false);
            if (imp == null) {
                return null;
            }
            imp.setPosition(1, 1, 1);
            imp.show();
            return null;
        }
        if (name.equals("getTStamps")) {
            if (o == null) {
                return null;
            }
            String[] a = (String[])o;
            Reader reader = ServiceMediator.getReader();
            ImagePlus imp = reader.open(a[0], false);
            if (imp == null) {
                return null;
            }
            return StampUtils.getTStamps(reader, imp);
        }
        if (name.equals("getLStamps")) {
            if (o == null) {
                return null;
            }
            String[] a = (String[])o;
            Reader reader = ServiceMediator.getReader();
            ImagePlus imp = reader.open(a[0], false);
            return StampUtils.getLStamps(reader, imp);
        }
        if (name.equals("getZStamps")) {
            if (o == null) {
                return null;
            }
            String[] a = (String[])o;
            Reader reader = ServiceMediator.getReader();
            ImagePlus imp = reader.open(a[0], false);
            if (imp == null) {
                return null;
            }
            return StampUtils.getZStamps(reader, imp);
        }
        if (name.equals("getEvents")) {
            if (o == null) {
                return null;
            }
            String[] a = (String[])o;
            Reader reader = ServiceMediator.getReader();
            ImagePlus imp = reader.open(a[0], false);
            if (imp == null) {
                return null;
            }
            return StampUtils.getEvents(reader, imp);
        }
        return null;
    }
}

